/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.qmf;

import java.util.Collection;
import org.wso2.andes.qmf.QMFClass;
import org.wso2.andes.qmf.QMFCommand;
import org.wso2.andes.qmf.QMFCommandHeader;
import org.wso2.andes.qmf.QMFMethod;
import org.wso2.andes.qmf.QMFOperation;
import org.wso2.andes.qmf.QMFProperty;
import org.wso2.andes.qmf.QMFSchemaRequestCommand;
import org.wso2.andes.qmf.QMFStatistic;
import org.wso2.andes.transport.codec.BBEncoder;

public class QMFSchemaResponseCommand
extends QMFCommand {
    private final QMFClass _qmfClass;

    public QMFSchemaResponseCommand(QMFSchemaRequestCommand qmfSchemaRequestCommand, QMFClass qmfClass) {
        super(new QMFCommandHeader(qmfSchemaRequestCommand.getHeader().getVersion(), qmfSchemaRequestCommand.getHeader().getSeq(), QMFOperation.SCHEMA_RESPONSE));
        this._qmfClass = qmfClass;
    }

    @Override
    public void encode(BBEncoder encoder) {
        super.encode(encoder);
        encoder.writeUint8(this._qmfClass.getType().getValue());
        encoder.writeStr8(this._qmfClass.getPackage().getName());
        encoder.writeStr8(this._qmfClass.getName());
        encoder.writeBin128(this._qmfClass.getSchemaHash());
        Collection<QMFProperty> props = this._qmfClass.getProperties();
        Collection<QMFStatistic> stats = this._qmfClass.getStatistics();
        Collection<QMFMethod> methods = this._qmfClass.getMethods();
        encoder.writeUint16(props.size());
        if (this._qmfClass.getType() == QMFClass.Type.OBJECT) {
            encoder.writeUint16(stats.size());
            encoder.writeUint16(methods.size());
        }
        for (QMFProperty prop : props) {
            prop.encode(encoder);
        }
        if (this._qmfClass.getType() == QMFClass.Type.OBJECT) {
            for (QMFStatistic stat : stats) {
                stat.encode(encoder);
            }
            for (QMFMethod method : methods) {
                method.encode(encoder);
            }
        }
    }
}

