/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.qmf;

import java.util.ArrayList;
import org.wso2.andes.AMQException;
import org.wso2.andes.qmf.QMFClass;
import org.wso2.andes.qmf.QMFCommand;
import org.wso2.andes.qmf.QMFCommandCompletionCommand;
import org.wso2.andes.qmf.QMFCommandHeader;
import org.wso2.andes.qmf.QMFMessage;
import org.wso2.andes.qmf.QMFPackage;
import org.wso2.andes.qmf.QMFSchemaResponseCommand;
import org.wso2.andes.qmf.QMFService;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.transport.codec.BBDecoder;

public class QMFSchemaRequestCommand
extends QMFCommand {
    private final String _packageName;
    private final String _className;
    private final byte[] _hash;

    public QMFSchemaRequestCommand(QMFCommandHeader header, BBDecoder decoder) {
        super(header);
        this._packageName = decoder.readStr8();
        this._className = decoder.readStr8();
        this._hash = decoder.readBin128();
    }

    @Override
    public void process(VirtualHost virtualHost, ServerMessage message) {
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String routingKey = message.getMessageHeader().getReplyToRoutingKey();
        IApplicationRegistry appRegistry = virtualHost.getApplicationRegistry();
        QMFService service = appRegistry.getQMFService();
        QMFPackage qmfPackage = service.getPackage(this._packageName);
        QMFClass qmfClass = qmfPackage.getQMFClass(this._className);
        QMFCommand[] commands = new QMFCommand[]{new QMFSchemaResponseCommand(this, qmfClass), new QMFCommandCompletionCommand(this)};
        Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
        for (QMFCommand cmd : commands) {
            QMFMessage responseMessage = new QMFMessage(routingKey, cmd);
            ArrayList<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

