/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.qmf;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.andes.qmf.QMFClass;
import org.wso2.andes.qmf.QMFType;
import org.wso2.andes.transport.codec.Encoder;

public class QMFProperty {
    private final Map<String, Object> _map = new LinkedHashMap<String, Object>();
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String ACCESS = "access";
    private static final String INDEX = "index";
    private static final String OPTIONAL = "optional";
    private static final String REF_PACKAGE = "refPackage";
    private static final String REF_CLASS = "refClass";
    private static final String UNIT = "unit";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String MAX_LENGTH = "maxlen";
    private static final String DESCRIPTION = "desc";

    public QMFProperty(String name, QMFType type, AccessCode accessCode, boolean index, boolean optional) {
        this._map.put(NAME, name);
        this._map.put(TYPE, type.codeValue());
        this._map.put(ACCESS, accessCode.codeValue());
        this._map.put(INDEX, index ? 1 : 0);
        this._map.put(OPTIONAL, optional ? 1 : 0);
    }

    public void setQMFClass(QMFClass qmfClass) {
    }

    public void setReferencedClass(String refClass) {
        this._map.put(REF_CLASS, refClass);
    }

    public void setReferencedPackage(String refPackage) {
        this._map.put(REF_CLASS, refPackage);
    }

    public String getName() {
        return (String)this._map.get(NAME);
    }

    public void setUnit(String unit) {
        this._map.put(UNIT, unit);
    }

    public void setMin(Number min) {
        this._map.put(MIN, min);
    }

    public void setMax(Number max) {
        this._map.put(MAX, max);
    }

    public void setMaxLength(int maxlen) {
        this._map.put(MAX_LENGTH, maxlen);
    }

    public void setDescription(String description) {
        this._map.put(DESCRIPTION, description);
    }

    public void encode(Encoder encoder) {
        encoder.writeMap(this._map);
    }

    public static enum AccessCode {
        RC,
        RW,
        RO;


        public int codeValue() {
            return this.ordinal() + 1;
        }
    }
}

