/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.qmf;

import java.util.ArrayList;
import java.util.Collection;
import org.wso2.andes.AMQException;
import org.wso2.andes.qmf.QMFCommand;
import org.wso2.andes.qmf.QMFCommandCompletionCommand;
import org.wso2.andes.qmf.QMFCommandHeader;
import org.wso2.andes.qmf.QMFMessage;
import org.wso2.andes.qmf.QMFPackage;
import org.wso2.andes.qmf.QMFPackageIndicationCommand;
import org.wso2.andes.qmf.QMFService;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.transport.codec.BBDecoder;

public class QMFPackageQueryCommand
extends QMFCommand {
    public QMFPackageQueryCommand(QMFCommandHeader header, BBDecoder decoder) {
        super(header);
    }

    @Override
    public void process(VirtualHost virtualHost, ServerMessage message) {
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String routingKey = message.getMessageHeader().getReplyToRoutingKey();
        IApplicationRegistry appRegistry = virtualHost.getApplicationRegistry();
        QMFService service = appRegistry.getQMFService();
        Collection<QMFPackage> supportedSchemas = service.getSupportedSchemas();
        QMFCommand[] commands = new QMFCommand[supportedSchemas.size() + 1];
        int i = 0;
        for (QMFPackage p : supportedSchemas) {
            commands[i++] = new QMFPackageIndicationCommand(this, p.getName());
        }
        commands[commands.length - 1] = new QMFCommandCompletionCommand(this);
        for (QMFCommand cmd : commands) {
            QMFMessage responseMessage = new QMFMessage(routingKey, cmd);
            Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
            ArrayList<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

