/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.qmf;

import java.util.ArrayList;
import java.util.UUID;
import org.wso2.andes.AMQException;
import org.wso2.andes.qmf.QMFClass;
import org.wso2.andes.qmf.QMFCommand;
import org.wso2.andes.qmf.QMFCommandCompletionCommand;
import org.wso2.andes.qmf.QMFCommandHeader;
import org.wso2.andes.qmf.QMFMessage;
import org.wso2.andes.qmf.QMFMethod;
import org.wso2.andes.qmf.QMFMethodInvocation;
import org.wso2.andes.qmf.QMFObject;
import org.wso2.andes.qmf.QMFPackage;
import org.wso2.andes.qmf.QMFService;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.transport.codec.BBDecoder;

public class QMFMethodRequestCommand
extends QMFCommand {
    private QMFMethodInvocation _methodInstance;
    private QMFObject _object;

    public QMFMethodRequestCommand(QMFCommandHeader header, BBDecoder decoder, QMFService qmfService) {
        super(header);
        UUID objectId = decoder.readUuid();
        String packageName = decoder.readStr8();
        String className = decoder.readStr8();
        byte[] hash = decoder.readBin128();
        String methodName = decoder.readStr8();
        QMFPackage qmfPackage = qmfService.getPackage(packageName);
        QMFClass qmfClass = qmfPackage.getQMFClass(className);
        this._object = qmfService.getObjectById(qmfClass, objectId);
        QMFMethod method = qmfClass.getMethod(methodName);
        this._methodInstance = method.parse(decoder);
    }

    @Override
    public void process(VirtualHost virtualHost, ServerMessage message) {
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String queueName = message.getMessageHeader().getReplyToRoutingKey();
        QMFCommand[] commands = new QMFCommand[]{this._methodInstance.execute(this._object, this), new QMFCommandCompletionCommand(this)};
        Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
        for (QMFCommand cmd : commands) {
            QMFMessage responseMessage = new QMFMessage(queueName, cmd);
            ArrayList<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

