/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.qmf;

import java.nio.ByteBuffer;
import java.util.Set;
import org.wso2.andes.configuration.qpid.SessionConfig;
import org.wso2.andes.qmf.QMFCommand;
import org.wso2.andes.server.message.AMQMessageHeader;
import org.wso2.andes.server.message.InboundMessage;
import org.wso2.andes.server.message.MessageReference;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.transport.codec.BBEncoder;

public class QMFMessage
implements ServerMessage,
InboundMessage,
AMQMessageHeader {
    private ByteBuffer _content;
    private String _routingKey;

    public QMFMessage(String routingKey, QMFCommand command) {
        this(routingKey, new QMFCommand[]{command});
    }

    public QMFMessage(String routingKey, QMFCommand[] commands) {
        this._routingKey = routingKey;
        BBEncoder encoder = new BBEncoder(256);
        for (QMFCommand cmd : commands) {
            cmd.encode(encoder);
        }
        this._content = encoder.buffer();
    }

    @Override
    public String getRoutingKey() {
        return this._routingKey;
    }

    @Override
    public AMQMessageHeader getMessageHeader() {
        return this;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean isRedelivered() {
        return false;
    }

    @Override
    public long getSize() {
        return this._content.limit();
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getCorrelationId() {
        return null;
    }

    @Override
    public long getExpiration() {
        return 0L;
    }

    @Override
    public String getMessageId() {
        return null;
    }

    @Override
    public String getMimeType() {
        return null;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public byte getPriority() {
        return 4;
    }

    @Override
    public long getTimestamp() {
        return 0L;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getReplyTo() {
        return null;
    }

    @Override
    public String getReplyToExchange() {
        return null;
    }

    @Override
    public String getReplyToRoutingKey() {
        return null;
    }

    @Override
    public Object getHeader(String name) {
        return null;
    }

    @Override
    public boolean containsHeaders(Set<String> names) {
        return false;
    }

    @Override
    public boolean containsHeader(String name) {
        return false;
    }

    @Override
    public MessageReference newReference() {
        return new QMFMessageReference(this);
    }

    @Override
    public Long getMessageNumber() {
        return null;
    }

    @Override
    public long getArrivalTime() {
        return 0L;
    }

    @Override
    public int getContent(ByteBuffer buf, int offset) {
        ByteBuffer src = this._content.duplicate();
        this._content.position(offset);
        this._content = this._content.slice();
        int len = this._content.remaining();
        if (len > buf.remaining()) {
            len = buf.remaining();
        }
        buf.put(src);
        return len;
    }

    @Override
    public SessionConfig getSessionConfig() {
        return null;
    }

    private static class QMFMessageReference
    extends MessageReference<QMFMessage> {
        public QMFMessageReference(QMFMessage message) {
            super(message);
        }

        @Override
        protected void onReference(QMFMessage message) {
        }

        @Override
        protected void onRelease(QMFMessage message) {
        }
    }
}

