/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.qmf;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wso2.andes.qmf.QMFMethod;
import org.wso2.andes.qmf.QMFPackage;
import org.wso2.andes.qmf.QMFProperty;
import org.wso2.andes.qmf.QMFStatistic;

public abstract class QMFClass {
    private final Type _type;
    private QMFPackage _package;
    private final String _name;
    private byte[] _schemaHash;
    private Map<String, QMFProperty> _properties = new LinkedHashMap<String, QMFProperty>();
    private Map<String, QMFStatistic> _statistics = new LinkedHashMap<String, QMFStatistic>();
    private Map<String, QMFMethod> _methods = new LinkedHashMap<String, QMFMethod>();

    public QMFClass(Type type, String name, byte[] schemaHash, List<QMFProperty> properties, List<QMFStatistic> statistics, List<QMFMethod> methods) {
        this(type, name, schemaHash);
        this.setProperties(properties);
        this.setStatistics(statistics);
        this.setMethods(methods);
    }

    public QMFClass(Type type, String name, byte[] schemaHash) {
        this._type = type;
        this._name = name;
        this._schemaHash = schemaHash;
    }

    protected void setProperties(List<QMFProperty> properties) {
        for (QMFProperty prop : properties) {
            this._properties.put(prop.getName(), prop);
        }
    }

    protected void setStatistics(List<QMFStatistic> statistics) {
        for (QMFStatistic stat : statistics) {
            this._statistics.put(stat.getName(), stat);
        }
    }

    protected void setMethods(List<QMFMethod> methods) {
        for (QMFMethod method : methods) {
            this._methods.put(method.getName(), method);
        }
    }

    public void setPackage(QMFPackage aPackage) {
        this._package = aPackage;
        for (QMFProperty prop : this._properties.values()) {
            prop.setQMFClass(this);
        }
    }

    public Type getType() {
        return this._type;
    }

    public QMFPackage getPackage() {
        return this._package;
    }

    public String getName() {
        return this._name;
    }

    public byte[] getSchemaHash() {
        return this._schemaHash;
    }

    public Collection<QMFProperty> getProperties() {
        return this._properties.values();
    }

    public Collection<QMFStatistic> getStatistics() {
        return this._statistics.values();
    }

    public Collection<QMFMethod> getMethods() {
        return this._methods.values();
    }

    public QMFMethod getMethod(String methodName) {
        return this._methods.get(methodName);
    }

    public static enum Type {
        OBJECT(1),
        EVENT(2);

        private final byte _value;

        private Type(byte value) {
            this._value = value;
        }

        public byte getValue() {
            return this._value;
        }
    }
}

