/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.qmf;

import java.util.ArrayList;
import org.wso2.andes.AMQException;
import org.wso2.andes.qmf.QMFBrokerResponseCommand;
import org.wso2.andes.qmf.QMFCommand;
import org.wso2.andes.qmf.QMFCommandCompletionCommand;
import org.wso2.andes.qmf.QMFCommandHeader;
import org.wso2.andes.qmf.QMFMessage;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.transport.codec.BBDecoder;

public class QMFBrokerRequestCommand
extends QMFCommand {
    public QMFBrokerRequestCommand(QMFCommandHeader header, BBDecoder buf) {
        super(header);
    }

    @Override
    public void process(VirtualHost virtualHost, ServerMessage message) {
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String queueName = message.getMessageHeader().getReplyToRoutingKey();
        QMFCommand[] commands = new QMFCommand[]{new QMFBrokerResponseCommand(this, virtualHost), new QMFCommandCompletionCommand(this)};
        Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
        for (QMFCommand cmd : commands) {
            QMFMessage responseMessage = new QMFMessage(queueName, cmd);
            ArrayList<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

