/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.mqtt.utils;

import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.SubscriptionsStore;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;
import org.dna.mqtt.wso2.QOSLevel;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.disruptor.inbound.PubAckHandler;
import org.wso2.andes.mqtt.MQTTMessageContext;
import org.wso2.andes.mqtt.MQTTPublisherChannel;
import org.wso2.andes.server.store.MessageMetaDataType;

public class MQTTUtils {
    private static Log log = LogFactory.getLog(MQTTUtils.class);
    public static final String MESSAGE_ID = "MessageID";
    public static final String MQTT_EXCHANGE_NAME = "mqtt.topic";
    private static final String TOPIC = "Topic";
    public static final String ARRIVAL_TIME = "ArrivalTime";
    private static final String DESTINATION = "Destination";
    private static final String PERSISTENCE = "Persistent";
    private static final String MESSAGE_CONTENT_LENGTH = "MessageContentLength";
    public static final String QOSLEVEL = "QOSLevel";
    public static final String IS_COMPRESSED = "IsCompressed";
    public static final String MQTT_META_INFO = "\u0002MQTT Protocol v3.1";
    public static final String SINGLE_LEVEL_WILDCARD = "+";
    public static final String MULTI_LEVEL_WILDCARD = "#";
    public static final String DEFAULT_ANDES_CHANNEL_IDENTIFIER = "MQTT-Unknown";
    public static final String CLIENT_ID = "clientID";

    public static AndesMessagePart convertToAndesMessage(byte[] message, long messagID) {
        AndesMessagePart messageBody = new AndesMessagePart();
        messageBody.setOffSet(0);
        messageBody.setData(message);
        messageBody.setMessageID(messagID);
        return messageBody;
    }

    public static byte[] encodeMetaInfo(String metaData, long messageID, long arrivalTime, boolean topic, int qos, String destination, boolean persistence, int contentLength, boolean isCompressed) {
        String information = metaData + "?" + MESSAGE_ID + "=" + messageID + "," + ARRIVAL_TIME + "=" + arrivalTime + "," + TOPIC + "=" + topic + "," + DESTINATION + "=" + destination + "," + PERSISTENCE + "=" + persistence + "," + MESSAGE_CONTENT_LENGTH + "=" + contentLength + "," + QOSLEVEL + "=" + qos + "," + IS_COMPRESSED + "=" + isCompressed;
        byte[] metaInformation = information.getBytes();
        return metaInformation;
    }

    public static AndesMessageMetadata convertToAndesHeader(long messageID, String topic, int qosLevel, int messageContentLength, boolean retain, MQTTPublisherChannel publisher, boolean isCompressed) {
        long receivedTime = System.currentTimeMillis();
        AndesMessageMetadata messageHeader = new AndesMessageMetadata();
        messageHeader.setMessageID(messageID);
        messageHeader.setTopic(true);
        messageHeader.setMessageRouterName(MQTT_EXCHANGE_NAME);
        messageHeader.setDestination(topic);
        messageHeader.setPersistent(true);
        messageHeader.setRetain(retain);
        messageHeader.setMessageContentLength(messageContentLength);
        messageHeader.setStorageQueueName(topic);
        messageHeader.setMetaDataType(MessageMetaDataType.META_DATA_MQTT);
        messageHeader.setQosLevel(qosLevel);
        messageHeader.setCompressed(isCompressed);
        messageHeader.setArrivalTime(receivedTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message with id " + messageID + " having the topic " + topic + " with QOS" + qosLevel + " and retain flag set to " + retain + " was created"));
        }
        byte[] andesMetaData = MQTTUtils.encodeMetaInfo(MQTT_META_INFO, messageHeader.getMessageID(), receivedTime, messageHeader.isTopic(), qosLevel, messageHeader.getDestination(), messageHeader.isPersistent(), messageContentLength, isCompressed);
        messageHeader.setMetadata(andesMetaData);
        return messageHeader;
    }

    public static ByteBuffer getContentFromMetaInformation(AndesContent content) throws AndesException {
        ByteBuffer message = ByteBuffer.allocate(content.getContentLength());
        try {
            boolean mqttOffset = false;
            content.putContent(0, message);
        }
        catch (AndesException e) {
            String errorMessage = "Error in getting content for message";
            log.error((Object)"Error in getting content for message", (Throwable)e);
            throw new AndesException("Error in getting content for message", e);
        }
        return message;
    }

    public static AbstractMessage.QOSType getQOSType(int qos) {
        return AbstractMessage.QOSType.valueOf(qos);
    }

    public static boolean isTargetQueueBoundByMatchingToRoutingKey(String queueBoundRoutingKey, String messageRoutingKey) {
        return SubscriptionsStore.matchTopics(messageRoutingKey, queueBoundRoutingKey);
    }

    public static boolean isWildCardSubscription(String subscribedDestination) {
        boolean isWildCard = false;
        if (subscribedDestination.contains(SINGLE_LEVEL_WILDCARD) || subscribedDestination.contains(MULTI_LEVEL_WILDCARD)) {
            isWildCard = true;
        }
        return isWildCard;
    }

    public static UUID generateSubscriptionChannelID(String clientId, String topic, int qos, boolean cleanSession) {
        return UUID.nameUUIDFromBytes((clientId + topic + qos + cleanSession).getBytes());
    }

    public static MQTTMessageContext createMessageContext(String topic, QOSLevel qosLevel, ByteBuffer message, boolean retain, int mqttLocalMessageID, String publisherID, PubAckHandler pubAckHandler, Channel socket) {
        MQTTMessageContext messageContext = new MQTTMessageContext();
        messageContext.setTopic(topic);
        messageContext.setQosLevel(qosLevel);
        messageContext.setMessage(message);
        messageContext.setRetain(retain);
        messageContext.setMqttLocalMessageID(mqttLocalMessageID);
        messageContext.setPublisherID(publisherID);
        messageContext.setPubAckHandler(pubAckHandler);
        messageContext.setChannel(socket);
        return messageContext;
    }

    public static String getTenantFromTopic(String topic) {
        String tenant = "carbon.super";
        if (null != topic && topic.contains("/")) {
            tenant = topic.split("/")[0];
        }
        return tenant;
    }

    public static boolean isDurable(boolean cleanSession, int qos) {
        boolean durable = false;
        if (!cleanSession && qos > 0) {
            durable = true;
        }
        return durable;
    }
}

