/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.mqtt.connectors;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.wso2.QOSLevel;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.AndesUtils;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.SubscriptionAlreadyExistsException;
import org.wso2.andes.kernel.disruptor.inbound.InboundBindingEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundSubscriptionEvent;
import org.wso2.andes.kernel.disruptor.inbound.QueueInfo;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.kernel.subscription.SubscriberConnection;
import org.wso2.andes.mqtt.MQTTException;
import org.wso2.andes.mqtt.MQTTLocalSubscription;
import org.wso2.andes.mqtt.MQTTMessage;
import org.wso2.andes.mqtt.MQTTMessageContext;
import org.wso2.andes.mqtt.MQTTPublisherChannel;
import org.wso2.andes.mqtt.MQTTopicManager;
import org.wso2.andes.mqtt.connectors.MQTTConnector;
import org.wso2.andes.mqtt.utils.MQTTUtils;
import org.wso2.andes.server.ClusterResourceHolder;

public class PersistenceStoreConnector
implements MQTTConnector {
    private static Log log = LogFactory.getLog(PersistenceStoreConnector.class);
    private Map<String, MQTTPublisherChannel> publisherTopicCorrelate = new HashMap<String, MQTTPublisherChannel>();
    private Set<String> retainMessageIdSet = new HashSet<String>();

    @Override
    public void messageAck(long messageID, UUID channelID) throws AndesException {
        AndesAckData andesAckData = new AndesAckData(channelID, messageID);
        if (this.retainMessageIdSet.contains(messageID + channelID.toString())) {
            this.retainMessageIdSet.remove(messageID + channelID.toString());
        } else {
            Andes.getInstance().ackReceived(andesAckData);
        }
    }

    @Override
    public void messageNack(long messageId, UUID channelID) throws AndesException {
        Andes.getInstance().messageRejected(messageId, channelID, true, false);
    }

    @Override
    public void addMessage(MQTTMessageContext messageContext) throws MQTTException {
        if (messageContext.getMessage().hasArray()) {
            MQTTPublisherChannel publisher = this.publisherTopicCorrelate.get(messageContext.getPublisherID());
            if (null == publisher) {
                publisher = new MQTTPublisherChannel(messageContext.getChannel());
                this.publisherTopicCorrelate.put(messageContext.getPublisherID(), publisher);
                String andesChannelId = "MQTT-Unknown";
                if (null != messageContext.getChannel()) {
                    andesChannelId = messageContext.getChannel().remoteAddress().toString().substring(1);
                }
                AndesChannel publisherChannel = null;
                try {
                    publisherChannel = Andes.getInstance().createChannel(andesChannelId, publisher);
                }
                catch (AndesException ex) {
                    throw new MQTTException("unable to create a new channel ", ex);
                }
                publisherChannel.setDestination(messageContext.getTopic());
                publisher.setChannel(publisherChannel);
            }
            byte[] messageData = messageContext.getMessage().array();
            long messageID = 0L;
            AndesMessagePart messagePart = MQTTUtils.convertToAndesMessage(messageData, messageID);
            AndesMessageMetadata messageHeader = MQTTUtils.convertToAndesHeader(messageID, messageContext.getTopic(), messageContext.getQosLevel().getValue(), messageData.length, messageContext.isRetain(), publisher, messageContext.isCompressed());
            messageHeader.addProperty("clientID", messageContext.getPublisherID());
            messageHeader.addProperty("MessageID", messageContext.getMqttLocalMessageID());
            messageHeader.addProperty("QOSLevel", messageContext.getQosLevel().getValue());
            MQTTMessage andesMessage = new MQTTMessage(messageHeader);
            andesMessage.addMessagePart(messagePart);
            Andes.getInstance().messageReceived(andesMessage, publisher.getChannel(), messageContext.getPubAckHandler());
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Message added with message id " + messageContext.getMqttLocalMessageID()));
            }
        } else {
            throw new MQTTException("Message content is not backed by an array, or the array is read-only.");
        }
    }

    @Override
    public void addSubscriber(MQTTopicManager channel, String topic, String clientID, String username, boolean isCleanSession, QOSLevel qos, UUID subscriptionChannelID) throws MQTTException, SubscriptionAlreadyExistsException {
        MQTTLocalSubscription mqttTopicSubscriber = this.createSubscription(topic, channel, clientID, qos.getValue(), subscriptionChannelID, true, isCleanSession);
        try {
            String storageQueueName = AndesUtils.getStorageQueueForDestination(topic, "mqtt.topic", topic, mqttTopicSubscriber.isDurable());
            InboundQueueEvent createQueueEvent = new InboundQueueEvent(storageQueueName, true, false, username, false);
            Andes.getInstance().createQueue(createQueueEvent);
            QueueInfo queueInfo = new QueueInfo(storageQueueName, mqttTopicSubscriber.isDurable(), false, username, false);
            InboundBindingEvent mqttBinding = new InboundBindingEvent(queueInfo, "mqtt.topic", topic);
            Andes.getInstance().addBinding(mqttBinding);
            AndesSubscription localSubscription = this.createLocalSubscription(mqttTopicSubscriber, topic, clientID);
            String subscribedNode = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
            SubscriberConnection connection = new SubscriberConnection("127.0.0.1", subscribedNode, mqttTopicSubscriber.getChannelID(), mqttTopicSubscriber);
            InboundSubscriptionEvent openSubscriptionEvent = new InboundSubscriptionEvent(ProtocolType.MQTT, "", localSubscription.getStorageQueue().getName(), localSubscription.getStorageQueue().getMessageRouterBindingKey(), connection);
            Andes.getInstance().openLocalSubscription(openSubscriptionEvent);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subscription registered to the " + topic + " with channel id " + clientID));
            }
        }
        catch (SubscriptionAlreadyExistsException e) {
            String message = "Error occurred while creating the topic subscription in the kernel";
            log.error((Object)"Error occurred while creating the topic subscription in the kernel", (Throwable)e);
            throw e;
        }
        catch (AndesException e) {
            String message = "Error occurred while opening subscription ";
            log.error((Object)message, (Throwable)e);
            throw new MQTTException(message, e);
        }
    }

    @Override
    public void sendRetainedMessagesToSubscriber(String topic, String subscriptionID, QOSLevel qos, UUID subscriptionChannelID) throws MQTTException {
        try {
            List<DeliverableAndesMetadata> metadataList = Andes.getInstance().getRetainedMetadataByTopic(topic);
            for (DeliverableAndesMetadata metadata : metadataList) {
                AndesContent content = Andes.getInstance().getRetainedMessageContent(metadata);
                ByteBuffer message = MQTTUtils.getContentFromMetaInformation(content);
                boolean bytesPosition = false;
                message.position(0);
                metadata.setRetain(true);
                MQTTopicManager.getInstance().distributeMessageToSubscriber(topic, message, metadata.getMessageID(), metadata.getQosLevel(), metadata.isRetain(), subscriptionID, qos.getValue(), metadata);
                this.retainMessageIdSet.add(metadata.getMessageID() + subscriptionChannelID.toString());
            }
        }
        catch (AndesException e) {
            String message = "Error occurred while fetching MQTT retained metadata/content for topic " + topic;
            log.error((Object)message, (Throwable)e);
        }
        catch (MQTTException e) {
            String message = "Error occurred while sending retained messages to new subscription.";
            log.error((Object)message, (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeSubscriber(MQTTopicManager channel, String subscribedTopic, String username, String subscriptionChannelID, UUID subscriberChannel, boolean isCleanSession, String mqttClientID, QOSLevel qosLevel) throws MQTTException {
        try {
            this.disconnectSubscriber(channel, subscribedTopic, username, subscriptionChannelID, subscriberChannel, isCleanSession, mqttClientID, qosLevel);
            boolean durable = MQTTUtils.isDurable(isCleanSession, qosLevel.getValue());
            if (durable) {
                String storageQueueName = AndesUtils.getStorageQueueForDestination(subscribedTopic, "mqtt.topic", subscribedTopic, true);
                InboundQueueEvent queueChange = new InboundQueueEvent(storageQueueName, true, false, username, false);
                Andes.getInstance().deleteQueue(queueChange);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Disconnected subscriber from topic " + subscribedTopic));
            }
        }
        catch (AndesException e) {
            String message = "Error occurred while removing the subscriber ";
            log.error((Object)"Error occurred while removing the subscriber ", (Throwable)e);
            throw new MQTTException("Error occurred while removing the subscriber ", e);
        }
    }

    @Override
    public void disconnectSubscriber(MQTTopicManager channel, String subscribedTopic, String username, String subscriptionChannelID, UUID subscriberChannel, boolean isCleanSession, String mqttClientID, QOSLevel qosLevel) throws MQTTException {
        try {
            MQTTLocalSubscription mqttTopicSubscriber = this.createSubscription(subscribedTopic, channel, subscriptionChannelID, qosLevel.getValue(), subscriberChannel, isCleanSession, isCleanSession);
            AndesSubscription localSubscription = this.createLocalSubscription(mqttTopicSubscriber, subscribedTopic, mqttClientID);
            String subscribedNode = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
            SubscriberConnection connection = new SubscriberConnection("0.0.0.0", subscribedNode, mqttTopicSubscriber.getChannelID(), mqttTopicSubscriber);
            InboundSubscriptionEvent subscriptionCloseEvent = new InboundSubscriptionEvent(ProtocolType.MQTT, "", localSubscription.getStorageQueue().getName(), localSubscription.getStorageQueue().getMessageRouterBindingKey(), connection);
            Andes.getInstance().closeLocalSubscription(subscriptionCloseEvent);
            if (localSubscription.getStorageQueue().getBoundSubscriptions().isEmpty() && !mqttTopicSubscriber.isDurable()) {
                QueueInfo queueInfo = new QueueInfo(localSubscription.getStorageQueue().getName(), mqttTopicSubscriber.isDurable(), false, username, false);
                InboundBindingEvent mqttBinding = new InboundBindingEvent(queueInfo, "mqtt.topic", subscribedTopic);
                Andes.getInstance().removeBinding(mqttBinding);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Disconnected subscriber from topic " + subscribedTopic));
            }
        }
        catch (AndesException e) {
            String message = "Error occurred while removing the subscriber ";
            log.error((Object)"Error occurred while removing the subscriber ", (Throwable)e);
            throw new MQTTException("Error occurred while removing the subscriber ", e);
        }
    }

    @Override
    public UUID removePublisher(String mqttClientChannelId) {
        MQTTPublisherChannel publisher = this.publisherTopicCorrelate.remove(mqttClientChannelId);
        UUID clusterID = null;
        if (null != publisher) {
            clusterID = publisher.getClusterID();
        }
        return clusterID;
    }

    private MQTTLocalSubscription createSubscription(String wildcardDestination, MQTTopicManager channel, String mqttClientID, int qos, UUID subscriptionChannelID, boolean isActive, boolean cleanSession) throws MQTTException {
        boolean durable = MQTTUtils.isDurable(cleanSession, qos);
        MQTTLocalSubscription outBoundTopicSubscription = new MQTTLocalSubscription(wildcardDestination, subscriptionChannelID, isActive, durable);
        outBoundTopicSubscription.setMqqtServerChannel(channel);
        outBoundTopicSubscription.setMqttSubscriptionID(mqttClientID);
        outBoundTopicSubscription.setSubscriberQOS(qos);
        return outBoundTopicSubscription;
    }

    private AndesSubscription createLocalSubscription(MQTTLocalSubscription mqttLocalSubscription, String topic, String clientID) {
        boolean isDurable = mqttLocalSubscription.isDurable();
        String subscribedNode = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
        String targetQueueBoundExchange = "mqtt.topic";
        String storageQueueName = AndesUtils.getStorageQueueForDestination(topic, targetQueueBoundExchange, topic, isDurable);
        StorageQueue queueToBind = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(storageQueueName);
        SubscriberConnection connection = new SubscriberConnection("127.0.0.1", subscribedNode, mqttLocalSubscription.getChannelID(), mqttLocalSubscription);
        String subscriptionID = mqttLocalSubscription.getMqttSubscriptionID();
        return new AndesSubscription(subscriptionID, queueToBind, ProtocolType.MQTT, connection);
    }
}

