/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.mqtt.connectors;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.wso2.QOSLevel;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.SubscriptionAlreadyExistsException;
import org.wso2.andes.kernel.disruptor.inbound.PubAckHandler;
import org.wso2.andes.mqtt.MQTTException;
import org.wso2.andes.mqtt.MQTTMessageContext;
import org.wso2.andes.mqtt.MQTTopicManager;
import org.wso2.andes.mqtt.connectors.MQTTConnector;

public class InMemoryConnector
implements MQTTConnector {
    private Map<String, List<String>> messageSubscription = new HashMap<String, List<String>>();
    private static Log log = LogFactory.getLog(InMemoryConnector.class);

    @Override
    public void messageAck(long messageID, UUID subChannelID) throws AndesException {
        throw new NotImplementedException();
    }

    @Override
    public void messageNack(long messageId, UUID channelID) {
    }

    @Override
    public void addMessage(MQTTMessageContext messageContext) throws MQTTException {
        this.broadcastMessages(messageContext.getTopic(), messageContext.getMessage(), messageContext.getMqttLocalMessageID(), messageContext.getQosLevel().getValue(), messageContext.isRetain(), messageContext.getPublisherID(), messageContext.getPubAckHandler());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message published to topic " + messageContext.getTopic() + " with publisher id " + messageContext.getMqttLocalMessageID()));
        }
    }

    @Override
    public void addSubscriber(MQTTopicManager channel, String topic, String clientID, String username, boolean isCleanSession, QOSLevel qos, UUID subscriptionChannelID) throws MQTTException, SubscriptionAlreadyExistsException {
        List<String> subscribers = this.messageSubscription.get(topic);
        if (null == subscribers) {
            subscribers = new ArrayList<String>();
        }
        subscribers.add(clientID);
        this.messageSubscription.put(topic, subscribers);
        log.info((Object)("Subscription with id " + clientID + " registered to topic " + topic));
    }

    @Override
    public void removeSubscriber(MQTTopicManager channel, String subscribedTopic, String username, String subscriptionChannelID, UUID subscriberChannel, boolean isCleanSession, String mqttClientID, QOSLevel qosLevel) throws MQTTException {
        this.handleSubscriptionRemoval(subscribedTopic, mqttClientID);
        log.info((Object)("Subscription with id " + mqttClientID + " registered to topic " + subscribedTopic));
    }

    @Override
    public void disconnectSubscriber(MQTTopicManager channel, String subscribedTopic, String username, String subscriptionChannelID, UUID subscriberChannel, boolean isCleanSession, String mqttClientID, QOSLevel qosLevel) throws MQTTException {
        this.handleSubscriptionRemoval(subscribedTopic, mqttClientID);
        log.info((Object)("Subscription with id " + mqttClientID + " removed from " + subscribedTopic));
    }

    @Override
    public UUID removePublisher(String mqttClientChannelID) {
        return null;
    }

    private void broadcastMessages(String topic, ByteBuffer messages, int messageID, int publishedQoS, boolean retain, String clientID, PubAckHandler ackHandler) {
        this.sendPublisherAck(publishedQoS, messageID, clientID, ackHandler);
        List<String> subscribers = this.messageSubscription.get(topic);
        for (String subChannel : subscribers) {
            try {
                int memoryQoSLevel = 0;
                MQTTopicManager.getInstance().distributeMessageToSubscriber(topic, messages, messageID, memoryQoSLevel, retain, subChannel, memoryQoSLevel, new DeliverableAndesMetadata(null, 0L, null, false));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Message " + messageID + " Delivered to subscription " + subChannel + " to topic " + topic));
            }
            catch (MQTTException e) {
                String message = "Error occurred while sending the message to subscriber";
                log.error((Object)message, (Throwable)e);
            }
        }
    }

    private void sendPublisherAck(int publishedQoS, int localMessageID, String clientID, PubAckHandler ackHandler) {
        AndesMessageMetadata metaData = new AndesMessageMetadata();
        metaData.addProperty("QOSLevel", publishedQoS);
        metaData.addProperty("clientID", clientID);
        metaData.addProperty("MessageID", localMessageID);
        ackHandler.ack(metaData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Publisher ack sent to " + clientID + " for message id " + localMessageID));
        }
    }

    private void handleSubscriptionRemoval(String subscribedTopic, String mqttClientID) throws MQTTException {
        List<String> subscribers = this.messageSubscription.get(subscribedTopic);
        if (null == subscribers) {
            throw new MQTTException("There're no subscribers for topic " + subscribedTopic);
        }
        subscribers.remove(mqttClientID.intern());
        if (subscribers.isEmpty()) {
            this.messageSubscription.remove(subscribedTopic);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Subscriber with id " + mqttClientID + " removed from topic " + subscribedTopic));
        }
    }

    @Override
    public void sendRetainedMessagesToSubscriber(String topic, String subscriptionID, QOSLevel qos, UUID subscriptionChannelID) {
    }
}

