/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.mqtt;

import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.wso2.QOSLevel;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.mqtt.MQTTException;
import org.wso2.andes.mqtt.MQTTSubscription;

public class MQTTopics {
    private static Log log = LogFactory.getLog(MQTTopics.class);
    private String channelId;
    private Map<String, MQTTSubscription> subscriptions = new ConcurrentHashMap<String, MQTTSubscription>();
    private Map<Integer, MQTTSubscription> onFlightMessages = new ConcurrentHashMap<Integer, MQTTSubscription>();
    private Set<Integer> messageIds = new ConcurrentSkipListSet<Integer>();

    public MQTTopics(String channelID, Set<Integer> mIds) {
        this.channelId = channelID;
        this.messageIds.addAll(mIds);
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void addSubscriber(String mqttClientChannelID, QOSLevel qos, boolean isCleanSession, String clusterSpecificID, UUID subscriptionChannel, String topicName) throws MQTTException {
        MQTTSubscription subscriber = this.subscriptions.get(topicName);
        if (null == subscriber) {
            subscriber = new MQTTSubscription();
            subscriber.setQOSLevel(qos);
            subscriber.setCleanSession(isCleanSession);
            subscriber.setSubscriberChannelID(clusterSpecificID);
            subscriber.setSubscriptionChannel(subscriptionChannel);
            subscriber.setTopicName(topicName);
            this.subscriptions.put(topicName, subscriber);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subscriber with channel id :" + mqttClientChannelID + " with qos :" + (Object)((Object)qos) + " having clean session :" + isCleanSession));
            }
        } else {
            String message = "Subscriber with channel id " + mqttClientChannelID + " is already bound to " + topicName;
            throw new MQTTException(message);
        }
    }

    public void addSubscriber(String topicName, MQTTSubscription subscriber) {
        this.subscriptions.put(topicName, subscriber);
    }

    public MQTTSubscription removeSubscriber(String mqttTopic) throws MQTTException {
        MQTTSubscription subscriber = this.subscriptions.remove(mqttTopic);
        if (null == subscriber) {
            String message = "Subscriber for topic " + mqttTopic + " cannot be found";
            throw new MQTTException(message);
        }
        return subscriber;
    }

    public MQTTSubscription getSubscription(String topic) {
        return this.subscriptions.get(topic);
    }

    public Collection<MQTTSubscription> getAllSubscriptionsForChannel() {
        return this.subscriptions.values();
    }

    private Integer getNextMessageID() {
        Integer messageId = null;
        if (!this.messageIds.isEmpty()) {
            messageId = this.messageIds.iterator().next();
            this.messageIds.remove(messageId);
        } else {
            log.warn((Object)"Message ids cannot be generated, since it has reached its maximum");
        }
        return messageId;
    }

    public int addOnFlightMessage(String topic, long clusterMessageID, DeliverableAndesMetadata metadata) throws MQTTException {
        Integer messageID;
        MQTTSubscription subscription = this.subscriptions.get(topic);
        if (null != subscription) {
            messageID = subscription.getMessageID(clusterMessageID);
            if (null == messageID) {
                messageID = this.getNextMessageID();
            }
        } else {
            String error = "A subscriber has been disconnected while dispatching the message for channel id " + this.channelId + " for topic " + topic;
            throw new MQTTException(error);
        }
        this.onFlightMessages.put(messageID, subscription);
        subscription.markSent(clusterMessageID, messageID, metadata);
        return messageID;
    }

    public Set<Integer> getUnackedMessages(Set<Integer> allMessages) {
        LinkedHashSet<Integer> unAcknowledgedMessages = new LinkedHashSet<Integer>();
        unAcknowledgedMessages.addAll(this.messageIds);
        unAcknowledgedMessages.removeAll(allMessages);
        return unAcknowledgedMessages;
    }

    public MQTTSubscription getSubscription(Integer messageID) {
        return this.onFlightMessages.get(messageID);
    }

    public MQTTSubscription removeOnFlightMessage(int messageId) {
        return this.onFlightMessages.remove(messageId);
    }

    public void addMessageId(int messageId) {
        this.messageIds.add(messageId);
    }
}

