/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.mqtt;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.wso2.AndesMQTTBridge;
import org.dna.mqtt.wso2.QOSLevel;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.SubscriptionAlreadyExistsException;
import org.wso2.andes.mqtt.MQTTException;
import org.wso2.andes.mqtt.MQTTMessageContext;
import org.wso2.andes.mqtt.MQTTSubscription;
import org.wso2.andes.mqtt.MQTTopics;
import org.wso2.andes.mqtt.connectors.MQTTConnector;
import org.wso2.andes.mqtt.connectors.PersistenceStoreConnector;
import org.wso2.andes.mqtt.utils.MQTTUtils;

public class MQTTopicManager {
    private static Log log = LogFactory.getLog(MQTTopicManager.class);
    private Map<String, MQTTopics> topicSubscriptions = new HashMap<String, MQTTopics>();
    private static MQTTopicManager instance = new MQTTopicManager();
    private static AndesMQTTBridge mqttAndesConnectingBridge = null;
    private MQTTConnector connector = new PersistenceStoreConnector();
    private final Set<Integer> messageIdList = new LinkedHashSet<Integer>();

    private MQTTopicManager() {
        Integer counter = 1;
        while (counter != Short.MAX_VALUE) {
            this.messageIdList.add(counter);
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
        }
    }

    public static MQTTopicManager getInstance() {
        return instance;
    }

    public void initProtocolEngine(AndesMQTTBridge mqttAndesConnection) throws MQTTException {
        if (null != mqttAndesConnectingBridge) {
            String error = "Attempting to initialize the bridge more than once, there cannot be more than one bridge instance";
            log.error((Object)"Attempting to initialize the bridge more than once, there cannot be more than one bridge instance");
            throw new MQTTException("Attempting to initialize the bridge more than once, there cannot be more than one bridge instance");
        }
        mqttAndesConnectingBridge = mqttAndesConnection;
        log.info((Object)"MQTT andes connecting bridge initialized successfully");
    }

    public void addTopicMessage(MQTTMessageContext messageContext) throws MQTTException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Incoming message received with id : " + messageContext.getMqttLocalMessageID() + ", QOS level : " + (Object)((Object)messageContext.getQosLevel()) + ", for topic :" + messageContext.getTopic() + ", with retain :" + messageContext.isRetain()));
            }
            this.connector.addMessage(messageContext);
        }
        catch (MQTTException e) {
            String error = "Error occurred while publishing the message";
            log.error((Object)"Error occurred while publishing the message", (Throwable)e);
            throw e;
        }
    }

    public void addTopicSubscription(String topicName, String mqttClientChannelID, String username, QOSLevel qos, boolean isCleanSession) throws MQTTException {
        UUID subscriptionChannelID = null;
        String subscriptionID = null;
        try {
            MQTTopics topics = this.topicSubscriptions.get(mqttClientChannelID);
            subscriptionChannelID = MQTTUtils.generateSubscriptionChannelID(mqttClientChannelID, topicName, qos.getValue(), isCleanSession);
            if (null == topics) {
                topics = new MQTTopics(mqttClientChannelID, this.messageIdList);
                this.topicSubscriptions.put(mqttClientChannelID, topics);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("The topic " + topics + "has local subscriptions already"));
            }
            subscriptionID = this.registerTopicSubscriptionInCluster(topicName, mqttClientChannelID, username, isCleanSession, qos, subscriptionChannelID);
            topics.addSubscriber(mqttClientChannelID, qos, isCleanSession, subscriptionID, subscriptionChannelID, topicName);
            this.connector.sendRetainedMessagesToSubscriber(topicName, mqttClientChannelID, qos, subscriptionChannelID);
        }
        catch (SubscriptionAlreadyExistsException ignore) {
            String message = "Error while adding the subscriber to the cluster";
            log.error((Object)"Error while adding the subscriber to the cluster", (Throwable)ignore);
        }
        catch (MQTTException ex) {
            this.connector.removeSubscriber(this, topicName, subscriptionID, username, subscriptionChannelID, isCleanSession, mqttClientChannelID, qos);
            String message = "Error while adding the subscriber to the cluster";
            log.error((Object)"Error while adding the subscriber to the cluster", (Throwable)ex);
            throw ex;
        }
    }

    public void removeOrDisconnectClient(String mqttClientChannelID, String unSubscribedTopic, String username, AndesMQTTBridge.SubscriptionEvent action) throws MQTTException {
        log.info((Object)("Disconnecting channel for clientID: " + mqttClientChannelID));
        MQTTopics mqtTopics = this.topicSubscriptions.get(mqttClientChannelID);
        if (null != mqtTopics) {
            Collection<MQTTSubscription> topicSubscriptionList;
            if (null == unSubscribedTopic) {
                topicSubscriptionList = mqtTopics.getAllSubscriptionsForChannel();
            } else {
                topicSubscriptionList = new ArrayList<MQTTSubscription>();
                topicSubscriptionList.add(mqtTopics.getSubscription(unSubscribedTopic));
            }
            for (MQTTSubscription subscription : topicSubscriptionList) {
                String topic = subscription.getTopicName();
                mqtTopics.removeSubscriber(topic);
                String subscriberChannelID = subscription.getSubscriberChannelID();
                UUID subscriberChannel = subscription.getSubscriptionChannel();
                boolean isCleanSession = subscription.isCleanSession();
                QOSLevel qos = subscription.getQOSLevel();
                try {
                    if (action == AndesMQTTBridge.SubscriptionEvent.DISCONNECT && MQTTUtils.isDurable(isCleanSession, qos.getValue())) {
                        this.connector.disconnectSubscriber(this, topic, username, subscriberChannelID, subscriberChannel, isCleanSession, mqttClientChannelID, qos);
                    } else {
                        this.connector.removeSubscriber(this, topic, username, subscriberChannelID, subscriberChannel, isCleanSession, mqttClientChannelID, qos);
                    }
                    if (!log.isDebugEnabled()) continue;
                    String message = "Subscription with cluster id " + subscriberChannelID + " disconnected from topic " + topic;
                    log.debug((Object)message);
                }
                catch (MQTTException ex) {
                    mqtTopics.addSubscriber(unSubscribedTopic, subscription);
                    String error = "Error occurred while removing the subscription " + mqttClientChannelID;
                    log.error((Object)error, (Throwable)ex);
                    throw ex;
                }
            }
            if (mqtTopics.getAllSubscriptionsForChannel().isEmpty()) {
                this.topicSubscriptions.remove(mqttClientChannelID);
            }
        } else {
            UUID publisherID = this.connector.removePublisher(mqttClientChannelID);
            if (null == publisherID) {
                log.warn((Object)("A subscriber or a publisher with Connection with id " + mqttClientChannelID + " cannot be found to disconnect."));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void distributeMessageToSubscriber(String subscribeDestination, ByteBuffer message, long messageID, int publishedQOS, boolean shouldRetain, String channelID, int subscriberQOS, DeliverableAndesMetadata metaData) throws MQTTException {
        int mqttLocalMessageID = 1;
        if (Math.min(publishedQOS, subscriberQOS) > QOSLevel.AT_MOST_ONCE.getValue()) {
            MQTTopics topicSubscriptions = this.topicSubscriptions.get(channelID);
            if (null == topicSubscriptions) throw new MQTTException("The subscriber with id " + channelID + " has disconnected hence message will not be published. Message ID= " + messageID);
            Integer mid = topicSubscriptions.addOnFlightMessage(subscribeDestination, messageID, metaData);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The message with id " + mid + " is sent for delivery to subscriber, " + channelID + " for topic " + metaData.getDestination()));
            }
            AndesMQTTBridge.getBridgeInstance().distributeMessageToSubscriptions(subscribeDestination, metaData.getDestination(), publishedQOS, message, shouldRetain, mid, channelID);
            return;
        } else {
            AndesMQTTBridge.getBridgeInstance().distributeMessageToSubscriptions(subscribeDestination, metaData.getDestination(), publishedQOS, message, shouldRetain, mqttLocalMessageID, channelID);
        }
    }

    public void onMessageAck(String mqttChannelID, int messageID) throws MQTTException {
        MQTTopics subscriptions;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message ack received for id " + messageID + " for subscription " + mqttChannelID));
        }
        if (null != (subscriptions = this.topicSubscriptions.get(mqttChannelID))) {
            MQTTSubscription subscription = subscriptions.removeOnFlightMessage(messageID);
            if (null != subscription) {
                long clusterSpecificMessageID = subscription.ackReceived(messageID);
                UUID subscriptionChannel = subscription.getSubscriptionChannel();
                this.messageAck(clusterSpecificMessageID, subscriptionChannel);
                subscriptions.addMessageId(messageID);
            } else {
                String error = "Could not find information to get subscription information for message ack with id " + messageID + " for channel " + mqttChannelID;
                log.error((Object)error);
            }
        } else {
            String error = "A message acknowledgment had arrived for id " + messageID + " for subscription " + mqttChannelID + " but the subscriber information cannot be found";
            log.error((Object)error);
        }
    }

    private void onMessageNack(long idOfNackedMessage, UUID channelID) {
        try {
            this.connector.messageNack(idOfNackedMessage, channelID);
        }
        catch (AndesException e) {
            String message = "Error occurred while sending a rejection ack for message " + idOfNackedMessage;
            log.error((Object)message, (Throwable)e);
        }
    }

    public void implicitAck(long messageID, UUID subChannelID) throws MQTTException {
        this.messageAck(messageID, subChannelID);
    }

    private String registerTopicSubscriptionInCluster(String topicName, String mqttClientID, String username, boolean isCleanSession, QOSLevel qos, UUID subscriptionChannelID) throws MQTTException, SubscriptionAlreadyExistsException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cluster wide topic connection was created with id " + mqttClientID + " for topic " + topicName + " with clean session " + isCleanSession));
        }
        this.connector.addSubscriber(this, topicName, mqttClientID, username, isCleanSession, qos, subscriptionChannelID);
        return mqttClientID;
    }

    private void messageAck(long messageID, UUID subChannelID) throws MQTTException {
        try {
            this.connector.messageAck(messageID, subChannelID);
        }
        catch (AndesException ex) {
            String message = "Error occurred while cleaning up the acked message";
            log.error((Object)"Error occurred while cleaning up the acked message", (Throwable)ex);
            throw new MQTTException("Error occurred while cleaning up the acked message", ex);
        }
    }

    public void processPingRequest(String clientID) {
        MQTTopics mqtTopics = this.topicSubscriptions.get(clientID);
        if (null != mqtTopics) {
            Set<Integer> unackedMessages = mqtTopics.getUnackedMessages(this.messageIdList);
            for (Integer messageID : unackedMessages) {
                MQTTSubscription subscription = mqtTopics.getSubscription(messageID);
                this.onMessageNack(messageID.intValue(), subscription.getSubscriptionChannel());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Message null ack sent to message id " + messageID));
            }
        }
    }
}

