/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.mqtt;

import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import java.util.Map;
import java.util.UUID;
import org.dna.mqtt.wso2.QOSLevel;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.mqtt.MQTTSubscriptionInformation;

public class MQTTSubscription {
    private QOSLevel QOSLevel;
    private boolean isCleanSession;
    private String subscriberChannelID;
    private UUID subscriptionChannel;
    private String topicName;
    private Map<Integer, Long> localMessageToClusterMessage = new ConcurrentHashMap<Integer, Long>();
    private Map<Long, MQTTSubscriptionInformation> clusterMessageToMessageInformation = new ConcurrentHashMap<Long, MQTTSubscriptionInformation>();

    public void markSent(long clusterMessageID, int mid, DeliverableAndesMetadata metaInfo) {
        this.localMessageToClusterMessage.put(mid, clusterMessageID);
        MQTTSubscriptionInformation subscriptionInfo = new MQTTSubscriptionInformation();
        subscriptionInfo.setLocalMessageID(mid);
        subscriptionInfo.setMetadata(metaInfo);
        this.clusterMessageToMessageInformation.put(clusterMessageID, subscriptionInfo);
    }

    public Integer getMessageID(long clusterID) {
        MQTTSubscriptionInformation subscriptionInformation = this.clusterMessageToMessageInformation.get(clusterID);
        if (null == subscriptionInformation) {
            return null;
        }
        return subscriptionInformation.getLocalMessageID();
    }

    public long ackReceived(int localMessageID) {
        Long clusterID = this.localMessageToClusterMessage.remove(localMessageID);
        this.clusterMessageToMessageInformation.remove(clusterID);
        return clusterID;
    }

    public DeliverableAndesMetadata getMessageMetaInformation(Integer localID) {
        long clusterID = this.localMessageToClusterMessage.get(localID);
        MQTTSubscriptionInformation mqttSubscriptionInformation = this.clusterMessageToMessageInformation.get(clusterID);
        if (null != mqttSubscriptionInformation) {
            return mqttSubscriptionInformation.getMetadata();
        }
        return null;
    }

    public UUID getSubscriptionChannel() {
        return this.subscriptionChannel;
    }

    public boolean isCleanSession() {
        return this.isCleanSession;
    }

    public void setSubscriptionChannel(UUID subscriptionChannel) {
        this.subscriptionChannel = subscriptionChannel;
    }

    public String getSubscriberChannelID() {
        return this.subscriberChannelID;
    }

    public void setSubscriberChannelID(String subscriberChannelID) {
        this.subscriberChannelID = subscriberChannelID;
    }

    public void setCleanSession(boolean isCleanSession) {
        this.isCleanSession = isCleanSession;
    }

    public void setQOSLevel(QOSLevel QOSLevel2) {
        this.QOSLevel = QOSLevel2;
    }

    public QOSLevel getQOSLevel() {
        return this.QOSLevel;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }
}

