/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.mqtt;

import io.netty.channel.Channel;
import java.util.UUID;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.FlowControlListener;

public class MQTTPublisherChannel
implements FlowControlListener {
    private UUID clusterID = null;
    private Channel socket = null;
    private AndesChannel channel = null;

    public UUID getClusterID() {
        return this.clusterID;
    }

    public MQTTPublisherChannel(Channel mqttSocket) {
        this.socket = mqttSocket;
        this.clusterID = UUID.randomUUID();
    }

    @Override
    public void block() {
        this.socket.config().setAutoRead(false);
    }

    @Override
    public void unblock() {
        this.socket.config().setAutoRead(true);
    }

    @Override
    public void disconnect() {
        this.socket.close();
    }

    public void setChannel(AndesChannel channel) {
        this.channel = channel;
    }

    public AndesChannel getChannel() {
        return this.channel;
    }
}

