/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.mqtt;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.wso2.andes.server.store.MessageMetaDataType;
import org.wso2.andes.server.store.StorableMessageMetaData;

public class MQTTMessageMetaData
implements StorableMessageMetaData {
    public static final MessageMetaDataType.Factory<MQTTMessageMetaData> FACTORY = new MetaDataFactory();
    private long messageID;
    private long messageArrivalTime;
    private boolean isTopic;
    private String destination;
    private boolean isPersistance;
    private int messageLength;
    private int qosLevel;
    private boolean _isCompressed = false;

    public MQTTMessageMetaData(long mid, long messageArrivalTime, boolean topic, String destination, boolean persistance, int messageLength, int qos, boolean isCompressed) {
        this.messageID = mid;
        this.messageArrivalTime = messageArrivalTime;
        this.isTopic = topic;
        this.destination = destination;
        this.isPersistance = persistance;
        this.messageLength = messageLength;
        this.qosLevel = qos;
        this._isCompressed = isCompressed;
    }

    @Override
    public MessageMetaDataType getType() {
        return MessageMetaDataType.META_DATA_MQTT;
    }

    @Override
    public int getStorableSize() {
        return this.messageLength;
    }

    @Override
    public int writeToBuffer(int offsetInMetaData, ByteBuffer dest) {
        return 0;
    }

    @Override
    public int getContentSize() {
        return this.messageLength;
    }

    @Override
    public boolean isPersistent() {
        return this.isPersistance;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public long getMessageArrivalTime() {
        return this.messageArrivalTime;
    }

    public int getQosLevel() {
        return this.qosLevel;
    }

    public void setMessageID(long messageID) {
        this.messageID = messageID;
    }

    public boolean isTopic() {
        return this.isTopic;
    }

    public void setTopic(boolean topic) {
        this.isTopic = topic;
    }

    public String getDestination() {
        return this.destination;
    }

    public boolean isCompressed() {
        return this._isCompressed;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    private static class MetaDataFactory
    implements MessageMetaDataType.Factory<MQTTMessageMetaData> {
        private MetaDataFactory() {
        }

        private Map<String, String> decodeMetaData(ByteBuffer buffer) {
            HashMap<String, String> decodedValues = new HashMap<String, String>();
            String information = new String(buffer.array());
            String[] message_parts = information.split("\\?");
            if (message_parts.length > 1) {
                for (String keyValue : message_parts[1].split(",")) {
                    String[] pairs = keyValue.split("=", 2);
                    decodedValues.put(pairs[0], pairs.length == 1 ? "" : pairs[1]);
                }
            }
            return decodedValues;
        }

        @Override
        public MQTTMessageMetaData createMetaData(ByteBuffer buf) {
            Map<String, String> decodedValues = this.decodeMetaData(buf);
            Long messageID = Long.parseLong(decodedValues.get("MessageID"));
            boolean isTopic = Boolean.parseBoolean(decodedValues.get("Topic"));
            boolean isPersistant = Boolean.parseBoolean(decodedValues.get("Persistant"));
            int messageContentLength = Integer.parseInt(decodedValues.get("MessageContentLength"));
            int qos = Integer.parseInt(decodedValues.get("QOSLevel"));
            long messageArrivalTime = Long.parseLong(decodedValues.get("ArrivalTime"));
            boolean isCompressed = false;
            if (decodedValues.containsKey("IsCompressed")) {
                isCompressed = Boolean.parseBoolean(decodedValues.get("IsCompressed"));
            }
            return new MQTTMessageMetaData(messageID, messageArrivalTime, isTopic, decodedValues.get("Destination"), isPersistant, messageContentLength, qos, isCompressed);
        }
    }
}

