/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.mqtt;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.wso2.QOSLevel;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.ConcurrentTrackingList;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.subscription.OutboundSubscription;
import org.wso2.andes.mqtt.MQTTException;
import org.wso2.andes.mqtt.MQTTopicManager;
import org.wso2.andes.mqtt.utils.MQTTUtils;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class MQTTLocalSubscription
implements OutboundSubscription {
    private static Log log = LogFactory.getLog(MQTTLocalSubscription.class);
    private MQTTopicManager mqqtServerChannel;
    private String mqttSubscriptionID;
    private UUID channelID;
    private int subscriberQOS;
    private String wildcardDestination;
    private boolean isActive;
    private boolean isDurable;
    private ConcurrentTrackingList<Long> retainedMessageList = new ConcurrentTrackingList();

    public int getSubscriberQOS() {
        return this.subscriberQOS;
    }

    public void setSubscriberQOS(int subscriberQOS) {
        this.subscriberQOS = subscriberQOS;
    }

    public String getMqttSubscriptionID() {
        return this.mqttSubscriptionID;
    }

    public void setMqttSubscriptionID(String mqttSubscriptionID) {
        this.mqttSubscriptionID = mqttSubscriptionID;
    }

    public MQTTLocalSubscription(String wildCardDestination, UUID channelID, boolean isActive, boolean isDurable) {
        this.channelID = channelID;
        this.isActive = isActive;
        this.wildcardDestination = wildCardDestination;
        this.isDurable = isDurable;
    }

    public void setMqqtServerChannel(MQTTopicManager mqqtServerChannel) {
        this.mqqtServerChannel = mqqtServerChannel;
    }

    @Override
    public void forcefullyDisconnect() throws AndesException {
        throw new NotImplementedException();
    }

    @Override
    public boolean isMessageAcceptedBySelector(AndesMessageMetadata messageMetadata) throws AndesException {
        return true;
    }

    @Override
    public boolean sendMessageToSubscriber(ProtocolMessage protocolMessage, AndesContent content) throws AndesException {
        boolean sendSuccess;
        DeliverableAndesMetadata messageMetadata = protocolMessage.getMessage();
        if (messageMetadata.isRetain()) {
            this.recordRetainedMessage(messageMetadata.getMessageID());
        }
        ByteBuffer message = MQTTUtils.getContentFromMetaInformation(content);
        if (null != this.mqqtServerChannel) {
            try {
                this.mqqtServerChannel.distributeMessageToSubscriber(this.wildcardDestination, message, messageMetadata.getMessageID(), messageMetadata.getQosLevel(), messageMetadata.isPersistent(), this.getMqttSubscriptionID(), this.getSubscriberQOS(), messageMetadata);
                if (QOSLevel.AT_MOST_ONCE.getValue() == this.getSubscriberQOS() || QOSLevel.AT_MOST_ONCE.getValue() == messageMetadata.getQosLevel()) {
                    this.mqqtServerChannel.implicitAck(messageMetadata.getMessageID(), this.getChannelID());
                }
                sendSuccess = true;
            }
            catch (MQTTException e) {
                String error = "Error occurred while delivering message to the subscriber for message :" + messageMetadata.getMessageID();
                log.error((Object)error, (Throwable)e);
                throw new AndesException(error, e);
            }
        } else {
            sendSuccess = false;
        }
        return sendSuccess;
    }

    public void recordRetainedMessage(long messageID) {
        this.retainedMessageList.add(messageID);
    }

    @Override
    public boolean isOutboundConnectionLive() {
        return true;
    }

    @Override
    public UUID getChannelID() {
        return this.channelID != null ? this.channelID : null;
    }

    @Override
    public long getSubscribeTime() {
        return 0L;
    }

    @Override
    public String getProtocolQueueName() {
        return this.wildcardDestination;
    }

    public void ackReceived(long messageID) {
        this.retainedMessageList.remove(messageID);
    }

    public boolean isDurable() {
        return this.isDurable;
    }
}

