/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.management.common.mbeans;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.openmbean.CompositeData;
import org.wso2.andes.management.common.mbeans.annotations.MBeanAttribute;
import org.wso2.andes.management.common.mbeans.annotations.MBeanOperationParameter;

public interface QueueManagementInformation {
    public static final String TYPE = "QueueManagementInformation";
    public static final String JMS_PROPERTIES = "JMSProperties";
    public static final String CONTENT_TYPE = "ContentType";
    public static final String CONTENT = "Content";
    public static final String JMS_MESSAGE_ID = "JMSMessageId";
    public static final String JMS_CORRELATION_ID = "JMSCorrelationId";
    public static final String JMS_TYPE = "JMSType";
    public static final String JMS_REDELIVERED = "JMSRedelivered";
    public static final String JMS_DELIVERY_MODE = "JMSDeliveryMode";
    public static final String JMS_PRIORITY = "JMSPriority";
    public static final String TIME_STAMP = "TimeStamp";
    public static final String JMS_EXPIRATION = "JMSExpiration";
    public static final String MSG_DESTINATION = "MessageDestination";
    public static final String ANDES_MSG_METADATA_ID = "AndesMessageMetadataId";
    public static final List<String> VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC = Collections.unmodifiableList(Arrays.asList("JMSProperties", "ContentType", "Content", "JMSMessageId", "JMSRedelivered", "TimeStamp", "MessageDestination", "AndesMessageMetadataId"));

    @MBeanAttribute(name="Queues", description="All queue names")
    public String[] getAllQueueNames();

    @MBeanAttribute(name="AllQueueCounts", description="Message counts of all queues")
    public Map<String, Integer> getAllQueueCounts();

    @MBeanAttribute(name="MessageCountOfQueuesAsCompositeData", description="Message counts of all queues as Composite data")
    public CompositeData getMessageCountOfQueuesAsCompositeData();

    @MBeanAttribute(name="NamesOfAllDurableQueues", description="Names of all durable queues")
    public Set<String> getNamesOfAllDurableQueues();

    @MBeanAttribute(name="DLCQueueInformation", description="DLC Queue Information. Format = <DLC queue name, message count>")
    public Map<String, Long> getDLCQueueInformation(@MBeanOperationParameter(name="DLCQueueName", description="Name of the queue of DLC queue") String var1) throws MBeanException;

    @MBeanAttribute(name="MessageCount", description="Message count of the queue")
    public long getMessageCount(String var1, String var2) throws MBeanException;

    @MBeanAttribute(name="SubscriptionCount", description="Number of subscriptions for the queue")
    public int getSubscriptionCount(String var1);

    @MBeanAttribute(name=" Queue Exists", description="Check whether the queue exists in the server")
    public boolean isQueueExists(@MBeanOperationParameter(name="queueName", description="Name of the queue to be checked") String var1);

    @MBeanAttribute(name=" Delete All Messages In Queue ", description="Delete all the messages in the queue without removing queue bindings.")
    public void deleteAllMessagesInQueue(@MBeanOperationParameter(name="queueName", description="Name of the queue to delete messages from") String var1, @MBeanOperationParameter(name="ownerName", description="Username of user that calls for purge") String var2) throws MBeanException;

    @MBeanAttribute(name=" DeleteMessages In Dead Letter Queue ", description="Will Delete Messages From Dead Letter Queue")
    public void deleteMessagesFromDeadLetterQueue(@MBeanOperationParameter(name="andesMetadataIDs", description="ID of the Messages to Be Deleted") long[] var1, @MBeanOperationParameter(name="destinationQueueName", description="The Dead Letter Queue Name for the selected tenant") String var2);

    @MBeanAttribute(name="restoreSelectedMessagesFromDeadLetterChannel", description="Will restore a specific set of messages back to their original queue")
    public void restoreSelectedMessagesFromDeadLetterChannel(@MBeanOperationParameter(name="andesMessageIds", description="IDs of the Messages to Be restored") long[] var1, @MBeanOperationParameter(name="destinationQueueName", description="Original destination queue of the messages") String var2) throws MBeanException;

    @MBeanAttribute(name="rerouteSelectedMessagesFromDeadLetterChannel", description="Will reroute a specific set of Messages of QueueA in DLC to a new target QueueB")
    public void rerouteSelectedMessagesFromDeadLetterChannel(@MBeanOperationParameter(name="andesMessageIds", description="IDs of the Messages to Be Restored") long[] var1, @MBeanOperationParameter(name="sourceQueue", description="The  original queue name of the messages") String var2, @MBeanOperationParameter(name="targetQueue", description="New destination queue for the messages") String var3) throws MBeanException;

    @MBeanAttribute(name=" Browse Queue ", description="Browse messages of given queue")
    public CompositeData[] browseQueue(@MBeanOperationParameter(name="queueName", description="Name of queue to browse messages") String var1, @MBeanOperationParameter(name="lastMsgId", description="Browse message this onwards") long var2, @MBeanOperationParameter(name="maxMsgCount", description="Maximum message count per request") int var4) throws MBeanException;

    @MBeanAttribute(name="NumberMessagesInDLCForQueue", description="Message count in the DLC for a specific queue")
    public long getNumberOfMessagesInDLCForQueue(@MBeanOperationParameter(name="queueName", description="Name of queue to browse DLC messages") String var1) throws MBeanException;

    @MBeanAttribute(name="MessageInDLCForQueue", description="Browse messages of given queue")
    public CompositeData[] getMessagesInDLCForQueue(@MBeanOperationParameter(name="queueName", description="Name of queue to browse in DLC messages") String var1, @MBeanOperationParameter(name="lastMsgId", description="Browse message this onwards") long var2, @MBeanOperationParameter(name="maxMessageCount", description="Maximum message count per request") int var4) throws MBeanException;

    @MBeanAttribute(name="getMessageMetadataInDeadLetterChannel", description="List Message Metadata that live in Dead Letter Channel for a given queue.")
    public CompositeData[] getMessageMetadataInDeadLetterChannel(@MBeanOperationParameter(name="targetQueue", description="Name of destination queue ") String var1, @MBeanOperationParameter(name="startMessageId", description="Message Id to start the resultset with.") long var2, @MBeanOperationParameter(name="pageLimit", description="Maximum message count required in a single response") int var4) throws MBeanException;

    @MBeanAttribute(name="rerouteAllMessagesInDeadLetterChannelForQueue", description="Restore messages destined for the input sourceQueue into a different targetQueue.")
    public int rerouteAllMessagesInDeadLetterChannelForQueue(@MBeanOperationParameter(name="sourceQueue", description="Name of the source queue") String var1, @MBeanOperationParameter(name="targetQueue", description="Name of the source queue") String var2, @MBeanOperationParameter(name="internalBatchSize", description="Number of messages processed in a single database call.") int var3) throws MBeanException;
}

