/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.subscription;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.subscription.NullSubscription;
import org.wso2.andes.kernel.subscription.OutBoundMessageTracker;
import org.wso2.andes.kernel.subscription.OutboundSubscription;

public class SubscriberConnection {
    private String connectedIP;
    private UUID protocolChannelID;
    private String connectedNode;
    private AtomicBoolean obsolete;
    private boolean suspended;
    private OutboundSubscription outboundSubscription;
    private OutBoundMessageTracker outBoundMessageTracker;
    private static Log log = LogFactory.getLog(SubscriberConnection.class);

    public SubscriberConnection(String connectedIP, String connectedNode, UUID protocolChannelID, OutboundSubscription outboundSubscription) {
        this.connectedIP = connectedIP;
        this.connectedNode = connectedNode;
        this.protocolChannelID = protocolChannelID;
        int maxNumberOfDeliveredButNotAckedMessages = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_ACK_HANDLING_MAX_UNACKED_MESSAGES);
        this.outBoundMessageTracker = new OutBoundMessageTracker(maxNumberOfDeliveredButNotAckedMessages);
        this.outboundSubscription = outboundSubscription;
        this.obsolete = new AtomicBoolean(false);
        this.suspended = false;
    }

    private SubscriberConnection(String connectedIP, String connectedNode, UUID protocolChannelID, OutboundSubscription outboundSubscription, OutBoundMessageTracker outBoundMessageTracker) {
        this.connectedIP = connectedIP;
        this.connectedNode = connectedNode;
        this.protocolChannelID = protocolChannelID;
        this.outBoundMessageTracker = outBoundMessageTracker;
        this.outboundSubscription = outboundSubscription;
        this.obsolete = new AtomicBoolean(false);
        this.suspended = false;
    }

    SubscriberConnection createFreshClone() {
        return new SubscriberConnection(this.connectedIP, this.connectedNode, this.protocolChannelID, this.outboundSubscription, this.outBoundMessageTracker);
    }

    public SubscriberConnection(String encodedConnectionInfo) {
        String[] propertyToken;
        block10: for (String pt : propertyToken = encodedConnectionInfo.split(",")) {
            String[] tokens = pt.split("=");
            switch (tokens[0]) {
                case "connectedIP": {
                    this.connectedIP = tokens[1];
                    continue block10;
                }
                case "connectedNode": {
                    this.connectedNode = tokens[1];
                    continue block10;
                }
                case "protocolChannelID": {
                    this.protocolChannelID = UUID.fromString(tokens[1]);
                    continue block10;
                }
                default: {
                    if (tokens[0].trim().length() <= 0) continue block10;
                    throw new UnsupportedOperationException("Unexpected token " + tokens[0]);
                }
            }
        }
        this.outboundSubscription = new NullSubscription();
    }

    OutboundSubscription getOutboundSubscription() {
        return this.outboundSubscription;
    }

    public String getConnectedIP() {
        return this.connectedIP;
    }

    public UUID getProtocolChannelID() {
        return this.protocolChannelID;
    }

    public String getConnectedNode() {
        return this.connectedNode;
    }

    public long getSubscribeTime() {
        return this.outboundSubscription.getSubscribeTime();
    }

    public String getProtocolQueueName() {
        return this.outboundSubscription.getProtocolQueueName();
    }

    public void forcefullyDisconnect() throws AndesException {
        log.info((Object)("forcefully disconnecting subscription connection: channelID=" + this.getProtocolChannelID() + " client ip= " + this.connectedIP));
        this.outboundSubscription.forcefullyDisconnect();
    }

    public synchronized void writeMessageToConnection(ProtocolMessage messageMetadata, AndesContent content) throws AndesException {
        if (!this.obsolete.get()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding message to sending tracker channel id = " + this.protocolChannelID + " message id = " + messageMetadata.getMessageID()));
            }
            this.outboundSubscription.sendMessageToSubscriber(messageMetadata, content);
        }
    }

    public synchronized void setObsolete() {
        this.obsolete.set(true);
    }

    public void onWriteToConnectionError(long messageID) {
        this.outBoundMessageTracker.removeSentMessageFromTracker(messageID);
    }

    public boolean hasRoomToAcceptMessages() {
        return this.outBoundMessageTracker.hasRoomToAcceptMessages();
    }

    public boolean isReadyToDeliver() {
        return this.outBoundMessageTracker.isReadyToDeliver();
    }

    public void setIsReadyToDeliver(boolean value) {
        this.outBoundMessageTracker.setReadyToDeliver(value);
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public boolean isMessageAcceptedByConnectionSelector(AndesMessageMetadata messageMetadata) throws AndesException {
        return this.outboundSubscription.isMessageAcceptedBySelector(messageMetadata);
    }

    public List<DeliverableAndesMetadata> getUnAckedMessages() {
        return this.outBoundMessageTracker.getUnackedMessages();
    }

    public DeliverableAndesMetadata getUnAckedMessage(long messageID) {
        return this.outBoundMessageTracker.getMessageByMessageID(messageID);
    }

    public List<DeliverableAndesMetadata> getSentButUnAckedMessages() {
        return this.outBoundMessageTracker.getUnackedMessages();
    }

    public synchronized List<DeliverableAndesMetadata> clearAndReturnUnackedMessages() {
        return this.outBoundMessageTracker.clearAndReturnUnackedMessages();
    }

    public boolean isSubscriberConnectionLive() {
        return this.outboundSubscription.isOutboundConnectionLive();
    }

    public DeliverableAndesMetadata onMessageAck(long messageID) throws AndesException {
        DeliverableAndesMetadata ackedMessage = this.outBoundMessageTracker.removeSentMessageFromTracker(messageID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ack. Removed message reference. Message Id = " + messageID + " channelID= " + this.protocolChannelID));
        }
        return ackedMessage;
    }

    public DeliverableAndesMetadata onMessageReject(long messageID) {
        DeliverableAndesMetadata rejectedMessage = this.outBoundMessageTracker.removeSentMessageFromTracker(messageID);
        rejectedMessage.markAsNackedByClient(this.protocolChannelID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message id= " + messageID + " is rejected by connection " + this));
        }
        return rejectedMessage;
    }

    public String encodeAsString() {
        return "connectedIP=" + this.connectedIP + ",connectedNode=" + this.connectedNode + ",protocolChannelID=" + this.protocolChannelID.toString();
    }

    public String toString() {
        return this.encodeAsString();
    }

    public void addMessageToSendingTracker(ProtocolMessage messageMetadata) {
        this.outBoundMessageTracker.addMessageToSendingTracker(messageMetadata);
    }
}

