/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.subscription;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessageHandler;
import org.wso2.andes.kernel.SubscriptionAlreadyExistsException;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.subscription.AndesSubscription;

public class StorageQueue {
    private static Log log = LogFactory.getLog(StorageQueue.class);
    private String name;
    private boolean isDurable;
    private boolean isShared;
    private String queueOwner;
    private boolean isExclusive;
    private Long lastPurgedTimestamp;
    private AndesMessageRouter messageRouter;
    private String messageRouterBindingKey;
    private List<AndesSubscription> boundedSubscriptions;
    private MessageHandler messageHandler;

    public StorageQueue(String name, boolean isDurable, boolean isShared, String queueOwner, boolean isExclusive) {
        this.name = name;
        this.isDurable = isDurable;
        this.isShared = isShared;
        this.queueOwner = queueOwner;
        this.isExclusive = isExclusive;
        this.lastPurgedTimestamp = 0L;
        this.boundedSubscriptions = new ArrayList<AndesSubscription>(1);
        this.messageHandler = new MessageHandler(name);
    }

    public StorageQueue(String queueAsStr) {
        String[] propertyToken;
        block16: for (String pt : propertyToken = queueAsStr.split(",")) {
            String[] tokens = pt.split("=");
            switch (tokens[0]) {
                case "queueName": {
                    this.name = tokens[1];
                    continue block16;
                }
                case "queueOwner": {
                    this.queueOwner = tokens[1].equals("null") ? null : tokens[1];
                    continue block16;
                }
                case "isExclusive": {
                    this.isExclusive = Boolean.parseBoolean(tokens[1]);
                    continue block16;
                }
                case "isDurable": {
                    this.isDurable = Boolean.parseBoolean(tokens[1]);
                    continue block16;
                }
                case "isShared": {
                    this.isShared = Boolean.parseBoolean(tokens[1]);
                    continue block16;
                }
                case "lastPurgedTimestamp": {
                    this.lastPurgedTimestamp = Long.parseLong(tokens[1]);
                }
            }
        }
        this.boundedSubscriptions = new ArrayList<AndesSubscription>(1);
    }

    public String encodeAsString() {
        return "queueName=" + this.name + ",queueOwner=" + this.queueOwner + ",isExclusive=" + this.isExclusive + ",isDurable=" + this.isDurable + ",isShared=" + this.isShared + ",lastPurgedTimestamp=" + this.lastPurgedTimestamp;
    }

    public String toString() {
        return this.encodeAsString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public String getQueueOwner() {
        return this.queueOwner;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public Long getLastPurgedTimestamp() {
        return this.lastPurgedTimestamp;
    }

    public boolean bindQueueToMessageRouter(String bindingKey, AndesMessageRouter router) throws AndesException {
        if (!this.checkIfBound(bindingKey, router)) {
            this.messageRouterBindingKey = bindingKey;
            this.messageRouter = router;
            router.addMapping(bindingKey, this);
            return false;
        }
        return true;
    }

    public boolean checkIfBound(String bindingKey, AndesMessageRouter router) {
        return null != this.messageRouterBindingKey && this.messageRouterBindingKey.equals(bindingKey) && null != this.messageRouter && this.messageRouter.equals(router);
    }

    public void unbindQueueFromMessageRouter() throws AndesException {
        if (null != this.messageRouterBindingKey) {
            this.messageRouter.removeMapping(this.messageRouterBindingKey, this);
            this.messageRouterBindingKey = null;
            this.messageRouter = null;
        }
    }

    public List<AndesSubscription> getBoundSubscriptions() {
        return this.boundedSubscriptions;
    }

    public void bindSubscription(AndesSubscription subscription, String routingKeyOfSubscriber) throws AndesException {
        if (AMQPUtils.TOPIC_EXCHANGE_NAME.equals(this.messageRouter.getName()) && this.isDurable) {
            Iterable<AndesSubscription> existingSubscribers;
            Iterator<AndesSubscription> subscriptionIterator;
            if (!this.messageRouterBindingKey.equals(routingKeyOfSubscriber)) {
                throw new SubscriptionAlreadyExistsException("An subscription already exists with same subscription ID " + this.name + " bound to a different topic " + this.messageRouterBindingKey);
            }
            boolean allowSharedSubscribers = (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.ALLOW_SHARED_SHARED_SUBSCRIBERS);
            if (!allowSharedSubscribers && (subscriptionIterator = (existingSubscribers = AndesContext.getInstance().getAndesSubscriptionManager().getAllSubscriptionsByQueue(subscription.getProtocolType(), this.name)).iterator()).hasNext()) {
                AndesSubscription existingSubscriber = subscriptionIterator.next();
                throw new SubscriptionAlreadyExistsException("An active subscription already exists with same subscription id " + existingSubscriber.getSubscriptionId() + " bound to queue " + this.name + " by routing key " + this.messageRouterBindingKey);
            }
        }
        this.boundedSubscriptions.add(subscription);
        this.messageHandler.startMessageDelivery(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindSubscription(AndesSubscription subscription) throws AndesException {
        String string = subscription.getSubscriberConnection().getProtocolChannelID().toString().intern();
        synchronized (string) {
            subscription.detach();
            this.boundedSubscriptions.remove(subscription);
            if (this.boundedSubscriptions.isEmpty()) {
                if (this.isDurable) {
                    this.messageHandler.releaseAllSlots();
                    this.messageHandler.clearReadButUndeliveredMessages();
                    subscription.clearUnackedMessages();
                }
                this.messageHandler.stopMessageDelivery(this);
            } else {
                subscription.rebufferUnackedMessages();
            }
        }
    }

    void replaceBoundSub(AndesSubscription existingSubscription, AndesSubscription newSubscription) {
        this.boundedSubscriptions.set(this.boundedSubscriptions.indexOf(existingSubscription), newSubscription);
    }

    public AndesMessageRouter getMessageRouter() {
        return this.messageRouter;
    }

    public String getMessageRouterBindingKey() {
        return this.messageRouterBindingKey;
    }

    public void loadMessagesForDelivery(Slot messageSlot) throws AndesException {
        this.messageHandler.bufferMessages(messageSlot);
    }

    public void bufferMessageForDelivery(DeliverableAndesMetadata message) {
        this.messageHandler.bufferMessage(message);
    }

    void removeMessageFromBuffer(long messageId) {
        this.messageHandler.removeBufferedMessage(messageId);
    }

    public Collection<DeliverableAndesMetadata> getMessagesForDelivery() {
        return this.messageHandler.getReadButUndeliveredMessages();
    }

    public void deleteSlot(Slot slotToDelete) {
        this.messageHandler.deleteSlot(slotToDelete);
    }

    public boolean checkForReadMessageBufferLimit() {
        return this.messageHandler.messageBufferHasRoom();
    }

    public int purgeMessages() throws AndesException {
        this.lastPurgedTimestamp = System.currentTimeMillis();
        log.info((Object)("Purging messages of queue " + this.name));
        return this.messageHandler.purgeMessagesOfQueue();
    }

    public int purgeMessagesInMemory() {
        this.lastPurgedTimestamp = System.currentTimeMillis();
        log.info((Object)("Purging in memory messages of queue " + this.name));
        return this.messageHandler.purgeInMemoryMessagesOfQueue();
    }

    public void dumpAllSlotInformationToFile(File fileToWrite) throws AndesException {
        this.messageHandler.dumpAllSlotInformationToFile(fileToWrite, this.name);
    }

    public long getMessageCount() throws AndesException {
        return this.messageHandler.getMessageCountForQueue();
    }

    public boolean equals(Object o) {
        if (o instanceof StorageQueue) {
            StorageQueue c = (StorageQueue)o;
            if (this.name.equals(c.name)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.name).toHashCode();
    }
}

