/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.subscription;

import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.ProtocolMessage;

public class OutBoundMessageTracker {
    private boolean readyToDeliver = false;
    private final ConcurrentHashMap<Long, DeliverableAndesMetadata> messageSendingTracker = new ConcurrentHashMap();
    private int maxNumberOfUnAcknowledgedMessages;
    private static Log log = LogFactory.getLog(OutBoundMessageTracker.class);

    public void setReadyToDeliver(boolean ready) {
        this.readyToDeliver = ready;
    }

    public OutBoundMessageTracker(int maxNumberOfMessagesToKeep) {
        this.maxNumberOfUnAcknowledgedMessages = maxNumberOfMessagesToKeep;
    }

    public synchronized DeliverableAndesMetadata removeSentMessageFromTracker(long messageID) {
        return this.messageSendingTracker.remove(messageID);
    }

    public DeliverableAndesMetadata getMessageByMessageID(long messageID) {
        DeliverableAndesMetadata metadata = this.messageSendingTracker.get(messageID);
        if (null == metadata) {
            log.error((Object)("Message reference has been already cleared for message id " + messageID + ". Acknowledge or Nak is already received"));
        }
        return metadata;
    }

    public boolean hasRoomToAcceptMessages() {
        int notAcknowledgedMsgCount = this.messageSendingTracker.size();
        if (notAcknowledgedMsgCount < this.maxNumberOfUnAcknowledgedMessages) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Not selected. Too much pending acks, subscription = " + this + " pending count =" + notAcknowledgedMsgCount));
        }
        return false;
    }

    public boolean isReadyToDeliver() {
        return this.readyToDeliver;
    }

    public List<DeliverableAndesMetadata> getUnackedMessages() {
        return new ArrayList<DeliverableAndesMetadata>(this.messageSendingTracker.values());
    }

    public synchronized List<DeliverableAndesMetadata> clearAndReturnUnackedMessages() {
        List<DeliverableAndesMetadata> messages = this.getUnackedMessages();
        this.messageSendingTracker.clear();
        return messages;
    }

    public synchronized void addMessageToSendingTracker(ProtocolMessage messageData) {
        this.messageSendingTracker.put(messageData.getMessageID(), messageData.getMessage());
    }
}

