/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.subscription;

import java.util.UUID;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.kernel.subscription.SubscriberConnection;
import org.wso2.andes.kernel.subscription.SubscriptionException;

public class DurableTopicSubscriber
extends AndesSubscription {
    private String clientID;

    public DurableTopicSubscriber(String subscriptionID, String clientID, StorageQueue storageQueue, ProtocolType protocol, SubscriberConnection connectionInfo) {
        super(subscriptionID, storageQueue, protocol, connectionInfo);
        this.isActive = true;
        this.clientID = clientID;
    }

    @Override
    public void closeConnection(UUID channelID, String nodeID) throws SubscriptionException {
        if (!this.isActive) {
            throw new SubscriptionException("Cannot close inactive subscription id= " + this.getSubscriptionId() + " channelID= " + channelID);
        }
        this.isActive = false;
    }

    @Override
    public void forcefullyDisconnectConnections() throws AndesException {
        this.subscriberConnection.forcefullyDisconnect();
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    public String getClientID() {
        return this.clientID;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }
}

