/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.subscription;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.simple.Equal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.ClusterNotificationListener;
import org.wso2.andes.kernel.DestinationType;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.disruptor.inbound.InboundSubscriptionEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundSubscriptionSyncEvent;
import org.wso2.andes.kernel.registry.StorageQueueRegistry;
import org.wso2.andes.kernel.registry.SubscriptionRegistry;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.AndesSubscriptionFactory;
import org.wso2.andes.kernel.subscription.InactiveSubscriber;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.kernel.subscription.SubscriberConnection;
import org.wso2.andes.kernel.subscription.SubscriptionException;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.coordination.ClusterNotificationAgent;
import org.wso2.andes.server.cluster.coordination.CoordinationComponentFactory;
import org.wso2.andes.server.cluster.error.detection.NetworkPartitionListener;
import org.wso2.andes.store.AndesStoreUnavailableException;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;
import org.wso2.carbon.metrics.manager.Gauge;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;

public class AndesSubscriptionManager
implements NetworkPartitionListener,
StoreHealthListener {
    private static Log log = LogFactory.getLog(AndesSubscriptionManager.class);
    private static final String SELECT_ALL_NODES = "All";
    private AndesSubscriptionFactory subscriptionFactory;
    private SubscriptionRegistry subscriptionRegistry;
    private StorageQueueRegistry storageQueueRegistry;
    private String localNodeId;
    private volatile boolean isNetworkPartitioned;
    private ClusterNotificationAgent clusterNotificationAgent;
    private AndesContextStore andesContextStore;
    private boolean storeUnavailable;
    ScheduledExecutorService executorService;
    private final boolean sharedSubscribersAllowed = (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.ALLOW_SHARED_SHARED_SUBSCRIBERS);

    public AndesSubscriptionManager(SubscriptionRegistry subscriptionRegistry, AndesContextStore andesContextStore) throws AndesException {
        this.subscriptionRegistry = subscriptionRegistry;
        this.isNetworkPartitioned = false;
        this.subscriptionFactory = new AndesSubscriptionFactory();
        this.storageQueueRegistry = AndesContext.getInstance().getStorageQueueRegistry();
        this.andesContextStore = andesContextStore;
        this.localNodeId = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
        this.storeUnavailable = false;
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("AndesSubscriptionManager-SubscriptionDisconnectTask").build());
        CoordinationComponentFactory coordinationComponentFactory = new CoordinationComponentFactory();
        this.clusterNotificationAgent = coordinationComponentFactory.createClusterNotificationAgent();
        if (AndesContext.getInstance().isClusteringEnabled()) {
            AndesContext.getInstance().getClusterAgent().addNetworkPartitionListener(10, this);
        }
        MetricManager.gauge((String)"org.wso2.mb.queue.subscribers.count", (Level)Level.INFO, (Gauge)new QueueSubscriberGauge());
        MetricManager.gauge((String)"org.wso2.mb.topic.subscribers.count", (Level)Level.INFO, (Gauge)new TopicSubscriberGauge());
        FailureObservingStoreManager.registerStoreHealthListener(this);
    }

    public void registerSubscription(AndesSubscription subscriptionToAdd) {
        this.subscriptionRegistry.registerSubscription(subscriptionToAdd);
    }

    void replaceSubscription(AndesSubscription replacedSubscription, AndesSubscription replacingSubscription) {
        this.subscriptionRegistry.removeSubscription(replacedSubscription);
        this.subscriptionRegistry.registerSubscription(replacingSubscription);
    }

    public void addLocalSubscription(InboundSubscriptionEvent subscriptionRequest) throws AndesException {
        if (this.isNetworkPartitioned) {
            throw new SubscriptionException("Cannot add new subscription due to network partition");
        }
        StorageQueue storageQueue = this.storageQueueRegistry.getStorageQueue(subscriptionRequest.getBoundStorageQueueName());
        AndesSubscription subscription = this.subscriptionFactory.createLocalSubscription(subscriptionRequest, storageQueue);
        storageQueue.bindSubscription(subscription, subscriptionRequest.getRoutingKey());
        this.registerSubscription(subscription);
        try {
            this.andesContextStore.storeDurableSubscription(subscription);
        }
        catch (AndesStoreUnavailableException exception) {
            log.warn((Object)"Could not add subscription to the store since the store became unavailable", (Throwable)exception);
        }
        log.info((Object)("Add Local subscription " + (Object)((Object)subscription.getProtocolType()) + " " + subscription.toString()));
        this.clusterNotificationAgent.notifySubscriptionsChange(subscription, ClusterNotificationListener.SubscriptionChange.Added);
        subscriptionRequest.getPostOpenSubscriptionAction().run();
        subscriptionRequest.getSubscriber().setIsReadyToDeliver(true);
    }

    public void addRemoteSubscription(InboundSubscriptionSyncEvent subscriptionEvent) throws SubscriptionException {
        if (this.isNetworkPartitioned) {
            throw new SubscriptionException("Cannot add new subscription due to network partition");
        }
        AndesSubscription remoteSubscription = new AndesSubscription(subscriptionEvent.getEncodedSubscription());
        this.registerSubscription(remoteSubscription);
        log.info((Object)("Sync subscription [create] " + (Object)((Object)remoteSubscription.getProtocolType()) + " " + remoteSubscription.toString()));
    }

    public void closeLocalSubscription(InboundSubscriptionEvent closeSubscriptionEvent) throws AndesException {
        UUID protocolChannel = closeSubscriptionEvent.getSubscriber().getProtocolChannelID();
        AndesSubscription subscription = this.getSubscriptionByProtocolChannel(protocolChannel);
        this.removeLocalSubscriptionAndNotify(subscription);
    }

    public void closeRemoteSubscription(InboundSubscriptionSyncEvent closeSubscriptionEvent) throws AndesException {
        AndesSubscription closedSubRepresentation = new AndesSubscription(closeSubscriptionEvent.getEncodedSubscription());
        UUID protocolChannel = closedSubRepresentation.getSubscriberConnection().getProtocolChannelID();
        AndesSubscription subscription = this.getSubscriptionByProtocolChannel(protocolChannel);
        this.subscriptionRegistry.removeSubscription(subscription);
        log.info((Object)("Sync subscription [close] " + (Object)((Object)subscription.getProtocolType()) + " " + subscription.toString()));
    }

    private void removeLocalSubscriptionAndNotify(AndesSubscription subscription) {
        this.subscriptionRegistry.removeSubscription(subscription);
        StorageQueue storageQueue = subscription.getStorageQueue();
        try {
            storageQueue.unbindSubscription(subscription);
            if (!this.storeUnavailable) {
                this.andesContextStore.removeDurableSubscription(subscription);
            } else {
                log.warn((Object)"Cannot not remove subscription from store since the store is non-operational");
            }
            this.clusterNotificationAgent.notifySubscriptionsChange(subscription, ClusterNotificationListener.SubscriptionChange.Closed);
            if (!storageQueue.isDurable() && storageQueue.getBoundSubscriptions().isEmpty()) {
                AndesContextInformationManager contextInformationManager = AndesContext.getInstance().getAndesContextInformationManager();
                contextInformationManager.deleteQueue(storageQueue);
            }
            log.info((Object)("Remove Local Subscription " + (Object)((Object)subscription.getProtocolType()) + " " + subscription.toString()));
        }
        catch (AndesException exception) {
            log.warn((Object)("An error occurred while removing local subscription " + subscription.toString()), (Throwable)exception);
        }
    }

    private void removeRemoteSubscriptionFromMemoryAndStore(AndesSubscription subscription) throws AndesException {
        this.subscriptionRegistry.removeSubscription(subscription);
        if (!this.storeUnavailable) {
            try {
                this.andesContextStore.removeDurableSubscription(subscription);
            }
            catch (AndesStoreUnavailableException exception) {
                log.warn((Object)"Could not remove subscription from store since the store is unavailable", (Throwable)exception);
            }
        } else {
            log.warn((Object)"Cannot not remove subscription from store since the store is non-operational");
        }
        StorageQueue storageQueue = subscription.getStorageQueue();
        if (!storageQueue.isDurable() && 0 == this.numberOfSubscriptionsInCluster(storageQueue.getName(), subscription.getProtocolType())) {
            AndesContextInformationManager contextInformationManager = AndesContext.getInstance().getAndesContextInformationManager();
            contextInformationManager.deleteQueue(storageQueue);
        }
        log.info((Object)("Remove Remote Subscription " + (Object)((Object)subscription.getProtocolType()) + " " + subscription.toString()));
    }

    private void removeRemoteSubscriptionFromMemory(AndesSubscription subscription) throws AndesException {
        this.subscriptionRegistry.removeSubscription(subscription);
        log.info((Object)("Remove Remote Subscription " + (Object)((Object)subscription.getProtocolType()) + " " + subscription.toString()));
    }

    public List<AndesSubscription> getInactiveSubscriberRepresentations() {
        ArrayList<AndesSubscription> inactiveSubscriptions = new ArrayList<AndesSubscription>();
        List<StorageQueue> storageQueues = AndesContext.getInstance().getStorageQueueRegistry().getAllStorageQueues();
        for (StorageQueue storageQueue : storageQueues) {
            InactiveSubscriber inactiveSubscriber;
            boolean isQueueDurable = storageQueue.isDurable();
            if (!isQueueDurable) continue;
            String messageRouterName = storageQueue.getMessageRouter().getName();
            if (AMQPUtils.TOPIC_EXCHANGE_NAME.equals(messageRouterName)) {
                if (this.getAllSubscriptionsByQueue(ProtocolType.AMQP, storageQueue.getName()).iterator().hasNext()) continue;
                inactiveSubscriber = new InactiveSubscriber(storageQueue.getName(), storageQueue.getName(), storageQueue, ProtocolType.AMQP);
                inactiveSubscriptions.add(inactiveSubscriber);
                continue;
            }
            if (!"mqtt.topic".equals(messageRouterName) || this.getAllSubscriptionsByQueue(ProtocolType.MQTT, storageQueue.getName()).iterator().hasNext()) continue;
            inactiveSubscriber = new InactiveSubscriber(storageQueue.getName(), storageQueue.getName(), storageQueue, ProtocolType.MQTT);
            inactiveSubscriptions.add(inactiveSubscriber);
        }
        return inactiveSubscriptions;
    }

    public Set<AndesSubscription> getFilteredSubscriptions(boolean isDurable, boolean isActive, ProtocolType protocolType, DestinationType destinationType, String bindingKeyPattern, boolean isExactMatchBindingKey, String subscriptionIdPattern, boolean isExactMatchSubscriptionId, String connectedNode) throws AndesException {
        Set<AndesSubscription> filteredSubscriptions;
        if (isActive) {
            if (isExactMatchBindingKey) {
                filteredSubscriptions = this.getActiveSubscriptionsByExactBindingKeyMatch(isDurable, protocolType, destinationType, bindingKeyPattern.trim(), connectedNode);
                filteredSubscriptions = this.filterActiveSubscriptionsBySubscriptionId(filteredSubscriptions, subscriptionIdPattern.trim(), isExactMatchSubscriptionId);
            } else {
                filteredSubscriptions = this.getActiveSubscriptionsByTokenizedBindingKeyMatch(isDurable, protocolType, destinationType, bindingKeyPattern.trim(), connectedNode);
                filteredSubscriptions = this.filterActiveSubscriptionsBySubscriptionId(filteredSubscriptions, subscriptionIdPattern.trim(), isExactMatchSubscriptionId);
            }
        } else if (isExactMatchBindingKey) {
            filteredSubscriptions = this.getInactiveSubscriptionsByByExactBindingKeyMatch(bindingKeyPattern.trim());
            filteredSubscriptions = this.filterInactiveSubscriptionsBySubscriptionId(filteredSubscriptions, protocolType, destinationType, subscriptionIdPattern.trim(), isExactMatchSubscriptionId);
        } else {
            filteredSubscriptions = this.getInactiveSubscriptionsByTokenizedBindingKeyMatch(bindingKeyPattern.trim());
            filteredSubscriptions = this.filterInactiveSubscriptionsBySubscriptionId(filteredSubscriptions, protocolType, destinationType, subscriptionIdPattern.trim(), isExactMatchSubscriptionId);
        }
        return filteredSubscriptions;
    }

    private Set<AndesSubscription> getActiveSubscriptionsByExactBindingKeyMatch(boolean isDurable, ProtocolType protocolType, DestinationType destinationType, String bindingKeyPattern, String connectedNode) throws AndesException {
        HashSet<AndesSubscription> filteredSubscriptions = new HashSet<AndesSubscription>();
        String messageRouter = destinationType.getAndesMessageRouter();
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.DURABILITY, (Object)isDurable), (Query)QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType)), (Query)QueryFactory.equal(AndesSubscription.ROUTER_NAME, (Object)messageRouter), (Query)QueryFactory.equal(AndesSubscription.ROUTING_KEY, (Object)bindingKeyPattern.toLowerCase()));
        if (!SELECT_ALL_NODES.equals(connectedNode)) {
            subscriptionQuery = QueryFactory.and((Query)subscriptionQuery, (Query)QueryFactory.equal(AndesSubscription.NODE_ID, (Object)connectedNode));
        }
        Iterable<AndesSubscription> subscriptions = this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
        for (AndesSubscription subscription : subscriptions) {
            filteredSubscriptions.add(subscription);
        }
        return filteredSubscriptions;
    }

    private Set<AndesSubscription> getInactiveSubscriptionsByByExactBindingKeyMatch(String bindingKeyPattern) throws AndesException {
        HashSet<AndesSubscription> filteredSubscriptions = new HashSet<AndesSubscription>();
        List<AndesSubscription> allInactiveSubscriptions = this.getInactiveSubscriberRepresentations();
        for (AndesSubscription inactiveSubscription : allInactiveSubscriptions) {
            if (!inactiveSubscription.getStorageQueue().getMessageRouterBindingKey().equalsIgnoreCase(bindingKeyPattern)) continue;
            filteredSubscriptions.add(inactiveSubscription);
        }
        return filteredSubscriptions;
    }

    private Set<AndesSubscription> getActiveSubscriptionsByTokenizedBindingKeyMatch(boolean isDurable, ProtocolType protocolType, DestinationType destinationType, String bindingKeyPattern, String connectedNode) throws AndesException {
        HashSet<AndesSubscription> filteredSubscriptions = new HashSet<AndesSubscription>();
        String messageRouter = destinationType.getAndesMessageRouter();
        if (ProtocolType.MQTT.equals((Object)protocolType)) {
            messageRouter = "mqtt.topic";
        }
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.DURABILITY, (Object)isDurable), (Query)QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType)), (Query)QueryFactory.equal(AndesSubscription.ROUTER_NAME, (Object)messageRouter), (Query)QueryFactory.contains(AndesSubscription.ROUTING_KEY, (CharSequence)bindingKeyPattern.toLowerCase()));
        if (!SELECT_ALL_NODES.equals(connectedNode)) {
            subscriptionQuery = QueryFactory.and((Query)subscriptionQuery, (Query)QueryFactory.equal(AndesSubscription.NODE_ID, (Object)connectedNode));
        }
        Iterable<AndesSubscription> subscriptions = this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
        for (AndesSubscription subscription : subscriptions) {
            filteredSubscriptions.add(subscription);
        }
        return filteredSubscriptions;
    }

    private Set<AndesSubscription> getInactiveSubscriptionsByTokenizedBindingKeyMatch(String bindingKeyPattern) throws AndesException {
        HashSet<AndesSubscription> filteredSubscriptions = new HashSet<AndesSubscription>();
        List<AndesSubscription> allInactiveSubscriptions = this.getInactiveSubscriberRepresentations();
        for (AndesSubscription inactiveSubscription : allInactiveSubscriptions) {
            if (!StringUtils.containsIgnoreCase((String)inactiveSubscription.getStorageQueue().getMessageRouterBindingKey(), (String)bindingKeyPattern)) continue;
            filteredSubscriptions.add(inactiveSubscription);
        }
        return filteredSubscriptions;
    }

    private Set<AndesSubscription> filterInactiveSubscriptionsBySubscriptionId(Set<AndesSubscription> subscriptions, ProtocolType protocolType, DestinationType destinationType, String subscriptionIdPattern, boolean isExactMatchSubscriptionId) {
        HashSet<AndesSubscription> filteredSubscriptions = new HashSet<AndesSubscription>();
        String messageRouter = destinationType.getAndesMessageRouter();
        if (isExactMatchSubscriptionId) {
            for (AndesSubscription inactiveSubscription : subscriptions) {
                if (!inactiveSubscription.getStorageQueue().getMessageRouter().getName().equals(messageRouter) || !inactiveSubscription.getProtocolType().equals((Object)protocolType) || !inactiveSubscription.getSubscriptionId().equalsIgnoreCase(subscriptionIdPattern)) continue;
                filteredSubscriptions.add(inactiveSubscription);
            }
        } else {
            for (AndesSubscription inactiveSubscription : subscriptions) {
                if (!inactiveSubscription.getStorageQueue().getMessageRouter().getName().equals(messageRouter) || !inactiveSubscription.getProtocolType().equals((Object)protocolType) || !StringUtils.containsIgnoreCase((String)inactiveSubscription.getSubscriptionId(), (String)subscriptionIdPattern)) continue;
                filteredSubscriptions.add(inactiveSubscription);
            }
        }
        return filteredSubscriptions;
    }

    private Set<AndesSubscription> filterActiveSubscriptionsBySubscriptionId(Set<AndesSubscription> subscriptions, String subscriptionIdPattern, boolean isExactMatchSubscriptionId) {
        HashSet<AndesSubscription> filteredSubscriptions = new HashSet<AndesSubscription>();
        if (isExactMatchSubscriptionId) {
            for (AndesSubscription subscription : subscriptions) {
                if (subscriptionIdPattern.equalsIgnoreCase(subscription.getSubscriptionId())) {
                    filteredSubscriptions.add(subscription);
                    continue;
                }
                if (!subscription.isDurable() || !subscription.getStorageQueue().getMessageRouter().getName().equals(AMQPUtils.TOPIC_EXCHANGE_NAME) || !subscriptionIdPattern.equalsIgnoreCase(subscription.getStorageQueue().getName())) continue;
                filteredSubscriptions.add(subscription);
            }
        } else {
            for (AndesSubscription subscription : subscriptions) {
                if (StringUtils.containsIgnoreCase((String)subscription.getSubscriptionId(), (String)subscriptionIdPattern)) {
                    filteredSubscriptions.add(subscription);
                    continue;
                }
                if (!subscription.isDurable() || !subscription.getStorageQueue().getMessageRouter().getName().equals(AMQPUtils.TOPIC_EXCHANGE_NAME) || !StringUtils.containsIgnoreCase((String)subscription.getStorageQueue().getName(), (String)subscriptionIdPattern)) continue;
                filteredSubscriptions.add(subscription);
            }
        }
        return filteredSubscriptions;
    }

    public void removeSubscriptionFromRegistry(UUID channelID, String nodeID) throws AndesException {
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.CHANNEL_ID, (Object)channelID), (Query)QueryFactory.equal(AndesSubscription.NODE_ID, (Object)nodeID));
        for (AndesSubscription sub : this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery)) {
            this.removeLocalSubscriptionAndNotify(sub);
        }
    }

    public AndesSubscription getSubscriptionByProtocolChannel(UUID channelID, ProtocolType protocolType) {
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.CHANNEL_ID, (Object)channelID), (Query)QueryFactory.equal(AndesSubscription.NODE_ID, (Object)this.localNodeId), (Query)QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType)));
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery).iterator().next();
    }

    public AndesSubscription getSubscriptionByProtocolChannel(UUID channelID) {
        Equal subscriptionQuery = QueryFactory.equal(AndesSubscription.CHANNEL_ID, (Object)channelID);
        Iterable<AndesSubscription> subscriptions = this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
        Iterator<AndesSubscription> subIterator = subscriptions.iterator();
        if (subIterator.hasNext()) {
            return subIterator.next();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No subscription found for channel ID " + channelID));
        }
        return null;
    }

    public AndesSubscription getSubscriptionById(String subscriptionId) {
        Equal subscriptionQuery = QueryFactory.equal(AndesSubscription.SUB_ID, (Object)subscriptionId);
        Iterable<AndesSubscription> subscriptions = this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
        Iterator<AndesSubscription> subIterator = subscriptions.iterator();
        if (subIterator.hasNext()) {
            return subIterator.next();
        }
        log.warn((Object)("No subscription found for subscription ID " + subscriptionId));
        return null;
    }

    public Iterable<AndesSubscription> getSubscriptionsByNode(String nodeId) {
        Equal subscriptionQuery = QueryFactory.equal(AndesSubscription.NODE_ID, (Object)nodeId);
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public Iterable<AndesSubscription> getAllLocalSubscriptions(ProtocolType protocolType) {
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.NODE_ID, (Object)this.localNodeId), (Query)QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType)));
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public Iterable<AndesSubscription> getAllLocalSubscriptions() {
        Equal subscriptionQuery = QueryFactory.equal(AndesSubscription.NODE_ID, (Object)this.localNodeId);
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public Iterable<AndesSubscription> getAllSubscriptionsByQueue(ProtocolType protocolType, String storageQueueName) {
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType)), (Query)QueryFactory.equal(AndesSubscription.STORAGE_QUEUE_NAME, (Object)storageQueueName));
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public Iterable<AndesSubscription> getAllLocalSubscriptionsByQueue(ProtocolType protocolType, String storageQueueName) {
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.NODE_ID, (Object)this.localNodeId), (Query)QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType)), (Query)QueryFactory.equal(AndesSubscription.STORAGE_QUEUE_NAME, (Object)storageQueueName));
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public boolean isActiveLocalSubscriptionsExistForQueue(String storageQueueName) {
        boolean isActiveSubscriptionExist = false;
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.NODE_ID, (Object)this.localNodeId), (Query)QueryFactory.equal(AndesSubscription.STORAGE_QUEUE_NAME, (Object)storageQueueName));
        Iterable<AndesSubscription> subscriptions = this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
        for (AndesSubscription subscription : subscriptions) {
            if (!subscription.isActive()) continue;
            isActiveSubscriptionExist = true;
            break;
        }
        return isActiveSubscriptionExist;
    }

    public Iterable<AndesSubscription> getAllLocalSubscriptionsByRoutingKey(ProtocolType protocolType, String routingKey) {
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.NODE_ID, (Object)this.localNodeId), (Query)QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType)), (Query)QueryFactory.equal(AndesSubscription.ROUTING_KEY, (Object)routingKey));
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public Iterable<AndesSubscription> getAllSubscriptions(ProtocolType protocolType) {
        Equal subscriptionQuery = QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType));
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public Iterable<AndesSubscription> getAllSubscriptionsByQueue(String storageQueueName) {
        Equal subscriptionQuery = QueryFactory.equal(AndesSubscription.STORAGE_QUEUE_NAME, (Object)storageQueueName);
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public Iterable<AndesSubscription> getAllSubscriptionsByRoutingKey(ProtocolType protocolType, String routingKey) {
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType)), (Query)QueryFactory.equal(AndesSubscription.ROUTING_KEY, (Object)routingKey));
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public Iterable<AndesSubscription> getAllSubscriptionsByMessageRouter(ProtocolType protocolType, String messageRouterName) {
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType)), (Query)QueryFactory.equal(AndesSubscription.ROUTER_NAME, (Object)messageRouterName));
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public Iterable<AndesSubscription> getAllLocalSubscriptionsByMessageRouter(ProtocolType protocolType, String messageRouterName) {
        And subscriptionQuery = QueryFactory.and((Query)QueryFactory.equal(AndesSubscription.PROTOCOL, (Object)((Object)protocolType)), (Query)QueryFactory.equal(AndesSubscription.ROUTER_NAME, (Object)messageRouterName), (Query)QueryFactory.equal(AndesSubscription.NODE_ID, (Object)this.localNodeId));
        return this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
    }

    public void removeAllSubscriptionsOfNodeFromMemory(String nodeId) throws AndesException {
        Iterable<AndesSubscription> subscriptionsOfNode = this.getSubscriptionsByNode(nodeId);
        for (AndesSubscription sub : subscriptionsOfNode) {
            this.removeRemoteSubscriptionFromMemory(sub);
        }
    }

    public void removeAllSubscriptionsOfNodeFromMemoryAndStore(String nodeId) throws AndesException {
        Iterable<AndesSubscription> subscriptionsOfNode = this.getSubscriptionsByNode(nodeId);
        for (AndesSubscription sub : subscriptionsOfNode) {
            this.removeRemoteSubscriptionFromMemoryAndStore(sub);
        }
    }

    public void closeAllLocalSubscriptionsBoundToQueue(String storageQueueName) throws AndesException {
        StorageQueue queue = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(storageQueueName);
        List<AndesSubscription> subscriptions = queue.getBoundSubscriptions();
        for (AndesSubscription subscription : subscriptions) {
            SubscriberConnection connection = subscription.getSubscriberConnection();
            UUID channelID = connection.getProtocolChannelID();
            String nodeID = connection.getConnectedNode();
            if (!nodeID.equals(this.localNodeId)) continue;
            subscription.closeConnection(channelID, nodeID);
            this.removeLocalSubscriptionAndNotify(subscription);
        }
    }

    public int numberOfSubscriptionsInCluster(String queueName, ProtocolType protocolType) throws AndesException {
        Iterable<AndesSubscription> subscriptions = this.getAllSubscriptionsByQueue(protocolType, queueName);
        ArrayList<AndesSubscription> subscriptionList = new ArrayList<AndesSubscription>();
        for (AndesSubscription subscription : subscriptions) {
            subscriptionList.add(subscription);
        }
        return subscriptionList.size();
    }

    public void forcefullyDisconnectAllLocalSubscriptions() throws AndesException {
        Iterable<AndesSubscription> localSubscriptions = this.getAllLocalSubscriptions();
        for (AndesSubscription localSubscription : localSubscriptions) {
            localSubscription.forcefullyDisconnectConnections();
        }
    }

    public void closeAllSubscriptionsBoundToQueue(String storageQueueName) throws AndesException {
        Equal subscriptionQuery = QueryFactory.equal(AndesSubscription.STORAGE_QUEUE_NAME, (Object)storageQueueName);
        Iterable<AndesSubscription> subscriptions = this.subscriptionRegistry.exucuteQuery((Query<AndesSubscription>)subscriptionQuery);
        for (AndesSubscription subscription : subscriptions) {
            SubscriberConnection connection = subscription.getSubscriberConnection();
            UUID channelID = connection.getProtocolChannelID();
            String nodeID = connection.getConnectedNode();
            subscription.closeConnection(channelID, nodeID);
            this.removeLocalSubscriptionAndNotify(subscription);
        }
    }

    public void closeAllActiveLocalSubscriptions() {
        Iterable<AndesSubscription> subscriptionsOfNode = this.getSubscriptionsByNode(this.localNodeId);
        for (AndesSubscription sub : subscriptionsOfNode) {
            SubscriberConnection connectionInfo = sub.getSubscriberConnection();
            UUID channelID = connectionInfo.getProtocolChannelID();
            try {
                sub.closeConnection(channelID, this.localNodeId);
            }
            catch (AndesException e) {
                log.warn((Object)"Error occurred while closing the connection", (Throwable)e);
            }
            this.removeLocalSubscriptionAndNotify(sub);
        }
    }

    public void updateSubscriptionsAfterClusterMerge() throws AndesException {
        this.clusterNotificationAgent.notifyAnyDBChange();
    }

    public void reloadSubscriptionsFromStorage() throws AndesException {
        Map<String, List<String>> results = AndesContext.getInstance().getAndesContextStore().getAllStoredDurableSubscriptions();
        HashSet<AndesSubscription> dbSubscriptions = new HashSet<AndesSubscription>();
        HashSet<AndesSubscription> localSubscriptions = new HashSet<AndesSubscription>();
        HashSet<AndesSubscription> copyOfLocalSubscriptions = new HashSet<AndesSubscription>();
        Iterable<AndesSubscription> registeredLocalSubscriptions = this.getAllLocalSubscriptions();
        for (AndesSubscription andesSubscription : registeredLocalSubscriptions) {
            localSubscriptions.add(andesSubscription);
        }
        copyOfLocalSubscriptions.addAll(localSubscriptions);
        for (Map.Entry entry : results.entrySet()) {
            for (String string : (List)entry.getValue()) {
                try {
                    AndesSubscription subscription = new AndesSubscription(string);
                    dbSubscriptions.add(subscription);
                }
                catch (SubscriptionException e) {
                    log.error((Object)("Could not add subscription: " + string), (Throwable)e);
                }
            }
        }
        localSubscriptions.removeAll(dbSubscriptions);
        final ArrayList<AndesSubscription> subscriptionsToBeDisconnected = new ArrayList<AndesSubscription>();
        for (AndesSubscription andesSubscription : localSubscriptions) {
            boolean bl = false;
            for (AndesSubscription andesSubscription2 : dbSubscriptions) {
                if (this.sharedSubscribersAllowed || !ExchangeDefaults.TOPIC_EXCHANGE_NAME.equals(andesSubscription.getStorageQueue().getMessageRouter().getName()) || !andesSubscription.getStorageQueue().equals(andesSubscription2.getStorageQueue()) || andesSubscription.getSubscriberConnection().getConnectedNode().equals(andesSubscription2.getSubscriberConnection().getConnectedNode())) continue;
                bl = true;
                subscriptionsToBeDisconnected.add(andesSubscription);
                break;
            }
            if (bl) continue;
            log.warn((Object)("Subscriptions are not in sync. Local Subscription available in subscription registry of node " + this.localNodeId + " but not in DB. Thus adding to DB subscription=" + andesSubscription.toString()));
            this.andesContextStore.storeDurableSubscription(andesSubscription);
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                for (AndesSubscription subscription : subscriptionsToBeDisconnected) {
                    try {
                        log.warn((Object)("Conflicting subscriptions detected with same subscription id and different connected nodes. Thus disconnecting local subscription=" + subscription.toString()));
                        SubscriberConnection connection = subscription.getSubscriberConnection();
                        subscription.closeConnection(connection.getProtocolChannelID(), connection.getConnectedNode());
                    }
                    catch (AndesException e) {
                        log.error((Object)("Could not disconnect subscription=" + subscription.toString()), (Throwable)e);
                    }
                }
            }
        });
        dbSubscriptions.removeAll(copyOfLocalSubscriptions);
        for (AndesSubscription andesSubscription : dbSubscriptions) {
            String string = andesSubscription.getSubscriberConnection().getConnectedNode();
            if (!this.localNodeId.equals(string)) continue;
            log.warn((Object)("Subscriptions are not in sync. Local Subscription not available in subscription registry of node " + this.localNodeId + " but is in DB. Thus removing from DB subscription= " + andesSubscription.toString()));
            this.andesContextStore.removeDurableSubscription(andesSubscription);
        }
        dbSubscriptions = new HashSet();
        Map<String, List<String>> map = AndesContext.getInstance().getAndesContextStore().getAllStoredDurableSubscriptions();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            for (String string : entry.getValue()) {
                try {
                    AndesSubscription subscription = new AndesSubscription(string);
                    dbSubscriptions.add(subscription);
                }
                catch (SubscriptionException e) {
                    log.error((Object)("Could not add subscription: " + string), (Throwable)e);
                }
            }
        }
        HashSet<AndesSubscription> hashSet = new HashSet<AndesSubscription>();
        Iterator<AndesSubscription> iterator = this.subscriptionRegistry.getAllSubscriptions();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        dbSubscriptions.removeAll(hashSet);
        for (AndesSubscription andesSubscription : dbSubscriptions) {
            log.warn((Object)("Subscriptions are not in sync. Subscription not available in subscription registry but is in DB. Thus adding subscription to registry=" + andesSubscription.toString()));
            this.subscriptionRegistry.registerSubscription(andesSubscription);
        }
        dbSubscriptions = new HashSet();
        for (Map.Entry entry : map.entrySet()) {
            for (String subscriptionAsStr : (List)entry.getValue()) {
                try {
                    AndesSubscription subscription = new AndesSubscription(subscriptionAsStr);
                    dbSubscriptions.add(subscription);
                }
                catch (SubscriptionException e) {
                    log.error((Object)("Could not add subscription: " + subscriptionAsStr), (Throwable)e);
                }
            }
        }
        hashSet.removeAll(dbSubscriptions);
        for (AndesSubscription andesSubscription : hashSet) {
            log.warn((Object)("Subscriptions are not in sync. Subscription is available in subscription registry but not in DB. Thus removing subscription from registry = " + andesSubscription.toString()));
            this.subscriptionRegistry.removeSubscription(andesSubscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void minimumNodeCountNotFulfilled(int currentNodeCount) {
        AndesSubscriptionManager andesSubscriptionManager = this;
        synchronized (andesSubscriptionManager) {
            this.isNetworkPartitioned = true;
        }
        log.warn((Object)"Minimum node count is below required, forcefully disconnecting all subscribers");
        try {
            this.forcefullyDisconnectAllLocalSubscriptions();
        }
        catch (AndesException e) {
            log.error((Object)"error occurred while forcefully disconnecting subscriptions", (Throwable)e);
        }
    }

    @Override
    public void minimumNodeCountFulfilled(int currentNodeCount) {
        this.isNetworkPartitioned = false;
    }

    @Override
    public void clusteringOutage() {
        log.warn((Object)"Clustering outage, forcefully disconnecting all subscribers");
        try {
            this.forcefullyDisconnectAllLocalSubscriptions();
        }
        catch (AndesException e) {
            log.error((Object)"error occurred while forcefully disconnecting subscriptions", (Throwable)e);
        }
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        log.warn((Object)"Store became non-operational. Subscription changes will not be reflected in the store until the store is available.");
        this.storeUnavailable = true;
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        log.info((Object)"Store became operational.");
        this.storeUnavailable = false;
    }

    public void notifySubscriptionFlow(UUID channelId, boolean active) {
        boolean suspend;
        AndesSubscription subscription = this.getSubscriptionByProtocolChannel(channelId);
        boolean bl = suspend = !active;
        if (null != subscription) {
            subscription.getSubscriberConnection().setSuspended(suspend);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Suspend: " + suspend + " request will be ignored since no subscription could be found for channel: " + channelId));
        }
    }

    private class TopicSubscriberGauge
    implements Gauge {
        private TopicSubscriberGauge() {
        }

        public Integer getValue() {
            int count = 0;
            for (AndesSubscription ignored : AndesSubscriptionManager.this.getAllLocalSubscriptionsByMessageRouter(ProtocolType.AMQP, AMQPUtils.TOPIC_EXCHANGE_NAME)) {
                ++count;
            }
            return count;
        }
    }

    private class QueueSubscriberGauge
    implements Gauge<Integer> {
        private QueueSubscriberGauge() {
        }

        public Integer getValue() {
            int count = 0;
            for (AndesSubscription ignored : AndesSubscriptionManager.this.getAllLocalSubscriptionsByMessageRouter(ProtocolType.AMQP, AMQPUtils.DIRECT_EXCHANGE_NAME)) {
                ++count;
            }
            return count;
        }
    }
}

