/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.subscription;

import java.util.UUID;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.disruptor.inbound.InboundSubscriptionEvent;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.DurableTopicSubscriber;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.kernel.subscription.SubscriberConnection;
import org.wso2.andes.kernel.subscription.SubscriptionException;

public class AndesSubscriptionFactory {
    public AndesSubscription createLocalSubscription(InboundSubscriptionEvent subscriptionEvent, StorageQueue queueToBind) throws SubscriptionException {
        ProtocolType protocol = subscriptionEvent.getProtocol();
        SubscriberConnection subscriberConnection = subscriptionEvent.getSubscriber();
        String subscriptionIdentifier = subscriptionEvent.getSubscriptionIdentifier();
        if (null == queueToBind) {
            throw new SubscriptionException("Storage queue " + subscriptionEvent.getBoundStorageQueueName() + " is not found in local queue registry. Cannot bind the subscription id= " + subscriptionIdentifier);
        }
        String subscriptionID = UUID.randomUUID().toString();
        AndesSubscription subscriptionAdded = this.createSubscription(subscriptionID, subscriptionIdentifier, queueToBind, protocol, subscriberConnection);
        return subscriptionAdded;
    }

    private AndesSubscription createSubscription(String subscriptionId, String subscriptionIdentifier, StorageQueue storageQueue, ProtocolType protocol, SubscriberConnection subscriberConnection) throws SubscriptionException {
        String messageRouterName = storageQueue.getMessageRouter().getName();
        boolean isBoundQueueDurable = storageQueue.isDurable();
        if (messageRouterName.equals(AMQPUtils.TOPIC_EXCHANGE_NAME) && isBoundQueueDurable) {
            return new DurableTopicSubscriber(subscriptionId, subscriptionIdentifier, storageQueue, protocol, subscriberConnection);
        }
        return new AndesSubscription(subscriptionId, storageQueue, protocol, subscriberConnection);
    }
}

