/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.subscription;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.attribute.SimpleNullableAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessageFlusher;
import org.wso2.andes.kernel.MessageStatus;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.kernel.subscription.SubscriberConnection;
import org.wso2.andes.kernel.subscription.SubscriptionException;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.tools.utils.MessageTracer;
import org.wso2.carbon.metrics.manager.Counter;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Meter;
import org.wso2.carbon.metrics.manager.MetricManager;

public class AndesSubscription {
    private String subscriptionId;
    private StorageQueue storageQueue;
    private ProtocolType protocolType;
    protected boolean isActive;
    protected final SubscriberConnection subscriberConnection;
    private static Log log = LogFactory.getLog(AndesSubscription.class);
    private volatile boolean attachedToQueue = true;
    public static final Attribute<AndesSubscription, String> SUB_ID = new SimpleAttribute<AndesSubscription, String>("subID"){

        public String getValue(AndesSubscription sub, QueryOptions queryOptions) {
            return sub.subscriptionId;
        }
    };
    public static final Attribute<AndesSubscription, ProtocolType> PROTOCOL = new SimpleAttribute<AndesSubscription, ProtocolType>("protocol"){

        public ProtocolType getValue(AndesSubscription sub, QueryOptions queryOptions) {
            return sub.protocolType;
        }
    };
    public static final Attribute<AndesSubscription, String> NODE_ID = new SimpleAttribute<AndesSubscription, String>("nodeID"){

        public String getValue(AndesSubscription sub, QueryOptions queryOptions) {
            return sub.subscriberConnection.getConnectedNode();
        }
    };
    public static final Attribute<AndesSubscription, UUID> CHANNEL_ID = new SimpleAttribute<AndesSubscription, UUID>("channelID"){

        public UUID getValue(AndesSubscription sub, QueryOptions queryOptions) {
            return sub.subscriberConnection.getProtocolChannelID();
        }
    };
    public static final Attribute<AndesSubscription, String> ROUTER_NAME = new SimpleNullableAttribute<AndesSubscription, String>("routerName"){

        public String getValue(AndesSubscription sub, QueryOptions queryOptions) {
            String routerName = null;
            if (sub.storageQueue.getMessageRouter() != null) {
                routerName = sub.storageQueue.getMessageRouter().getName();
            }
            return routerName;
        }
    };
    public static final Attribute<AndesSubscription, String> ROUTING_KEY = new SimpleNullableAttribute<AndesSubscription, String>("routingKey"){

        public String getValue(AndesSubscription sub, QueryOptions queryOptions) {
            String routingKey = null;
            if (sub.getStorageQueue().getMessageRouter() != null) {
                routingKey = sub.getStorageQueue().getMessageRouterBindingKey().toLowerCase();
            }
            return routingKey;
        }
    };
    public static final Attribute<AndesSubscription, String> STORAGE_QUEUE_NAME = new SimpleAttribute<AndesSubscription, String>("storageQueue"){

        public String getValue(AndesSubscription sub, QueryOptions queryOptions) {
            return sub.storageQueue.getName();
        }
    };
    public static final Attribute<AndesSubscription, Boolean> DURABILITY = new SimpleAttribute<AndesSubscription, Boolean>("isDurable"){

        public Boolean getValue(AndesSubscription sub, QueryOptions queryOptions) {
            return sub.isDurable();
        }
    };
    public static final Attribute<AndesSubscription, Boolean> STATE = new SimpleAttribute<AndesSubscription, Boolean>("isOutboundConnectionLive"){

        public Boolean getValue(AndesSubscription sub, QueryOptions queryOptions) {
            return sub.isActive;
        }
    };

    public AndesSubscription(String subscriptionId, StorageQueue storageQueue, ProtocolType protocol, SubscriberConnection subscriberConnection) {
        this.subscriptionId = subscriptionId;
        this.storageQueue = storageQueue;
        this.protocolType = protocol;
        this.subscriberConnection = subscriberConnection;
        this.isActive = true;
    }

    private AndesSubscription cloneAndResetSubscription() {
        return new AndesSubscription(this.subscriptionId, this.storageQueue, this.protocolType, this.subscriberConnection.createFreshClone());
    }

    public AndesSubscription(String encodedSubscription) throws SubscriptionException {
        String[] propertyToken;
        SubscriberConnection subscriberConnection = null;
        block14: for (String pt : propertyToken = encodedSubscription.split(",")) {
            String[] tokens = pt.split("=", 2);
            switch (tokens[0]) {
                case "subscriptionId": {
                    this.subscriptionId = tokens[1];
                    continue block14;
                }
                case "storageQueue": {
                    String storageQueueName = tokens[1];
                    this.storageQueue = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(storageQueueName);
                    if (null != this.storageQueue) continue block14;
                    throw new SubscriptionException("StorageQueue: " + storageQueueName + " is not registered while creating subscription id=" + this.subscriptionId);
                }
                case "protocolType": {
                    this.protocolType = ProtocolType.valueOf(tokens[1]);
                    continue block14;
                }
                case "isActive": {
                    this.isActive = Boolean.parseBoolean(tokens[1]);
                    continue block14;
                }
                case "subscriberConnection": {
                    byte[] decodedBytes = Base64.decodeBase64((byte[])tokens[1].getBytes());
                    String decodedConnectionInfo = new String(decodedBytes);
                    subscriberConnection = new SubscriberConnection(decodedConnectionInfo);
                    continue block14;
                }
                default: {
                    if (tokens[0].trim().length() <= 0) continue block14;
                    throw new UnsupportedOperationException("Unexpected token " + tokens[0]);
                }
            }
        }
        this.subscriberConnection = subscriberConnection;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean isDurable() {
        return this.storageQueue.isDurable();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public StorageQueue getStorageQueue() {
        return this.storageQueue;
    }

    public String getProtocolQueue() {
        return this.subscriberConnection.getProtocolQueueName();
    }

    public ProtocolType getProtocolType() {
        return this.protocolType;
    }

    public SubscriberConnection getSubscriberConnection() {
        return this.subscriberConnection;
    }

    public void onMessageAck(long messageID) throws AndesException {
        this.subscriberConnection.onMessageAck(messageID);
    }

    public DeliverableAndesMetadata onMessageReject(long messageID, boolean reQueue, boolean isMessageBeyondLastRollback) throws AndesException {
        DeliverableAndesMetadata rejectedMessage = this.subscriberConnection.onMessageReject(messageID);
        rejectedMessage.setIsBeyondLastRollbackedMessage(isMessageBeyondLastRollback);
        Meter ackMeter = MetricManager.meter((String)"org.wso2.mb.reject.receive", (Level[])new Level[]{Level.INFO});
        ackMeter.mark();
        Counter counter = MetricManager.counter((String)"org.wso2.mb.reject.count", (Level[])new Level[]{Level.INFO});
        counter.inc();
        if (reQueue) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Message rejected id= " + rejectedMessage.getMessageID() + " reQueue= true"));
            }
            this.reDeliverMessage(rejectedMessage);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Message rejected id= " + rejectedMessage.getMessageID() + " reQueue= false"));
            }
            Andes.getInstance().moveMessageToDeadLetterChannel(rejectedMessage, rejectedMessage.getDestination());
        }
        return rejectedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverMessages() throws AndesException {
        this.prepareRecover();
        SubscriberConnection subscriberConnection = this.subscriberConnection;
        synchronized (subscriberConnection) {
            List<DeliverableAndesMetadata> unAckedMessages = this.subscriberConnection.clearAndReturnUnackedMessages();
            if (this.isDurable()) {
                Iterator<DeliverableAndesMetadata> unAckedMessageIterator = unAckedMessages.iterator();
                while (unAckedMessageIterator.hasNext()) {
                    DeliverableAndesMetadata unAckedMessage = unAckedMessageIterator.next();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Recovered message id= " + unAckedMessage.getMessageID() + " channel = " + this.subscriberConnection.getProtocolChannelID()));
                    }
                    unAckedMessage.markAsRecoveredByClient(this.subscriberConnection.getProtocolChannelID());
                    unAckedMessage.rollbackDelivery(this.subscriberConnection.getProtocolChannelID());
                    this.storageQueue.bufferMessageForDelivery(unAckedMessage);
                    unAckedMessageIterator.remove();
                }
            } else {
                for (DeliverableAndesMetadata unAckedMessage : unAckedMessages) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Recovered message id= " + unAckedMessage.getMessageID() + " channel = " + this.subscriberConnection.getProtocolChannelID()));
                    }
                    unAckedMessage.markAsRecoveredByClient(this.subscriberConnection.getProtocolChannelID());
                    unAckedMessage.rollbackDelivery(this.subscriberConnection.getProtocolChannelID());
                    this.reDeliverMessage(unAckedMessage);
                }
            }
        }
    }

    private void prepareRecover() {
        this.subscriberConnection.setObsolete();
        AndesSubscription replacingSubscription = this.cloneAndResetSubscription();
        replacingSubscription.getSubscriberConnection().setSuspended(true);
        this.storageQueue.replaceBoundSub(this, replacingSubscription);
        AndesContext.getInstance().getAndesSubscriptionManager().replaceSubscription(this, replacingSubscription);
    }

    public void rebufferUnackedMessages() throws AndesException {
        List<DeliverableAndesMetadata> unAckedMessages = this.subscriberConnection.clearAndReturnUnackedMessages();
        if (this.isDurable()) {
            for (DeliverableAndesMetadata unAckedMessage : unAckedMessages) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Recovered message id= " + unAckedMessage.getMessageID() + " channel = " + this.subscriberConnection.getProtocolChannelID()));
                }
                MessageTracer.trace(unAckedMessage.getMessageID(), unAckedMessage.getStorageQueueName(), "rebuffering message due to subscription left");
                UUID protocolChannelID = this.getSubscriberConnection().getProtocolChannelID();
                unAckedMessage.markAsNackedByClient(this.subscriberConnection.getProtocolChannelID());
                unAckedMessage.markDeliveredChannelAsClosed(protocolChannelID);
                this.storageQueue.bufferMessageForDelivery(unAckedMessage);
            }
        } else {
            ArrayList<DeliverableAndesMetadata> messagesToRemove = new ArrayList<DeliverableAndesMetadata>();
            for (DeliverableAndesMetadata unAckedMessage : unAckedMessages) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Re message id= " + unAckedMessage.getMessageID() + " channel = " + this.subscriberConnection.getProtocolChannelID()));
                }
                UUID protocolChannelID = this.getSubscriberConnection().getProtocolChannelID();
                unAckedMessage.markDeliveredChannelAsClosed(protocolChannelID);
                unAckedMessage.evaluateMessageAcknowledgement();
                if (unAckedMessage.isOKToDispose() || !unAckedMessage.isTopic() || !unAckedMessage.getLatestState().equals((Object)MessageStatus.ACKED_BY_ALL)) continue;
                messagesToRemove.add(unAckedMessage);
            }
            MessagingEngine.getInstance().deleteMessages((List<DeliverableAndesMetadata>)messagesToRemove);
        }
    }

    private void reDeliverMessage(DeliverableAndesMetadata messageMetadata) throws AndesException {
        if (!messageMetadata.isOKToDispose()) {
            MessageFlusher.getInstance().scheduleMessageForSubscription(this, messageMetadata);
            MessageTracer.trace(messageMetadata, "message re-queued to subscriber");
        } else {
            log.warn((Object)("Cannot reschedule message id= " + messageMetadata.getMessageID() + " as it is disposable. Status history " + messageMetadata.getStatusHistoryAsString()));
        }
    }

    public void closeConnection(UUID channelID, String nodeID) throws AndesException {
        String localNodeID = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
        if (nodeID.equals(localNodeID)) {
            this.subscriberConnection.forcefullyDisconnect();
            try {
                ArrayList<DeliverableAndesMetadata> messagesToRemove = new ArrayList<DeliverableAndesMetadata>();
                for (DeliverableAndesMetadata andesMetadata : this.getSubscriberConnection().getUnAckedMessages()) {
                    andesMetadata.markDeliveredChannelAsClosed(channelID);
                    if (this.isDurable()) continue;
                    andesMetadata.evaluateMessageAcknowledgement();
                    if (andesMetadata.isOKToDispose() || !andesMetadata.isTopic() || !andesMetadata.getLatestState().equals((Object)MessageStatus.ACKED_BY_ALL)) continue;
                    messagesToRemove.add(andesMetadata);
                }
                MessagingEngine.getInstance().deleteMessages((List<DeliverableAndesMetadata>)messagesToRemove);
            }
            catch (AndesException e) {
                throw new SubscriptionException("Could not delete ACKED_BY_ALL messages on non durable subscription close");
            }
        }
    }

    public void forcefullyDisconnectConnections() throws AndesException {
        this.subscriberConnection.forcefullyDisconnect();
    }

    public boolean isLocal() {
        String myNodeID = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
        String connectedNode = null == this.getSubscriberConnection() ? "" : this.getSubscriberConnection().getConnectedNode();
        return connectedNode.equals(myNodeID);
    }

    public String toString() {
        return "subscriptionId=" + this.subscriptionId + ",storageQueue=" + this.storageQueue.getName() + ",protocolType=" + this.protocolType.toString() + ",isActive=" + this.isActive + ",connection= [ " + this.getSubscriberConnection().toString() + " ]";
    }

    public boolean equals(Object o) {
        if (o instanceof AndesSubscription) {
            AndesSubscription c = (AndesSubscription)o;
            return this.subscriptionId.equals(c.subscriptionId);
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.subscriptionId).toHashCode();
    }

    public String encodeAsStr() {
        byte[] encodedConnectionAsBytes = Base64.encodeBase64((byte[])this.subscriberConnection.encodeAsString().getBytes());
        String encodedConnectionInfo = new String(encodedConnectionAsBytes);
        return "subscriptionId=" + this.subscriptionId + ",storageQueue=" + this.storageQueue.getName() + ",protocolType=" + this.protocolType.toString() + ",isActive=" + Boolean.toString(this.isActive) + ",subscriberConnection=" + encodedConnectionInfo;
    }

    public boolean isAttached() {
        return this.attachedToQueue;
    }

    void detach() {
        this.attachedToQueue = false;
    }

    void clearUnackedMessages() {
        this.subscriberConnection.clearAndReturnUnackedMessages();
    }
}

