/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import java.util.EnumSet;
import org.apache.commons.lang.NotImplementedException;

public enum SlotState {
    CREATED(1),
    ASSIGNED(2),
    OVERLAPPED(3),
    RETURNED(4),
    DELETED(5);

    private int code;
    private EnumSet<SlotState> next;
    private EnumSet<SlotState> previous;

    private SlotState(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static SlotState getById(int id) {
        switch (id) {
            case 1: {
                return CREATED;
            }
            case 2: {
                return ASSIGNED;
            }
            case 3: {
                return OVERLAPPED;
            }
            case 4: {
                return RETURNED;
            }
            case 5: {
                return DELETED;
            }
        }
        throw new NotImplementedException();
    }

    public boolean isValidNextTransition(SlotState nextState) {
        return this.next.contains((Object)nextState);
    }

    public boolean isValidPreviousState(SlotState previousState) {
        return this.previous.contains((Object)previousState);
    }

    static SlotState parseSlotState(int state) {
        for (SlotState s : SlotState.values()) {
            if (s.code != state) continue;
            return s;
        }
        throw new IllegalArgumentException("Invalid slot state agument speicified: " + state);
    }

    static {
        SlotState.CREATED.next = EnumSet.of(ASSIGNED);
        SlotState.CREATED.previous = EnumSet.complementOf(EnumSet.allOf(SlotState.class));
        SlotState.ASSIGNED.next = EnumSet.of(OVERLAPPED, DELETED, RETURNED);
        SlotState.ASSIGNED.previous = EnumSet.of(CREATED, RETURNED);
        SlotState.OVERLAPPED.next = EnumSet.of(ASSIGNED, OVERLAPPED);
        SlotState.OVERLAPPED.previous = EnumSet.of(ASSIGNED, OVERLAPPED);
        SlotState.RETURNED.next = EnumSet.of(ASSIGNED, OVERLAPPED);
        SlotState.RETURNED.previous = EnumSet.of(ASSIGNED, OVERLAPPED);
        SlotState.DELETED.next = EnumSet.complementOf(EnumSet.allOf(SlotState.class));
        SlotState.DELETED.previous = EnumSet.of(ASSIGNED);
    }
}

