/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.slot.ConnectionException;

public class SlotReAssignTask
extends TimerTask {
    private String storageQueue;
    private static Log log = LogFactory.getLog(SlotReAssignTask.class);

    public SlotReAssignTask(String storageQueue) {
        this.storageQueue = storageQueue;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to reAssign slots for queue " + this.storageQueue));
        }
        try {
            MessagingEngine.getInstance().getSlotCoordinator().reAssignSlotWhenNoSubscribers(this.storageQueue);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Re-assigned slots for queue: " + this.storageQueue));
            }
        }
        catch (ConnectionException e) {
            log.error((Object)"Error occurred while re-assigning the slot to slot manager", (Throwable)e);
        }
    }
}

