/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.slot.ConnectionException;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.slot.SlotCoordinator;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;

public class SlotMessageCounter
implements StoreHealthListener {
    private ConcurrentHashMap<String, Slot> queueToSlotMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> slotTimeOutMap = new ConcurrentHashMap();
    private Long timeOutForMessagesInQueue;
    private final ScheduledExecutorService submitSlotToCoordinatorExecutor;
    private Log log = LogFactory.getLog(SlotMessageCounter.class);
    private static SlotMessageCounter slotMessageCounter = new SlotMessageCounter();
    private final int slotWindowSize;
    private long currentSlotDeleteSafeZone;
    private SlotCoordinator slotCoordinator;
    public final int SLOT_SUBMIT_TIMEOUT = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_MAX_SLOT_SUBMIT_DELAY);
    private volatile boolean messageStoresUnavailable = false;

    private SlotMessageCounter() {
        this.slotWindowSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_SLOTS_SLOT_WINDOW_SIZE);
        this.timeOutForMessagesInQueue = (Long)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_SLOTS_MESSAGE_ACCUMULATION_TIMEOUT);
        this.slotCoordinator = MessagingEngine.getInstance().getSlotCoordinator();
        FailureObservingStoreManager.registerStoreHealthListener(this);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("SlotMessageCounterTimeoutTask").build();
        this.submitSlotToCoordinatorExecutor = Executors.newScheduledThreadPool(2, namedThreadFactory);
    }

    public void scheduleSubmitSlotToCoordinatorTimer() {
        this.submitSlotToCoordinatorExecutor.scheduleWithFixedDelay(new SlotTimeoutTask(), this.SLOT_SUBMIT_TIMEOUT * 10, this.SLOT_SUBMIT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public void recordMetadataCountInSlot(Collection<AndesMessage> messageList) {
        for (AndesMessage message : messageList) {
            this.recordMetadataCountInSlot(message.getMetadata());
        }
    }

    private void recordMetadataCountInSlot(AndesMessageMetadata metadata) {
        String storageQueueName = metadata.getStorageQueueName();
        Slot currentSlot = this.updateQueueToSlotMap(metadata);
        if (this.checkMessageLimitReached(currentSlot)) {
            try {
                this.submitSlot(storageQueueName);
            }
            catch (AndesException e) {
                this.log.error((Object)("Error occurred while connecting to the thrift coordinator " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void submitCurrentSafeZone(long currentSlotDeleteSafeZone) throws ConnectionException {
        this.slotCoordinator.updateSlotDeletionSafeZone(currentSlotDeleteSafeZone);
    }

    private Slot updateQueueToSlotMap(AndesMessageMetadata metadata) {
        String storageQueueName = metadata.getStorageQueueName();
        Slot currentSlot = this.queueToSlotMap.get(storageQueueName);
        if (currentSlot == null) {
            currentSlot = new Slot();
            currentSlot.setStartMessageId(metadata.getMessageID());
            currentSlot.setEndMessageId(metadata.getMessageID());
            currentSlot.setMessageCount(1L);
            this.queueToSlotMap.put(storageQueueName, currentSlot);
            this.slotTimeOutMap.put(storageQueueName, System.currentTimeMillis());
        } else {
            long currentMsgCount = currentSlot.getMessageCount();
            long newMessageCount = currentMsgCount + 1L;
            currentSlot.setMessageCount(newMessageCount);
            currentSlot.setEndMessageId(metadata.getMessageID());
            this.queueToSlotMap.put(storageQueueName, currentSlot);
        }
        return currentSlot;
    }

    public synchronized void submitSlot(String storageQueueName) throws AndesException {
        Slot slot = this.queueToSlotMap.get(storageQueueName);
        if (null != slot) {
            Long lastSlotUpdateTime = this.slotTimeOutMap.get(storageQueueName);
            if (this.checkMessageLimitReached(slot) || this.checkTimeOutReached(lastSlotUpdateTime)) {
                try {
                    long localSafeZone = this.inferLocalSafeZone(storageQueueName);
                    this.slotTimeOutMap.remove(storageQueueName);
                    this.queueToSlotMap.remove(storageQueueName);
                    this.slotCoordinator.updateMessageId(storageQueueName, slot.getStartMessageId(), slot.getEndMessageId(), localSafeZone);
                }
                catch (ConnectionException e) {
                    this.log.error((Object)"Error occurred while connecting to the thrift coordinator.", (Throwable)e);
                }
            }
        }
    }

    private long inferLocalSafeZone(String currentStorageQueueName) {
        long localSafeZone = this.queueToSlotMap.get(currentStorageQueueName).getEndMessageId();
        for (Map.Entry<String, Slot> queueSlotEntry : this.queueToSlotMap.entrySet()) {
            if (queueSlotEntry.getKey().equals(currentStorageQueueName)) continue;
            localSafeZone = Math.min(queueSlotEntry.getValue().getStartMessageId(), localSafeZone);
        }
        return localSafeZone;
    }

    public void updateSafeZoneForNode(long currentSafeZoneVal) {
        this.currentSlotDeleteSafeZone = currentSafeZoneVal;
    }

    public long getCurrentNodeSafeZoneId() {
        return this.currentSlotDeleteSafeZone;
    }

    public static SlotMessageCounter getInstance() {
        return slotMessageCounter;
    }

    private boolean checkMessageLimitReached(Slot slot) {
        return slot.getMessageCount() >= (long)this.slotWindowSize;
    }

    private boolean checkTimeOutReached(Long lastSlotUpdateTime) {
        return System.currentTimeMillis() - lastSlotUpdateTime >= this.timeOutForMessagesInQueue;
    }

    public void stop() {
        this.log.info((Object)"Stopping slot timeout task executor");
        this.submitSlotToCoordinatorExecutor.shutdown();
    }

    public void sendRecoverySlotSubmit(long recoveryMessageId) {
        if (!this.messageStoresUnavailable) {
            try {
                this.log.info((Object)("Starting publisher slot recovery event with recovery message id " + recoveryMessageId));
                AndesContextStore contextStore = AndesContext.getInstance().getAndesContextStore();
                List<StorageQueue> queueList = contextStore.getAllQueuesStored();
                for (StorageQueue queue : queueList) {
                    this.slotCoordinator.updateMessageId(queue.getName(), recoveryMessageId, recoveryMessageId, this.currentSlotDeleteSafeZone);
                    this.log.info((Object)("Moving last published message id of queue " + queue.getName() + " to " + ++recoveryMessageId));
                }
                this.log.info((Object)("Publisher slot recovery event completed for " + queueList.size() + " queue(s). Recovery message id " + recoveryMessageId));
            }
            catch (ConnectionException e) {
                this.log.error((Object)"Error occurred while connecting to Thrift server", (Throwable)e);
            }
            catch (AndesException e) {
                this.log.error((Object)"Error occurred while executing scheduled submit slot", (Throwable)e);
            }
        }
    }

    public void setSlotCoordinator(SlotCoordinator slotCoordinator) {
        this.slotCoordinator = slotCoordinator;
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        this.log.info((Object)"Message store became non-operational. Slot message counter paused.");
        this.messageStoresUnavailable = true;
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        this.log.info((Object)"Message store became operational. Slot message counter resumed.");
        this.messageStoresUnavailable = false;
    }

    private class SlotTimeoutTask
    implements Runnable {
        private SlotTimeoutTask() {
        }

        @Override
        public void run() {
            try {
                Set<Map.Entry<String, Long>> slotTimeoutEntries = SlotMessageCounter.this.slotTimeOutMap.entrySet();
                if (!slotTimeoutEntries.isEmpty()) {
                    this.updateCoordinatorWithTimedOutSlots(slotTimeoutEntries);
                } else {
                    this.updateCoordinatorWithCurrentSafezone();
                }
            }
            catch (Throwable exception) {
                SlotMessageCounter.this.log.error((Object)"Error occurred while executing SlotTimeoutTask", exception);
            }
        }

        private void updateCoordinatorWithTimedOutSlots(Set<Map.Entry<String, Long>> slotTimeoutEntries) {
            for (Map.Entry<String, Long> entry : slotTimeoutEntries) {
                Long lastSlotUpdateTime = entry.getValue();
                String storageQueueName = entry.getKey();
                if (!SlotMessageCounter.this.checkTimeOutReached(lastSlotUpdateTime)) continue;
                try {
                    SlotMessageCounter.this.submitSlot(storageQueueName);
                }
                catch (AndesException exception) {
                    SlotMessageCounter.this.log.error((Object)"Error occurred while connecting to the thrift coordinator ", (Throwable)exception);
                }
            }
        }

        private void updateCoordinatorWithCurrentSafezone() {
            try {
                long evaluatedSafeZone = SlotMessageCounter.this.currentSlotDeleteSafeZone;
                for (Map.Entry slotEntry : SlotMessageCounter.this.queueToSlotMap.entrySet()) {
                    if (SlotMessageCounter.this.checkMessageLimitReached((Slot)slotEntry.getValue())) continue;
                    evaluatedSafeZone = Math.min(((Slot)slotEntry.getValue()).getStartMessageId(), evaluatedSafeZone);
                }
                if (SlotMessageCounter.this.log.isDebugEnabled()) {
                    SlotMessageCounter.this.log.debug((Object)("Updating coordinator with local safe zone " + evaluatedSafeZone));
                }
                SlotMessageCounter.this.submitCurrentSafeZone(evaluatedSafeZone);
                SlotMessageCounter.this.currentSlotDeleteSafeZone = evaluatedSafeZone;
            }
            catch (ConnectionException e) {
                SlotMessageCounter.this.log.error((Object)"Error while sending slot deletion safe zone update", (Throwable)e);
            }
        }
    }
}

