/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.slot.AbstractSlotManager;
import org.wso2.andes.kernel.slot.Slot;

public class SlotManagerStandalone
extends AbstractSlotManager {
    private ConcurrentHashMap<String, TreeSet<Long>> slotIDMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> queueToLastAssignedIDMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TreeSet<Slot>> unAssignedSlotMap;
    private ConcurrentHashMap<String, TreeSet<Slot>> slotAssignmentMap = new ConcurrentHashMap();
    private static SlotManagerStandalone slotManagerStandalone = new SlotManagerStandalone();
    private static Log log = LogFactory.getLog(SlotManagerStandalone.class);

    private SlotManagerStandalone() {
        this.unAssignedSlotMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slot getSlot(String queueName) {
        String lockKey = queueName + SlotManagerStandalone.class;
        String string = lockKey.intern();
        synchronized (string) {
            Slot slotToBeAssigned = this.getUnassignedSlot(queueName);
            if (null == slotToBeAssigned) {
                slotToBeAssigned = this.getFreshSlot(queueName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Slot Manager - giving a slot from fresh pool. Slot= " + slotToBeAssigned));
                }
            }
            if (null == slotToBeAssigned) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Slot Manager - returns empty slot for the queue: " + queueName));
                }
            } else {
                this.updateSlotAssignmentMap(queueName, slotToBeAssigned);
            }
            return slotToBeAssigned;
        }
    }

    private Slot getUnassignedSlot(String queueName) {
        Slot slotToBeAssigned = null;
        TreeSet<Slot> unAssignedSlotSet = this.unAssignedSlotMap.get(queueName);
        if (null != unAssignedSlotSet) {
            slotToBeAssigned = unAssignedSlotSet.pollFirst();
        }
        return slotToBeAssigned;
    }

    private Slot getFreshSlot(String queueName) {
        Slot slotToBeAssigned = null;
        Long endMessageId = null;
        TreeSet<Long> messageIDSet = this.slotIDMap.get(queueName);
        Long lastAssignedId = this.queueToLastAssignedIDMap.get(queueName);
        if (null != messageIDSet) {
            endMessageId = messageIDSet.pollFirst();
        }
        if (this.isSafeToDeliverSlots(queueName, endMessageId)) {
            if (null != endMessageId) {
                slotToBeAssigned = new Slot();
                if (null != lastAssignedId) {
                    slotToBeAssigned.setStartMessageId(lastAssignedId + 1L);
                } else {
                    slotToBeAssigned.setStartMessageId(0L);
                }
                slotToBeAssigned.setEndMessageId(endMessageId);
                slotToBeAssigned.setStorageQueueName(queueName);
                this.slotIDMap.put(queueName, messageIDSet);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(slotToBeAssigned.getEndMessageId() + " removed to slotIdMap. Current values in map " + messageIDSet));
                }
                this.queueToLastAssignedIDMap.put(queueName, slotToBeAssigned.getEndMessageId());
            }
        } else {
            log.warn((Object)("Slot delivery worker is requesting the messages which are currently in deletion range for queue " + queueName));
        }
        return slotToBeAssigned;
    }

    private void updateSlotAssignmentMap(String queueName, Slot assignedSlot) {
        TreeSet<Slot> assignedSlotSet = this.slotAssignmentMap.get(queueName);
        if (null == assignedSlotSet) {
            assignedSlotSet = new TreeSet();
        }
        assignedSlotSet.add(assignedSlot);
        this.slotAssignmentMap.put(queueName, assignedSlotSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageID(String queueName, Long lastMessageIdInTheSlot) {
        TreeSet<Long> messageIdSet = this.slotIDMap.get(queueName);
        if (messageIdSet == null) {
            messageIdSet = new TreeSet();
        }
        String lockKey = queueName + SlotManagerStandalone.class;
        String string = lockKey.intern();
        synchronized (string) {
            messageIdSet.add(lastMessageIdInTheSlot);
            this.slotIDMap.put(queueName, messageIdSet);
            if (log.isDebugEnabled()) {
                log.debug((Object)(lastMessageIdInTheSlot + " added to slotIdMap. Current values in map " + messageIdSet));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSlot(String queueName, Slot slotToBeDeleted) {
        String lockKey = queueName + SlotManagerStandalone.class;
        String string = lockKey.intern();
        synchronized (string) {
            TreeSet<Slot> assignedSlotSet = this.slotAssignmentMap.get(queueName);
            if (null != assignedSlotSet) {
                Iterator<Slot> assignedSlotIterator = assignedSlotSet.iterator();
                while (assignedSlotIterator.hasNext()) {
                    Slot assignedSlot = assignedSlotIterator.next();
                    if (assignedSlot.getEndMessageId() != slotToBeDeleted.getEndMessageId()) continue;
                    assignedSlotIterator.remove();
                    break;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reAssignSlotWhenNoSubscribers(String queueName) {
        TreeSet<Slot> slotsToBeReAssigned = this.slotAssignmentMap.remove(queueName);
        String lockKey = queueName + SlotManagerStandalone.class;
        if (null != slotsToBeReAssigned) {
            String string = lockKey.intern();
            synchronized (string) {
                TreeSet<Slot> unassignedSlots = this.unAssignedSlotMap.get(queueName);
                if (null == unassignedSlots) {
                    unassignedSlots = new TreeSet();
                }
                for (Slot slotToBeReAssigned : slotsToBeReAssigned) {
                    unassignedSlots.add(slotToBeReAssigned);
                }
                this.unAssignedSlotMap.put(queueName, unassignedSlots);
            }
        }
    }

    @Override
    public void clearAllActiveSlotRelationsToQueue(String queueName) {
        if (null != this.slotIDMap) {
            this.slotIDMap.remove(queueName);
        }
        if (null != this.slotAssignmentMap) {
            this.slotAssignmentMap.remove(queueName);
        }
        if (null != this.unAssignedSlotMap) {
            this.unAssignedSlotMap.remove(queueName);
        }
    }

    @Override
    public Set<String> getAllQueues() throws AndesException {
        return this.slotIDMap.keySet();
    }

    public static SlotManagerStandalone getInstance() {
        return slotManagerStandalone;
    }

    public Long getLastAssignedSlotMessageIdInStandaloneMode(String queueName) {
        return this.slotIDMap.get(queueName).last();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSafeZoneLowerBoundId(String queueName) throws AndesException {
        long lowerBoundId = -1L;
        String lockKey = queueName + SlotManagerStandalone.class;
        String string = lockKey.intern();
        synchronized (string) {
            TreeSet<Long> messageIDSet = this.slotIDMap.get(queueName);
            if (messageIDSet.size() >= this.safetySlotCount) {
                lowerBoundId = messageIDSet.toArray(new Long[messageIDSet.size()])[this.safetySlotCount - 1] + 1L;
                this.setDeletionTaskState(queueName, lowerBoundId);
            }
        }
        return lowerBoundId;
    }
}

