/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.slot.AbstractSlotManager;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.slot.SlotDeleteSafeZoneCalc;
import org.wso2.andes.kernel.slot.SlotDeletionExecutor;
import org.wso2.andes.kernel.slot.SlotMessageCounter;
import org.wso2.andes.kernel.slot.SlotState;
import org.wso2.andes.server.cluster.coordination.SlotAgent;
import org.wso2.andes.server.cluster.coordination.rdbms.DatabaseSlotAgent;

public class SlotManagerClusterMode
extends AbstractSlotManager {
    private static final int INITIAL_MESSAGE_ID = -1;
    private static final Log log = LogFactory.getLog(SlotManagerClusterMode.class);
    private static final SlotManagerClusterMode slotManager = new SlotManagerClusterMode();
    private static final int SAFE_ZONE_EVALUATION_INTERVAL = 5000;
    private final SlotDeleteSafeZoneCalc slotDeleteSafeZoneCalc = new SlotDeleteSafeZoneCalc(5000);
    private long firstMessageId;
    private AtomicBoolean slotRecoveryScheduled;
    private Set<String> queuesToRecover;
    private SlotAgent slotAgent;

    private SlotManagerClusterMode() {
        new Thread(this.slotDeleteSafeZoneCalc).start();
        this.slotAgent = new DatabaseSlotAgent();
        this.firstMessageId = -1L;
        this.slotRecoveryScheduled = new AtomicBoolean(false);
    }

    public static SlotManagerClusterMode getInstance() {
        return slotManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slot getSlot(String queueName, String nodeId) throws AndesException {
        Slot slotToBeAssigned;
        String lockKey = queueName + SlotManagerClusterMode.class;
        String string = lockKey.intern();
        synchronized (string) {
            slotToBeAssigned = this.getUnassignedSlot(queueName);
            if (null == slotToBeAssigned) {
                slotToBeAssigned = this.getOverlappedSlot(nodeId, queueName);
            }
            if (null == slotToBeAssigned) {
                slotToBeAssigned = this.getFreshSlot(queueName, nodeId);
            }
            if (null != slotToBeAssigned) {
                this.updateSlotAssignmentMap(queueName, slotToBeAssigned, nodeId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Assigning slot for node : " + nodeId + " | " + slotToBeAssigned));
                }
            }
        }
        return slotToBeAssigned;
    }

    private Slot getFreshSlot(String queueName, String nodeId) throws AndesException {
        Slot slotToBeAssigned = null;
        Long endMessageId = null;
        TreeSet<Long> messageIDSet = this.slotAgent.getSlotBasedMessageIds(queueName);
        long lastAssignedId = this.slotAgent.getQueueToLastAssignedId(queueName);
        if (null != messageIDSet) {
            endMessageId = messageIDSet.pollFirst();
        }
        if (this.isSafeToDeliverSlots(queueName, endMessageId)) {
            if (null != endMessageId) {
                slotToBeAssigned = new Slot();
                if (0L != lastAssignedId) {
                    slotToBeAssigned.setStartMessageId(lastAssignedId + 1L);
                } else {
                    slotToBeAssigned.setStartMessageId(0L);
                }
                slotToBeAssigned.setEndMessageId(endMessageId);
                this.slotAgent.deleteMessageId(queueName, slotToBeAssigned.getEndMessageId());
                slotToBeAssigned.setStorageQueueName(queueName);
                this.slotAgent.createSlot(slotToBeAssigned.getStartMessageId(), slotToBeAssigned.getEndMessageId(), slotToBeAssigned.getStorageQueueName(), nodeId);
                this.slotAgent.setQueueToLastAssignedId(queueName, slotToBeAssigned.getEndMessageId());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Giving a slot from fresh pool. Slot: " + slotToBeAssigned.getId()));
                }
            }
        } else {
            log.warn((Object)("Slot delivery worker is requesting the messages which are currently in deletion range for queue" + queueName));
        }
        return slotToBeAssigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Slot getUnassignedSlot(String queueName) throws AndesException {
        Slot slotToBeAssigned;
        String lockKey = queueName + SlotManagerClusterMode.class;
        String string = lockKey.intern();
        synchronized (string) {
            slotToBeAssigned = this.slotAgent.getUnAssignedSlot(queueName);
            if (log.isDebugEnabled() && null != slotToBeAssigned) {
                log.debug((Object)("Giving a slot from unassigned slots. Slot: " + slotToBeAssigned + " to queue: " + queueName));
            }
        }
        return slotToBeAssigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Slot getOverlappedSlot(String nodeId, String queueName) throws AndesException {
        Slot slotToBeAssigned;
        String lockKey = queueName + SlotManagerClusterMode.class;
        String string = lockKey.intern();
        synchronized (string) {
            slotToBeAssigned = this.slotAgent.getOverlappedSlot(nodeId, queueName);
            if (log.isDebugEnabled() && null != slotToBeAssigned) {
                log.debug((Object)(" Giving overlapped slot id=" + slotToBeAssigned.getId() + " queue name= " + queueName));
            }
        }
        return slotToBeAssigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSlotAssignmentMap(String queueName, Slot allocatedSlot, String nodeId) throws AndesException {
        String lockKey = nodeId + SlotManagerClusterMode.class;
        String string = lockKey.intern();
        synchronized (string) {
            this.slotAgent.updateSlotAssignment(nodeId, queueName, allocatedSlot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageID(String queueName, String nodeId, long startMessageIdInTheSlot, long lastMessageIdInTheSlot, long localSafeZone) throws AndesException {
        if (this.firstMessageId > startMessageIdInTheSlot || this.firstMessageId == -1L) {
            this.firstMessageId = startMessageIdInTheSlot;
        }
        if (this.slotRecoveryScheduled.get()) {
            this.queuesToRecover.remove(queueName);
        }
        TreeSet<Long> messageIdSet = this.slotAgent.getSlotBasedMessageIds(queueName);
        String lockKey = queueName + SlotManagerClusterMode.class;
        String string = lockKey.intern();
        synchronized (string) {
            long lastAssignedMessageId = this.slotAgent.getQueueToLastAssignedId(queueName);
            if (startMessageIdInTheSlot < lastAssignedMessageId) {
                TreeSet<Slot> overlappingSlots;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found overlapping slots during slot submit: " + startMessageIdInTheSlot + " to : " + lastMessageIdInTheSlot + ". Comparing to lastAssignedID : " + lastAssignedMessageId));
                }
                if (!(overlappingSlots = this.getOverlappedAssignedSlots(queueName, startMessageIdInTheSlot, lastMessageIdInTheSlot)).isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found " + overlappingSlots.size() + " overlapping slots."));
                    }
                    if (startMessageIdInTheSlot < overlappingSlots.first().getStartMessageId()) {
                        Slot leftExtraSlot = new Slot(startMessageIdInTheSlot, overlappingSlots.first().getStartMessageId() - 1L, queueName);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Left Extra Slot in overlapping slots : " + leftExtraSlot));
                        }
                    }
                    if (lastMessageIdInTheSlot > overlappingSlots.last().getEndMessageId()) {
                        Slot rightExtraSlot = new Slot(overlappingSlots.last().getEndMessageId() + 1L, lastMessageIdInTheSlot, queueName);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("RightExtra in overlapping slot : " + rightExtraSlot));
                        }
                        this.slotAgent.addMessageId(queueName, lastMessageIdInTheSlot);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(lastMessageIdInTheSlot + " added to store (RightExtraSlot). Current values in store " + messageIdSet));
                        }
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A submit slot request has come from the past after deletion of any possible overlapping slots. nodeId : " + nodeId + " StartMessageID : " + startMessageIdInTheSlot + " EndMessageID : " + lastMessageIdInTheSlot));
                    }
                    this.slotAgent.addMessageId(queueName, lastMessageIdInTheSlot);
                }
            } else {
                this.slotAgent.addMessageId(queueName, lastMessageIdInTheSlot);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No overlapping slots found during slot submit " + startMessageIdInTheSlot + " to : " + lastMessageIdInTheSlot + ". Added msgID " + lastMessageIdInTheSlot + " to store"));
                }
            }
            this.slotAgent.setLocalSafeZoneOfNode(nodeId, localSafeZone);
        }
    }

    public void reassignSlotsWhenMemberLeaves(String nodeId) throws AndesException {
        TreeSet<Slot> assignedSlotsSet = this.slotAgent.getAssignedSlotsByNodeId(nodeId);
        for (Slot slotToBeReAssigned : assignedSlotsSet) {
            if (MessagingEngine.getInstance().getMessageCountForQueueInRange(slotToBeReAssigned.getStorageQueueName(), slotToBeReAssigned.getStartMessageId(), slotToBeReAssigned.getEndMessageId()) != 0L) {
                this.slotAgent.reassignSlot(slotToBeReAssigned);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Returned assigned slot " + slotToBeReAssigned + "from node " + nodeId + " as member left"));
                continue;
            }
            slotToBeReAssigned.setStorageQueue(AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(slotToBeReAssigned.getStorageQueueName()));
            SlotDeletionExecutor.getInstance().scheduleToDelete(slotToBeReAssigned);
        }
        TreeSet<Slot> overlappedSlotsSet = this.slotAgent.getOverlappedSlotsByNodeId(nodeId);
        for (Slot overlappedSlot : overlappedSlotsSet) {
            if (MessagingEngine.getInstance().getMessageCountForQueueInRange(overlappedSlot.getStorageQueueName(), overlappedSlot.getStartMessageId(), overlappedSlot.getEndMessageId()) != 0L) {
                this.slotAgent.reassignSlot(overlappedSlot);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Returned overlapped slot " + overlappedSlot + "from node " + nodeId + " as member left"));
                continue;
            }
            this.slotAgent.deleteSlot(nodeId, overlappedSlot.getStorageQueueName(), overlappedSlot.getStartMessageId(), overlappedSlot.getEndMessageId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSlot(String storageQueueName, Slot emptySlot, String nodeId) throws AndesException {
        boolean slotDeleted = false;
        long startMsgId = emptySlot.getStartMessageId();
        long endMsgId = emptySlot.getEndMessageId();
        long slotDeleteSafeZone = this.getSlotDeleteSafeZone();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to delete slot. safeZone= " + this.getSlotDeleteSafeZone() + " startMsgID: " + startMsgId));
        }
        if (slotDeleteSafeZone > endMsgId) {
            String lockKey = nodeId + SlotManagerClusterMode.class;
            String string = lockKey.intern();
            synchronized (string) {
                slotDeleted = this.slotAgent.deleteNonOverlappingSlot(nodeId, storageQueueName, startMsgId, endMsgId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Deleted slot id = " + emptySlot.getId() + " queue name = " + storageQueueName + " deleteSuccess: " + slotDeleted));
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cannot delete slot as it is within safe zone startMsgID= " + startMsgId + " safeZone= " + slotDeleteSafeZone + " endMsgId= " + endMsgId + " slotToDelete= " + emptySlot));
        }
        return slotDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reAssignSlotWhenNoSubscribers(String nodeId, String queueName) throws AndesException {
        String lockKeyForNodeId = nodeId + SlotManagerClusterMode.class;
        String string = lockKeyForNodeId.intern();
        synchronized (string) {
            this.slotAgent.deleteSlotAssignmentByQueueName(nodeId, queueName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cleared assigned slots of queue " + queueName + " Assigned to node " + nodeId));
            }
        }
    }

    protected Long getLocalSafeZone(String nodeID) throws AndesException {
        Long lastPublishId = this.slotAgent.getLocalSafeZoneOfNode(nodeID);
        return lastPublishId;
    }

    protected Set<String> getMessagePublishedNodes() throws AndesException {
        return this.slotAgent.getMessagePublishedNodes();
    }

    public long getSlotDeleteSafeZone() {
        return this.slotDeleteSafeZoneCalc.getSlotDeleteSafeZone();
    }

    public long updateAndReturnSlotDeleteSafeZone(String nodeID, long safeZoneOfNode) {
        try {
            this.slotAgent.setLocalSafeZoneOfNode(nodeID, safeZoneOfNode);
        }
        catch (AndesException e) {
            log.error((Object)("Error occurred while updating safezone value " + safeZoneOfNode + " for node " + nodeID), (Throwable)e);
        }
        return this.slotDeleteSafeZoneCalc.getSlotDeleteSafeZone();
    }

    @Override
    public void clearAllActiveSlotRelationsToQueue(String queueName) throws AndesException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing all slots for queue " + queueName));
        }
        this.slotAgent.deleteSlotsByQueueName(queueName);
        this.slotAgent.deleteMessageIdsByQueueName(queueName);
    }

    @Override
    public Set<String> getAllQueues() throws AndesException {
        return this.slotAgent.getAllQueuesInSubmittedSlots();
    }

    public void shutDownSlotManager() {
        this.slotDeleteSafeZoneCalc.setRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet<Slot> getOverlappedAssignedSlots(String queueName, long startMsgID, long endMsgID) throws AndesException {
        TreeSet<Slot> overlappedSlots = new TreeSet<Slot>();
        TreeSet<Slot> assignedOverlappingSlots = new TreeSet<Slot>();
        String lockKey = queueName + SlotManagerClusterMode.class;
        String string = lockKey.intern();
        synchronized (string) {
            TreeSet<Slot> slotListForQueue = this.slotAgent.getAllSlotsByQueueName(queueName);
            for (Slot slot : slotListForQueue) {
                if (endMsgID < slot.getStartMessageId() || startMsgID > slot.getEndMessageId()) continue;
                if (SlotState.ASSIGNED == slot.getCurrentState()) {
                    assignedOverlappingSlots.add(slot);
                }
                slot.setAnOverlappingSlot(true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Marked already assigned slot as an overlapping slot. Slot= " + slot.getId()));
                }
                overlappedSlots.add(slot);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Found an overlapping slot : " + slot));
            }
            this.slotAgent.updateOverlappedSlots(queueName, assignedOverlappingSlots);
        }
        return overlappedSlots;
    }

    public void deletePublisherNode(final String deletedNodeId) {
        int threadPoolCount = 1;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("RecoverSlotsThreadPool").build();
        ScheduledExecutorService recoverSlotScheduler = Executors.newScheduledThreadPool(threadPoolCount, namedThreadFactory);
        try {
            Set concurrentSet = Collections.newSetFromMap(new ConcurrentHashMap(this.slotAgent.getAllQueues().size()));
            concurrentSet.addAll(this.slotAgent.getAllQueues());
            this.queuesToRecover = concurrentSet;
        }
        catch (AndesException ex) {
            log.error((Object)"Failed to get all queue names", (Throwable)ex);
        }
        recoverSlotScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    long lastId = SlotMessageCounter.getInstance().getCurrentNodeSafeZoneId();
                    for (String queueName : SlotManagerClusterMode.this.queuesToRecover) {
                        try {
                            SlotManagerClusterMode.this.updateMessageID(queueName, deletedNodeId, lastId - 1L, lastId, lastId);
                        }
                        catch (AndesException ex) {
                            log.error((Object)"Failed to update message id", (Throwable)ex);
                        }
                    }
                    SlotManagerClusterMode.this.slotRecoveryScheduled.set(false);
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Removing " + deletedNodeId + " from safe zone calculation."));
                        }
                        SlotManagerClusterMode.this.slotAgent.removePublisherNode(deletedNodeId);
                    }
                    catch (AndesException e) {
                        log.error((Object)"Failed to remove publisher node ID from safe zone calculation", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Error occurred while trying to run recover slot scheduler", e);
                }
            }
        }, (long)SlotMessageCounter.getInstance().SLOT_SUBMIT_TIMEOUT, TimeUnit.MILLISECONDS);
        this.slotRecoveryScheduled.set(true);
    }

    public Long getLastAssignedSlotMessageIdInClusterMode(String queueName) throws AndesException {
        return this.slotAgent.getQueueToLastAssignedId(queueName);
    }

    public void clearSlotStorage() throws AndesException {
        this.slotAgent.clearSlotStorage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSafeZoneLowerBoundId(String queueName) throws AndesException {
        long lowerBoundId = -1L;
        String lockKey = queueName + SlotManagerClusterMode.class;
        String string = lockKey.intern();
        synchronized (string) {
            TreeSet<Long> messageIDSet = this.slotAgent.getSlotBasedMessageIds(queueName);
            if (messageIDSet.size() >= this.safetySlotCount) {
                lowerBoundId = messageIDSet.toArray(new Long[messageIDSet.size()])[this.safetySlotCount - 1] + 1L;
                this.setDeletionTaskState(queueName, lowerBoundId);
            }
        }
        return lowerBoundId;
    }
}

