/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.MessageFlusher;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.slot.CoordinatorConnectionListener;
import org.wso2.andes.kernel.slot.DeliveryTaskExceptionHandler;
import org.wso2.andes.kernel.slot.MessageDeliveryTask;
import org.wso2.andes.kernel.slot.SlotCoordinator;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.server.cluster.error.detection.NetworkPartitionListener;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;
import org.wso2.andes.task.TaskExecutorService;

public final class SlotDeliveryWorkerManager
implements StoreHealthListener,
NetworkPartitionListener,
CoordinatorConnectionListener {
    private static Log log = LogFactory.getLog(SlotDeliveryWorkerManager.class);
    private static SlotDeliveryWorkerManager slotDeliveryWorkerManager = new SlotDeliveryWorkerManager();
    private final TaskExecutorService<MessageDeliveryTask> taskManager;

    private SlotDeliveryWorkerManager() {
        int numberOfThreads = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_SLOTS_WORKER_THREAD_COUNT);
        long idleTaskDelay = (Long)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_SLOTS_IDLE_TASK_DELAY);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("MessageDeliveryTaskThreadPool-%d").build();
        this.taskManager = new TaskExecutorService(numberOfThreads, idleTaskDelay, threadFactory);
        this.taskManager.setExceptionHandler(new DeliveryTaskExceptionHandler());
    }

    public static SlotDeliveryWorkerManager getInstance() {
        return slotDeliveryWorkerManager;
    }

    public void startMessageDeliveryForQueue(StorageQueue storageQueue) throws AndesException {
        MessageDeliveryTask messageDeliveryTask = new MessageDeliveryTask(storageQueue, MessagingEngine.getInstance().getSlotCoordinator(), MessageFlusher.getInstance());
        this.taskManager.add(messageDeliveryTask);
    }

    public void stopDeliveryForQueue(StorageQueue storageQueue) {
        String storageQueueName = storageQueue.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping delivery for storage queue " + storageQueueName + " with MessageDeliveryTask : " + storageQueueName));
        }
        this.taskManager.remove(storageQueueName);
    }

    public void stopMessageDelivery() {
        this.taskManager.shutdown();
    }

    public void startMessageDelivery() {
        this.taskManager.start();
    }

    @Override
    public void minimumNodeCountNotFulfilled(int currentNodeCount) {
        log.warn((Object)("Network outage detected therefore stopping message delivery. Current cluster size " + currentNodeCount));
        this.taskManager.stop();
    }

    @Override
    public void minimumNodeCountFulfilled(int currentNodeCount) {
        log.info((Object)("Network outage resolved therefore resuming message delivery. Current cluster size " + currentNodeCount));
        this.taskManager.start();
    }

    @Override
    public void clusteringOutage() {
        log.warn((Object)"Clustering outage. Stopping message delivery");
        this.taskManager.stop();
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        log.warn((Object)"Message stores became not operational therefore waiting");
        this.taskManager.stop();
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        log.info((Object)"Message stores became operational therefore resuming work");
        this.taskManager.start();
    }

    @Override
    public void onCoordinatorDisconnect() {
        log.warn((Object)"Disconnected from the coordinator. Waiting till reconnect");
        this.taskManager.stop();
    }

    @Override
    public void onCoordinatorReconnect() {
        log.info((Object)"Coordinator connection re-established");
        this.taskManager.start();
    }

    public void initialise(SlotCoordinator slotCoordinator) {
        AndesContext andesContext = AndesContext.getInstance();
        if (andesContext.isClusteringEnabled()) {
            andesContext.getClusterAgent().addNetworkPartitionListener(50, this);
            slotCoordinator.addCoordinatorConnectionListener(this);
        }
        FailureObservingStoreManager.registerStoreHealthListener(this);
    }
}

