/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.slot.SlotDeletingTask;
import org.wso2.andes.server.cluster.error.detection.NetworkPartitionListener;

public class SlotDeletionExecutor
implements NetworkPartitionListener {
    private static Log log = LogFactory.getLog(SlotDeletionExecutor.class);
    private ExecutorService slotDeletionExecutorService;
    private static SlotDeletionExecutor instance;
    private int parallelTaskCount;
    private int numOfScheduledSlots;
    private List<SlotDeletingTask> slotDeletingTasks;

    private SlotDeletionExecutor() {
    }

    public void init(int parallelTaskCount, int maxNumberOfPendingSlots) {
        this.numOfScheduledSlots = 0;
        this.parallelTaskCount = parallelTaskCount;
        this.slotDeletingTasks = new ArrayList<SlotDeletingTask>(parallelTaskCount);
        if (AndesContext.getInstance().isClusteringEnabled()) {
            AndesContext.getInstance().getClusterAgent().addNetworkPartitionListener(40, this);
        }
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("SlotDeletionExecutor-%d").build();
        this.slotDeletionExecutorService = Executors.newFixedThreadPool(parallelTaskCount, namedThreadFactory);
        for (int taskCount = 0; taskCount < parallelTaskCount; ++taskCount) {
            SlotDeletingTask slotDeletingTask = new SlotDeletingTask(maxNumberOfPendingSlots);
            this.slotDeletingTasks.add(slotDeletingTask);
            this.slotDeletionExecutorService.submit(slotDeletingTask);
        }
    }

    public void scheduleToDelete(Slot slot) {
        ++this.numOfScheduledSlots;
        int taskIndex = this.numOfScheduledSlots % this.parallelTaskCount;
        this.slotDeletingTasks.get(taskIndex).scheduleToDelete(slot);
    }

    public void stopSlotDeletionExecutor() {
        for (SlotDeletingTask slotDeletingTask : this.slotDeletingTasks) {
            slotDeletingTask.stop();
        }
        this.slotDeletionExecutorService.shutdown();
    }

    public static SlotDeletionExecutor getInstance() {
        if (instance == null) {
            instance = new SlotDeletionExecutor();
        }
        return instance;
    }

    @Override
    public void minimumNodeCountNotFulfilled(int currentNodeCount) {
    }

    @Override
    public void minimumNodeCountFulfilled(int currentNodeCount) {
    }

    @Override
    public void clusteringOutage() {
        log.info((Object)"cluster outage detected, stopping slot deletion executor");
        this.stopSlotDeletionExecutor();
    }
}

