/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.slot.ConnectionException;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.slot.SlotMessageCounter;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class SlotDeletingTask
implements Runnable {
    private static Log log = LogFactory.getLog(SlotDeletingTask.class);
    private UUID id = UUID.randomUUID();
    private volatile boolean isLive = true;
    private LinkedBlockingDeque<Slot> slotsToDelete;
    private int maxNumberOfPendingSlots;

    void stop() {
        this.isLive = false;
    }

    public SlotDeletingTask(int maxNumberOfPendingSlots) {
        this.maxNumberOfPendingSlots = maxNumberOfPendingSlots;
        this.slotsToDelete = new LinkedBlockingDeque();
    }

    @Override
    public void run() {
        while (this.isLive) {
            try {
                Slot slot = this.slotsToDelete.take();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SlotDeletingTask id= " + this.id + " trying to delete slot " + slot.toString()));
                }
                if (MessagingEngine.getInstance().getMessageCountForQueueInRange(slot.getStorageQueueName(), slot.getStartMessageId(), slot.getEndMessageId()) == 0L) {
                    boolean deleteSuccess = this.deleteSlotAtCoordinator(slot);
                    if (!deleteSuccess) {
                        this.slotsToDelete.addFirst(slot);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("SlotDeletingTask id= " + this.id + " could not agree with coordinator to delete slot " + slot.toString()));
                        }
                        TimeUnit.SECONDS.sleep(1L);
                        continue;
                    }
                    StorageQueue storageQueue = slot.getStorageQueue();
                    storageQueue.deleteSlot(slot);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("SlotDeletingTask id= " + this.id + " deleted slot " + slot.toString()));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SlotDeletingTask id= " + this.id + " could not deleted slot " + slot.toString() + " as there are messages in range of slot"));
                }
                this.slotsToDelete.put(slot);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error((Object)"SlotDeletionTask was interrupted while trying to delete the slot.", (Throwable)e);
            }
            catch (Throwable throwable) {
                log.error((Object)"Unexpected error occurred while trying to delete the slot.", throwable);
            }
        }
        log.info((Object)("SlotDeletingTask " + this.id + " has shutdown with " + this.slotsToDelete.size() + " slots to delete."));
    }

    private boolean deleteSlotAtCoordinator(Slot slot) {
        boolean deleteSuccess = false;
        try {
            deleteSuccess = MessagingEngine.getInstance().getSlotCoordinator().deleteSlot(slot.getStorageQueueName(), slot);
        }
        catch (ConnectionException e) {
            log.error((Object)("Error while trying to delete the slot " + slot + " Thrift connection failed. Rescheduling delete."), (Throwable)e);
        }
        return deleteSuccess;
    }

    public void scheduleToDelete(Slot slot) {
        int currentNumberOfSlotsToDelete = this.slotsToDelete.size();
        if (currentNumberOfSlotsToDelete > this.maxNumberOfPendingSlots) {
            log.warn((Object)("Too many slots submitted to delete. Consider increasing <deleteTaskCount> and <thriftClientPoolSize> parameters. Current submit value = " + currentNumberOfSlotsToDelete + " safe zone value = " + SlotMessageCounter.getInstance().getCurrentNodeSafeZoneId()));
        }
        this.slotsToDelete.add(slot);
    }
}

