/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.slot.SlotManagerClusterMode;

public class SlotDeleteSafeZoneCalc
implements Runnable {
    private static Log log = LogFactory.getLog(SlotDeleteSafeZoneCalc.class);
    private AtomicLong slotDeleteSafeZone;
    private boolean running;
    private boolean isLive;
    private int seekInterval;
    private static final int TIME_TO_SLEEP_ON_ERROR = 15000;

    public SlotDeleteSafeZoneCalc(int seekInterval) {
        this.seekInterval = seekInterval;
        this.running = true;
        this.isLive = true;
        this.slotDeleteSafeZone = new AtomicLong(Long.MAX_VALUE);
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Slot deletion safe zone calculation started.");
        }
        while (this.running) {
            if (this.isLive()) {
                try {
                    Set<String> nodesWithPublishedMessages;
                    try {
                        nodesWithPublishedMessages = SlotManagerClusterMode.getInstance().getMessagePublishedNodes();
                    }
                    catch (AndesException e) {
                        log.error((Object)"SlotDeleteSafeZoneCalc stopped due to failing to get message published nodes. Retrying after 15 seconds", (Throwable)e);
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    long globalSafeZoneVal = Long.MAX_VALUE;
                    for (String nodeID : nodesWithPublishedMessages) {
                        Long safeZoneByPublishedMessages;
                        long safeZoneValue = Long.MAX_VALUE;
                        try {
                            safeZoneByPublishedMessages = SlotManagerClusterMode.getInstance().getLocalSafeZone(nodeID);
                        }
                        catch (AndesException e) {
                            log.error((Object)("SlotDeleteSafeZoneCalc stopped due to failing to get last published id for node:" + nodeID + ". Retrying after 15 seconds"), (Throwable)e);
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        if (null != safeZoneByPublishedMessages) {
                            safeZoneValue = safeZoneByPublishedMessages;
                        }
                        globalSafeZoneVal = Math.min(globalSafeZoneVal, safeZoneValue);
                    }
                    this.slotDeleteSafeZone.set(globalSafeZoneVal);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Safe Zone Calculated : " + this.slotDeleteSafeZone));
                    }
                    try {
                        Thread.sleep(this.seekInterval);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Error occurred while calculating safe zone at coordinator", e);
                }
                continue;
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        log.info((Object)("Slot delete safe zone calculator stopped. Global safe zone value " + this.slotDeleteSafeZone.get()));
    }

    public long getSlotDeleteSafeZone() {
        return this.slotDeleteSafeZone.get();
    }

    public void setSlotDeleteSafeZone(long slotDeleteSafeZone) {
        this.slotDeleteSafeZone.set(slotDeleteSafeZone);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void setLive(boolean isLive) {
        this.isLive = isLive;
    }

    public int getSeekInterval() {
        return this.seekInterval;
    }

    public void setSeekInterval(int seekInterval) {
        this.seekInterval = seekInterval;
    }
}

