/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.MessageStore;
import org.wso2.andes.kernel.slot.RecoverySlotCreator;

public class SlotCreator
implements Runnable {
    private static Log log = LogFactory.getLog(SlotCreator.class);
    private final String queueName;
    private final int slotSize;
    private final MessageStore messageStore;

    public SlotCreator(MessageStore messageStore, String queueName) {
        this.messageStore = messageStore;
        this.queueName = queueName;
        this.slotSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_SLOTS_SLOT_WINDOW_SIZE);
    }

    @Override
    public void run() {
        try {
            log.info((Object)("Slot restoring started for " + this.queueName));
            this.initializeSlotMapForQueue();
            log.info((Object)("Slot restoring ended for " + this.queueName));
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred in slot recovery", e);
        }
    }

    private void initializeSlotMapForQueue() throws AndesException, SQLException {
        RecoverySlotCreator.CallBack slotCreatorCallBack = new RecoverySlotCreator.CallBack();
        int restoreMessagesCounter = this.messageStore.recoverSlotsForQueue(this.queueName, 0L, this.slotSize, slotCreatorCallBack);
        log.info((Object)("Recovered " + restoreMessagesCounter + " messages for queue \"" + this.queueName + "\"."));
    }
}

