/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.slot.ConnectionException;
import org.wso2.andes.kernel.slot.CoordinatorConnectionListener;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.slot.SlotCoordinator;
import org.wso2.andes.server.cluster.error.detection.NetworkPartitionListener;
import org.wso2.andes.thrift.MBThriftClient;

public class SlotCoordinatorCluster
implements SlotCoordinator,
NetworkPartitionListener {
    private static Log log = LogFactory.getLog(SlotCoordinatorCluster.class);
    private String nodeId = AndesContext.getInstance().getClusterAgent().getLocalNodeIdentifier();
    private volatile SlotCoordinator instance = new ThriftSlotCoordinator();

    public SlotCoordinatorCluster() {
        AndesContext.getInstance().getClusterAgent().addNetworkPartitionListener(30, this);
    }

    @Override
    public Slot getSlot(String queueName) throws ConnectionException {
        return this.instance.getSlot(queueName);
    }

    @Override
    public void updateMessageId(String queueName, long startMessageId, long endMessageId, long localSafeZone) throws ConnectionException {
        this.instance.updateMessageId(queueName, startMessageId, endMessageId, localSafeZone);
    }

    @Override
    public void updateSlotDeletionSafeZone(long currentSlotDeleteSafeZone) throws ConnectionException {
        this.instance.updateSlotDeletionSafeZone(currentSlotDeleteSafeZone);
    }

    @Override
    public boolean deleteSlot(String queueName, Slot slot) throws ConnectionException {
        return this.instance.deleteSlot(queueName, slot);
    }

    @Override
    public void reAssignSlotWhenNoSubscribers(String queueName) throws ConnectionException {
        this.instance.reAssignSlotWhenNoSubscribers(queueName);
    }

    @Override
    public void clearAllActiveSlotRelationsToQueue(String queueName) throws ConnectionException {
        this.instance.clearAllActiveSlotRelationsToQueue(queueName);
    }

    @Override
    public void addCoordinatorConnectionListener(CoordinatorConnectionListener listener) {
        this.instance.addCoordinatorConnectionListener(listener);
    }

    @Override
    public void minimumNodeCountNotFulfilled(int currentNodeCount) {
    }

    @Override
    public void minimumNodeCountFulfilled(int currentNodeCount) {
    }

    @Override
    public void clusteringOutage() {
        if (this.instance instanceof ThriftSlotCoordinator) {
            log.info((Object)"disabling slot coordination due to cluster outage");
            this.instance = new DisabledSlotCoordinator();
        }
    }

    private class DisabledSlotCoordinator
    implements SlotCoordinator {
        private DisabledSlotCoordinator() {
        }

        @Override
        public Slot getSlot(String queueName) throws ConnectionException {
            throw new ConnectionException("cluster error detected, not connectng to cooridnator");
        }

        @Override
        public void updateMessageId(String queueName, long startMessageId, long endMessageId, long localSafeZone) throws ConnectionException {
            throw new ConnectionException("cluster error detected, not connectng to cooridnator");
        }

        @Override
        public void updateSlotDeletionSafeZone(long currentSlotDeleteSafeZone) throws ConnectionException {
            throw new ConnectionException("cluster error detected, not connectng to cooridnator");
        }

        @Override
        public boolean deleteSlot(String queueName, Slot slot) throws ConnectionException {
            throw new ConnectionException("cluster error detected, not connectng to cooridnator");
        }

        @Override
        public void reAssignSlotWhenNoSubscribers(String queueName) throws ConnectionException {
            throw new ConnectionException("cluster error detected, not connectng to cooridnator");
        }

        @Override
        public void clearAllActiveSlotRelationsToQueue(String queueName) throws ConnectionException {
            throw new ConnectionException("cluster error detected, not connectng to cooridnator");
        }

        @Override
        public void addCoordinatorConnectionListener(CoordinatorConnectionListener listener) {
        }
    }

    private class ThriftSlotCoordinator
    implements SlotCoordinator {
        private MBThriftClient thriftClient = new MBThriftClient();

        private ThriftSlotCoordinator() {
        }

        @Override
        public Slot getSlot(String queueName) throws ConnectionException {
            return this.thriftClient.getSlot(queueName, SlotCoordinatorCluster.this.nodeId);
        }

        @Override
        public void updateMessageId(String queueName, long startMessageId, long endMessageId, long localSafeZone) throws ConnectionException {
            this.thriftClient.updateMessageId(queueName, SlotCoordinatorCluster.this.nodeId, startMessageId, endMessageId, localSafeZone);
        }

        @Override
        public void updateSlotDeletionSafeZone(long currentSlotDeleteSafeZone) throws ConnectionException {
            this.thriftClient.updateSlotDeletionSafeZone(currentSlotDeleteSafeZone, SlotCoordinatorCluster.this.nodeId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Submitted safe zone from node : " + SlotCoordinatorCluster.this.nodeId + " | safe zone : " + currentSlotDeleteSafeZone));
            }
        }

        @Override
        public boolean deleteSlot(String queueName, Slot slot) throws ConnectionException {
            return this.thriftClient.deleteSlot(queueName, slot, SlotCoordinatorCluster.this.nodeId);
        }

        @Override
        public void reAssignSlotWhenNoSubscribers(String queueName) throws ConnectionException {
            this.thriftClient.reAssignSlotWhenNoSubscribers(SlotCoordinatorCluster.this.nodeId, queueName);
        }

        @Override
        public void clearAllActiveSlotRelationsToQueue(String queueName) throws ConnectionException {
            this.thriftClient.clearAllActiveSlotRelationsToQueue(queueName);
        }

        @Override
        public void addCoordinatorConnectionListener(CoordinatorConnectionListener listener) {
            this.thriftClient.addConnectionListener(listener);
        }
    }
}

