/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.slot.SlotDeletionExecutor;
import org.wso2.andes.kernel.slot.SlotState;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class Slot
implements Serializable,
Comparable<Slot> {
    private static Log log = LogFactory.getLog(Slot.class);
    private long messageCount;
    private long startMessageId;
    private long endMessageId;
    private ConcurrentHashMap<Long, DeliverableAndesMetadata> messagesOfSlot;
    private String storageQueueName;
    private StorageQueue storageQueue;
    private boolean isSlotActive = true;
    private boolean isAnOverlappingSlot = false;
    private List<SlotState> slotStates = new ArrayList<SlotState>();
    private String destinationOfMessagesInSlot;
    private AtomicInteger pendingMessageCount;

    public Slot() {
        this(SlotState.CREATED);
    }

    public Slot(SlotState slotState) {
        this.slotStates.add(slotState);
        this.pendingMessageCount = new AtomicInteger();
        this.messagesOfSlot = new ConcurrentHashMap();
    }

    public Slot(long start, long end, String destinationOfMessagesInSlot) {
        this();
        this.startMessageId = start;
        this.endMessageId = end;
        this.destinationOfMessagesInSlot = destinationOfMessagesInSlot;
    }

    public void setStorageQueueName(String storageQueueName) {
        this.storageQueueName = storageQueueName;
    }

    public void setStorageQueue(StorageQueue storageQueue) {
        this.storageQueue = storageQueue;
    }

    public StorageQueue getStorageQueue() {
        return this.storageQueue;
    }

    public String getStorageQueueName() {
        return this.storageQueueName;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(long messageCount) {
        this.messageCount = messageCount;
    }

    public long getEndMessageId() {
        return this.endMessageId;
    }

    public void setEndMessageId(long endMessageId) {
        this.endMessageId = endMessageId;
    }

    public long getStartMessageId() {
        return this.startMessageId;
    }

    public void setStartMessageId(long startMessageId) {
        this.startMessageId = startMessageId;
    }

    public void setSlotInactive() {
        this.isSlotActive = false;
    }

    public boolean isSlotActive() {
        return this.isSlotActive;
    }

    public boolean isAnOverlappingSlot() {
        return this.isAnOverlappingSlot;
    }

    public void setAnOverlappingSlot(boolean isAnOverlappingSlot) {
        this.isAnOverlappingSlot = isAnOverlappingSlot;
        if (isAnOverlappingSlot) {
            this.addState(SlotState.OVERLAPPED);
        }
    }

    public void addMessageToSlotIfAbsent(DeliverableAndesMetadata metadata) {
        this.messagesOfSlot.putIfAbsent(metadata.getMessageID(), metadata);
    }

    public List<DeliverableAndesMetadata> getAllMessagesOfSlot() {
        return new ArrayList<DeliverableAndesMetadata>(this.messagesOfSlot.values());
    }

    @Deprecated
    public void removeMessageFromSlot(long messageID) {
        this.messagesOfSlot.remove(messageID);
    }

    public void markMessagesOfSlotAsReturned() {
        for (DeliverableAndesMetadata andesMetadata : this.messagesOfSlot.values()) {
            andesMetadata.markAsStale();
            andesMetadata.markAsSlotReturned();
        }
        this.messagesOfSlot.clear();
    }

    public void deleteAllMessagesInSlot() {
        for (DeliverableAndesMetadata messageMetadata : this.messagesOfSlot.values()) {
            long messageId = messageMetadata.getMessageID();
            messageMetadata.markAsSlotRemoved();
            if (messageMetadata.isOKToDispose()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("removing tracking object from memory id " + messageId));
                continue;
            }
            log.error((Object)("Tracking data for message id " + messageId + " removed while in an invalid state. (" + messageMetadata.getStatusHistory() + ")"));
        }
        this.messagesOfSlot.clear();
    }

    public boolean checkIfMessageIsAlreadyAdded(long messageID) {
        boolean messageExists = false;
        if (null != this.messagesOfSlot.get(messageID)) {
            messageExists = true;
        }
        return messageExists;
    }

    public String getDestinationOfMessagesInSlot() {
        return this.destinationOfMessagesInSlot;
    }

    public void setDestinationOfMessagesInSlot(String destinationOfMessagesInSlot) {
        this.destinationOfMessagesInSlot = destinationOfMessagesInSlot;
    }

    public boolean addState(SlotState state) {
        boolean isValidTransition = false;
        if (this.slotStates.isEmpty()) {
            if (SlotState.CREATED.equals((Object)state)) {
                isValidTransition = true;
                this.slotStates.add(state);
            } else {
                log.warn((Object)("Invalid State transition suggested: " + (Object)((Object)state)));
            }
        } else {
            isValidTransition = this.slotStates.get(this.slotStates.size() - 1).isValidNextTransition(state);
            if (isValidTransition) {
                this.slotStates.add(state);
            } else {
                log.warn((Object)("Invalid State transition from " + (Object)((Object)this.slotStates.get(this.slotStates.size() - 1)) + " suggested: " + (Object)((Object)state) + " Slot ID: " + this.getId()));
            }
        }
        return isValidTransition;
    }

    public SlotState getCurrentState() {
        return this.slotStates.get(this.slotStates.size() - 1);
    }

    public String encodeSlotStates() {
        StringBuilder builder = new StringBuilder();
        for (SlotState slotState : this.slotStates) {
            builder.append(slotState.getCode()).append("%");
        }
        String encodedString = builder.toString();
        return encodedString;
    }

    public void decodeAndSetSlotStates(String stateInfo) {
        String[] states = StringUtils.split((String)stateInfo, (String)"%");
        this.slotStates.clear();
        if (states != null) {
            for (String state : states) {
                int code = Integer.parseInt(state);
                this.slotStates.add(SlotState.parseSlotState(code));
            }
        } else {
            log.warn((Object)("Invalid encoded string received. Encoded string: " + stateInfo));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slot slot = (Slot)o;
        return this.endMessageId == slot.endMessageId && this.startMessageId == slot.startMessageId && this.storageQueueName.equals(slot.storageQueueName);
    }

    public int hashCode() {
        int result = (int)(this.startMessageId ^ this.startMessageId >>> 32);
        result = 31 * result + (int)(this.endMessageId ^ this.endMessageId >>> 32);
        result = 31 * result + this.storageQueueName.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder slotInfo = new StringBuilder();
        slotInfo.append(" Id : ").append(this.getId()).append(" States : ").append(this.slotStates).append(" Is overlapping : ").append(this.isAnOverlappingSlot).append(" Destination : ").append(this.destinationOfMessagesInSlot);
        return slotInfo.toString();
    }

    public String getId() {
        return this.storageQueueName + "|" + this.startMessageId + "-" + this.endMessageId;
    }

    @Override
    public int compareTo(Slot other) {
        if (this.getStartMessageId() == other.getStartMessageId() && this.getEndMessageId() == other.getEndMessageId() && this.getStorageQueueName().equals(other.getStorageQueueName())) {
            return 0;
        }
        return this.getStartMessageId() > other.getStartMessageId() ? 1 : -1;
    }

    public void decrementPendingMessageCount() throws AndesException {
        int messageCount = this.pendingMessageCount.decrementAndGet();
        if (messageCount == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Slot has no pending messages. Scheduling to delete slot " + this.toString()));
            }
            this.setSlotInactive();
            SlotDeletionExecutor.getInstance().scheduleToDelete(this);
        }
    }

    public void incrementPendingMessageCount(int amount) {
        this.pendingMessageCount.addAndGet(amount);
    }
}

