/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.MessageFlusher;
import org.wso2.andes.kernel.slot.ConnectionException;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.slot.SlotCoordinator;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.task.Task;

final class MessageDeliveryTask
extends Task {
    private static Log log = LogFactory.getLog(MessageDeliveryTask.class);
    private StorageQueue storageQueue;
    private MessageFlusher messageFlusher;
    private SlotCoordinator slotCoordinator;

    MessageDeliveryTask(StorageQueue storageQueue, SlotCoordinator slotCoordinator, MessageFlusher messageFlusher) {
        this.storageQueue = storageQueue;
        this.slotCoordinator = slotCoordinator;
        this.messageFlusher = messageFlusher;
    }

    @Override
    public Task.TaskHint call() throws Exception {
        Task.TaskHint taskHint = Task.TaskHint.ACTIVE;
        String storageQueueName = this.storageQueue.getName();
        if (this.storageQueue.checkForReadMessageBufferLimit()) {
            Slot currentSlot = this.requestSlot(storageQueueName);
            currentSlot.setStorageQueue(this.storageQueue);
            if (0L == currentSlot.getEndMessageId()) {
                int numberOfMessageSent;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received an empty slot from slot manager");
                }
                if ((numberOfMessageSent = this.sendMessagesToSubscriptions(this.storageQueue)) == 0) {
                    taskHint = Task.TaskHint.IDLE;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received slot for storage queue " + storageQueueName + " is: " + currentSlot.getStartMessageId() + " - " + currentSlot.getEndMessageId() + "Thread Id:" + Thread.currentThread().getId()));
                }
                this.storageQueue.loadMessagesForDelivery(currentSlot);
                this.sendMessagesToSubscriptions(this.storageQueue);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The queue " + storageQueueName + " has no room to buffer messages. Thus flushing the messages to subscriptions"));
            }
            this.sendMessagesToSubscriptions(this.storageQueue);
        }
        return taskHint;
    }

    public int sendMessagesToSubscriptions(StorageQueue queue) throws AndesException {
        return this.messageFlusher.sendMessagesToSubscriptions(queue);
    }

    @Override
    public void onAdd() {
    }

    @Override
    public void onRemove() {
    }

    @Override
    public String getId() {
        return this.storageQueue.getName();
    }

    private Slot requestSlot(String storageQueueName) throws ConnectionException {
        long startTime = System.currentTimeMillis();
        Slot currentSlot = this.slotCoordinator.getSlot(storageQueueName);
        long endTime = System.currentTimeMillis();
        currentSlot.setDestinationOfMessagesInSlot(storageQueueName);
        if (log.isDebugEnabled()) {
            log.debug((Object)(endTime - startTime + " milli seconds to get a slot from slot manager"));
        }
        return currentSlot;
    }
}

