/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.slot;

import java.util.Set;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesException;

public abstract class AbstractSlotManager {
    protected String currentDeletionQueue = "";
    protected long currentDeletionRangeLowerBoundId;
    protected int safetySlotCount = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_SAFE_DELETE_REGION_SLOT_COUNT);

    public abstract long getSafeZoneLowerBoundId(String var1) throws AndesException;

    public abstract void clearAllActiveSlotRelationsToQueue(String var1) throws AndesException;

    public abstract Set<String> getAllQueues() throws AndesException;

    public void setDeletionTaskState(String currentDeletionQueueName, long currentDeletionRangeLowerBoundId) {
        this.currentDeletionQueue = currentDeletionQueueName;
        this.currentDeletionRangeLowerBoundId = currentDeletionRangeLowerBoundId;
    }

    public void clearDeletionTaskState() {
        this.currentDeletionQueue = "";
        this.currentDeletionRangeLowerBoundId = 0L;
    }

    protected boolean isSafeToDeliverSlots(String queueName, Long lastMessageId) {
        boolean isSafeToDeliverSlots = true;
        if (null != lastMessageId && this.currentDeletionQueue.equals(queueName) && this.currentDeletionRangeLowerBoundId <= lastMessageId) {
            isSafeToDeliverSlots = false;
        }
        return isSafeToDeliverSlots;
    }
}

