/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.router;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.mqtt.utils.MQTTUtils;

public class TopicRoutingMatcher {
    private Log log = LogFactory.getLog(TopicRoutingMatcher.class);
    private String constituentsDelimiter;
    private String multiLevelWildCard;
    private String singleLevelWildCard;
    private ProtocolType protocolType;
    private static final String NULL_CONSTITUENT = "%null%";
    private static final String OTHER_CONSTITUENT = "%other%";
    private List<StorageQueue> storageQueueList = new ArrayList<StorageQueue>();
    private Map<Integer, String[]> queueConstituents = new HashMap<Integer, String[]>();
    private List<Map<String, BitSet>> constituentTables = new ArrayList<Map<String, BitSet>>();

    public TopicRoutingMatcher(ProtocolType protocolType) {
        if (ProtocolType.AMQP == protocolType) {
            this.constituentsDelimiter = ".";
            this.multiLevelWildCard = "#".replace(this.constituentsDelimiter, "");
            this.singleLevelWildCard = "*".replace(this.constituentsDelimiter, "");
        } else if (ProtocolType.MQTT == protocolType) {
            this.constituentsDelimiter = "/";
            this.multiLevelWildCard = "#";
            this.singleLevelWildCard = "+";
        } else {
            throw new RuntimeException("Protocol type " + (Object)((Object)protocolType) + " is not recognized.");
        }
        this.protocolType = protocolType;
    }

    public void addStorageQueue(StorageQueue storageQueue) throws AndesException {
        String bindingKey = storageQueue.getMessageRouterBindingKey();
        if (StringUtils.isNotEmpty((String)bindingKey)) {
            if (!this.isStorageQueueAvailable(storageQueue)) {
                int newQueueIndex = this.storageQueueList.size();
                this.storageQueueList.add(newQueueIndex, storageQueue);
                String[] constituents = bindingKey.split(Pattern.quote(this.constituentsDelimiter));
                this.queueConstituents.put(newQueueIndex, constituents);
                for (int constituentIndex = 0; constituentIndex < constituents.length; ++constituentIndex) {
                    String constituent = constituents[constituentIndex];
                    Map<String, BitSet> constituentTable = constituentIndex + 1 > this.constituentTables.size() ? this.addConstituentTable(constituentIndex) : this.constituentTables.get(constituentIndex);
                    if (constituentTable.keySet().contains(constituent)) continue;
                    this.addConstituentRow(constituent, constituentIndex);
                }
                this.addStorageQueueColumn(bindingKey, newQueueIndex);
            } else {
                this.updateStorageQueue(storageQueue);
            }
        } else {
            throw new AndesException("Error adding a new storageQueue. Subscribed bindingKey is empty.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStorageQueue(StorageQueue storageQueue) {
        if (this.isStorageQueueAvailable(storageQueue)) {
            int index = this.storageQueueList.indexOf(storageQueue);
            List<StorageQueue> list = this.storageQueueList;
            synchronized (list) {
                this.storageQueueList.remove(index);
                this.storageQueueList.add(index, storageQueue);
            }
        }
    }

    private Map<String, BitSet> addConstituentTable(int constituentIndex) {
        HashMap<String, BitSet> constituentTable = new HashMap<String, BitSet>();
        BitSet nullBitSet = new BitSet(this.storageQueueList.size());
        BitSet otherBitSet = new BitSet(this.storageQueueList.size());
        for (int queueIndex = 0; queueIndex < this.storageQueueList.size(); ++queueIndex) {
            String[] constituentsOfQueue = this.queueConstituents.get(queueIndex);
            if (constituentsOfQueue.length < constituentIndex + 1) {
                nullBitSet.set(queueIndex);
                if (!this.multiLevelWildCard.equals(constituentsOfQueue[constituentsOfQueue.length - 1])) continue;
                otherBitSet.set(queueIndex);
                continue;
            }
            String queueConstituent = constituentsOfQueue[constituentIndex];
            if (!this.multiLevelWildCard.equals(queueConstituent) && !this.singleLevelWildCard.equals(queueConstituent)) continue;
            otherBitSet.set(queueIndex);
        }
        constituentTable.put(NULL_CONSTITUENT, nullBitSet);
        constituentTable.put(OTHER_CONSTITUENT, otherBitSet);
        this.constituentTables.add(constituentIndex, constituentTable);
        return constituentTable;
    }

    private void addStorageQueueColumn(String bindingKey, int queueIndex) throws AndesException {
        String[] bindingKeyConstituents = this.queueConstituents.get(queueIndex);
        String matchDestinationForOther = OTHER_CONSTITUENT + this.constituentsDelimiter + OTHER_CONSTITUENT;
        String matchDestinationForNull = NULL_CONSTITUENT + this.constituentsDelimiter + NULL_CONSTITUENT + this.constituentsDelimiter + NULL_CONSTITUENT;
        for (int constituentIndex = 0; constituentIndex < bindingKeyConstituents.length; ++constituentIndex) {
            String currentConstituent = bindingKeyConstituents[constituentIndex];
            Map<String, BitSet> constituentTable = this.constituentTables.get(constituentIndex);
            for (Map.Entry<String, BitSet> constituentRow : constituentTable.entrySet()) {
                String constituentOfCurrentRow = constituentRow.getKey();
                BitSet bitSet = constituentRow.getValue();
                if (constituentOfCurrentRow.equals(currentConstituent)) {
                    bitSet.set(queueIndex);
                    continue;
                }
                if (NULL_CONSTITUENT.equals(constituentOfCurrentRow)) {
                    String wildcardDestination = NULL_CONSTITUENT + this.constituentsDelimiter + currentConstituent;
                    bitSet.set(queueIndex, this.isMatchForProtocolType(wildcardDestination, matchDestinationForNull));
                    continue;
                }
                if (OTHER_CONSTITUENT.equals(constituentOfCurrentRow)) {
                    String wildCardDestination = OTHER_CONSTITUENT + this.constituentsDelimiter + currentConstituent;
                    bitSet.set(queueIndex, this.isMatchForProtocolType(wildCardDestination, matchDestinationForOther));
                    continue;
                }
                if (this.singleLevelWildCard.equals(currentConstituent) || this.multiLevelWildCard.equals(currentConstituent)) {
                    bitSet.set(queueIndex);
                    continue;
                }
                bitSet.set(queueIndex, false);
            }
        }
        int noOfMaxConstituents = this.constituentTables.size();
        if (noOfMaxConstituents > bindingKeyConstituents.length) {
            boolean matchingOthers = true;
            if (!this.multiLevelWildCard.equals(bindingKeyConstituents[bindingKeyConstituents.length - 1])) {
                String otherConstituentComparer = bindingKey + this.constituentsDelimiter + OTHER_CONSTITUENT;
                matchingOthers = this.isMatchForProtocolType(bindingKey, otherConstituentComparer);
            }
            for (int constituentIndex = bindingKeyConstituents.length; constituentIndex < noOfMaxConstituents; ++constituentIndex) {
                Map<String, BitSet> constituentTable = this.constituentTables.get(constituentIndex);
                for (Map.Entry<String, BitSet> constituentRow : constituentTable.entrySet()) {
                    String constituentOfCurrentRow = constituentRow.getKey();
                    BitSet bitSet = constituentRow.getValue();
                    if (NULL_CONSTITUENT.equals(constituentOfCurrentRow)) {
                        bitSet.set(queueIndex);
                        continue;
                    }
                    bitSet.set(queueIndex, matchingOthers);
                }
            }
        }
    }

    private void addConstituentRow(String constituent, int constituentIndex) {
        Map<String, BitSet> constituentTable = this.constituentTables.get(constituentIndex);
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.queueConstituents.size(); ++i) {
            String[] constituentsOfQueue = this.queueConstituents.get(i);
            if (constituentIndex < constituentsOfQueue.length) {
                String queueConstituent = constituentsOfQueue[constituentIndex];
                if (queueConstituent.equals(constituent) || this.multiLevelWildCard.equals(queueConstituent) || this.singleLevelWildCard.equals(queueConstituent)) {
                    bitSet.set(i);
                    continue;
                }
                bitSet.set(i, false);
                continue;
            }
            if (this.multiLevelWildCard.equals(constituentsOfQueue[constituentsOfQueue.length - 1])) {
                bitSet.set(i);
                continue;
            }
            bitSet.set(i, false);
        }
        constituentTable.put(constituent, bitSet);
    }

    private boolean isMatchForProtocolType(String wildCardDestination, String nonWildCardDestination) throws AndesException {
        boolean matching = false;
        if (ProtocolType.AMQP == this.protocolType) {
            matching = AMQPUtils.isTargetQueueBoundByMatchingToRoutingKey(wildCardDestination, nonWildCardDestination);
        } else if (ProtocolType.MQTT == this.protocolType) {
            matching = MQTTUtils.isTargetQueueBoundByMatchingToRoutingKey(wildCardDestination, nonWildCardDestination);
        } else {
            throw new AndesException("Protocol type " + (Object)((Object)this.protocolType) + " is not recognized.");
        }
        return matching;
    }

    private void addEmptyConstituentTable() {
        int noOfqueues = this.storageQueueList.size();
        HashMap<String, BitSet> constituentTable = new HashMap<String, BitSet>();
        BitSet nullBitSet = new BitSet(noOfqueues);
        BitSet otherBitSet = new BitSet(noOfqueues);
        if (noOfqueues > 0) {
            nullBitSet.flip(0, noOfqueues - 1);
            for (int queueIndex = 0; queueIndex < noOfqueues; ++queueIndex) {
                String[] allConstituent = this.queueConstituents.get(queueIndex);
                String lastConstituent = allConstituent[allConstituent.length - 1];
                if (this.multiLevelWildCard.equals(lastConstituent)) {
                    otherBitSet.set(queueIndex);
                    continue;
                }
                otherBitSet.set(queueIndex, false);
            }
        }
        constituentTable.put(NULL_CONSTITUENT, nullBitSet);
        constituentTable.put(OTHER_CONSTITUENT, otherBitSet);
        this.constituentTables.add(constituentTable);
    }

    public void removeStorageQueue(StorageQueue storageQueue) {
        int queueIndex = this.storageQueueList.indexOf(storageQueue);
        if (queueIndex > -1) {
            for (Map<String, BitSet> constituentTable : this.constituentTables) {
                for (Map.Entry<String, BitSet> constituentRow : constituentTable.entrySet()) {
                    String constituent = constituentRow.getKey();
                    BitSet bitSet = constituentRow.getValue();
                    BitSet newBitSet = new BitSet();
                    int bitIndex = 0;
                    for (int i = 0; i < bitSet.size(); ++i) {
                        if (bitIndex == queueIndex) {
                            ++bitIndex;
                        }
                        newBitSet.set(i, bitSet.get(bitIndex));
                        ++bitIndex;
                    }
                    constituentTable.put(constituent, newBitSet);
                }
            }
            this.storageQueueList.remove(queueIndex);
        } else {
            this.log.warn((Object)("Storage queue for with name : " + storageQueue.getName() + " is not found to remove"));
        }
    }

    public boolean isStorageQueueAvailable(StorageQueue storageQueue) {
        return this.storageQueueList.contains(storageQueue);
    }

    public Set<StorageQueue> getMatchingStorageQueues(String routingKey) {
        HashSet<StorageQueue> matchingQueues = new HashSet<StorageQueue>();
        if (StringUtils.isNotEmpty((String)routingKey)) {
            int constituentIndex;
            int noOfCurrentMaxConstituents;
            String[] constituents = routingKey.split(Pattern.quote(this.constituentsDelimiter), -1);
            if (constituents.length > (noOfCurrentMaxConstituents = this.constituentTables.size())) {
                for (int i = noOfCurrentMaxConstituents; i < constituents.length; ++i) {
                    this.addEmptyConstituentTable();
                }
            }
            BitSet andBitSet = new BitSet(this.storageQueueList.size());
            andBitSet.flip(0, this.storageQueueList.size());
            for (constituentIndex = 0; constituentIndex < constituents.length; ++constituentIndex) {
                String constituent = constituents[constituentIndex];
                Map<String, BitSet> constituentTable = this.constituentTables.get(constituentIndex);
                BitSet bitSetForAnd = constituentTable.get(constituent);
                if (null == bitSetForAnd) {
                    bitSetForAnd = constituentTable.get(OTHER_CONSTITUENT);
                }
                andBitSet.and(bitSetForAnd);
            }
            for (constituentIndex = constituents.length; constituentIndex < this.constituentTables.size(); ++constituentIndex) {
                Map<String, BitSet> constituentTable = this.constituentTables.get(constituentIndex);
                andBitSet.and(constituentTable.get(NULL_CONSTITUENT));
            }
            int nextSetBitIndex = andBitSet.nextSetBit(0);
            while (nextSetBitIndex > -1) {
                matchingQueues.add(this.storageQueueList.get(nextSetBitIndex));
                nextSetBitIndex = andBitSet.nextSetBit(nextSetBitIndex + 1);
            }
        } else {
            this.log.warn((Object)"Cannot retrieve storage queues via bitmap handler since routingKey to match is empty");
        }
        return matchingQueues;
    }

    public List<StorageQueue> getAllStorageQueues() {
        return this.storageQueueList;
    }

    public Set<String> getAllBindingKeys() {
        HashSet<String> topics = new HashSet<String>();
        for (Map.Entry<Integer, String[]> subcriberConstituent : this.queueConstituents.entrySet()) {
            StringBuilder topic = new StringBuilder();
            String[] constituents = subcriberConstituent.getValue();
            for (int i = 0; i < constituents.length; ++i) {
                String constituent = constituents[i];
                if (this.multiLevelWildCard.equals(constituent) || this.singleLevelWildCard.equals(constituent)) {
                    topic.append("ANY");
                } else {
                    topic.append(constituent);
                }
                if (constituents.length - 1 <= i) continue;
                topic.append(this.constituentsDelimiter);
            }
            topics.add(topic.toString());
        }
        return topics;
    }
}

