/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.router;

import java.util.List;
import java.util.Set;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.router.TopicRoutingMatcher;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class TopicMessageRouter
extends AndesMessageRouter {
    private TopicRoutingMatcher topicMatcher = new TopicRoutingMatcher(ProtocolType.AMQP);

    public TopicMessageRouter(String name, String type, boolean autoDelete) {
        super(name, type, autoDelete);
    }

    public TopicMessageRouter(String encodedRouterInfo) {
        super(encodedRouterInfo);
    }

    @Override
    public void removeMapping(String bindingKey, StorageQueue queue) throws AndesException {
        if (queue.getBoundSubscriptions().isEmpty()) {
            List boundQueues = (List)this.routingMap.get(bindingKey);
            if (boundQueues != null && !boundQueues.isEmpty()) {
                boundQueues.remove(queue);
            }
            this.onUnbindingQueue(queue);
            if (this.autoDelete) {
                AndesContext.getInstance().getMessageRouterRegistry().removeMessageRouter(this.name);
            }
        }
    }

    @Override
    public Set<StorageQueue> getMatchingStorageQueues(AndesMessage incomingMessage) {
        String messageRoutingKey = incomingMessage.getMetadata().getDestination();
        return this.topicMatcher.getMatchingStorageQueues(messageRoutingKey);
    }

    @Override
    public void onBindingQueue(StorageQueue queue) throws AndesException {
        this.topicMatcher.addStorageQueue(queue);
    }

    @Override
    public void onUnbindingQueue(StorageQueue queue) {
        this.topicMatcher.removeStorageQueue(queue);
    }
}

