/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.router;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class QueueMessageRouter
extends AndesMessageRouter {
    public QueueMessageRouter(String name, String type, boolean autoDelete) {
        super(name, type, autoDelete);
    }

    public QueueMessageRouter(String encodedRouterInfo) {
        super(encodedRouterInfo);
    }

    @Override
    public void removeMapping(String bindingKey, StorageQueue queue) throws AndesException {
        if (queue.getBoundSubscriptions().isEmpty()) {
            List boundQueues = (List)this.routingMap.get(bindingKey);
            if (boundQueues != null && !boundQueues.isEmpty()) {
                boundQueues.remove(queue);
            }
            this.onUnbindingQueue(queue);
            if (this.autoDelete) {
                AndesContext.getInstance().getMessageRouterRegistry().removeMessageRouter(this.name);
            }
        } else {
            throw new AndesException("Cannot unbind a queue from message router which has active subscriptions");
        }
    }

    @Override
    public Set<StorageQueue> getMatchingStorageQueues(AndesMessage incomingMessage) {
        String messageRoutingKey = incomingMessage.getMetadata().getDestination();
        return new HashSet<StorageQueue>((Collection)this.routingMap.get(messageRoutingKey));
    }

    @Override
    public void onBindingQueue(StorageQueue queue) throws AndesException {
    }

    @Override
    public void onUnbindingQueue(StorageQueue queue) {
    }
}

