/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.router;

import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.router.DiscardMessageRouter;
import org.wso2.andes.kernel.router.MQTTMessageRouter;
import org.wso2.andes.kernel.router.QueueMessageRouter;
import org.wso2.andes.kernel.router.TopicMessageRouter;

public class MessageRouterFactory {
    public AndesMessageRouter createMessageRouter(String messageRouterName, String type, boolean autoDelete) throws AndesException {
        AndesMessageRouter messageRouter = messageRouterName.equals(AMQPUtils.DEFAULT_EXCHANGE_NAME) ? new QueueMessageRouter(messageRouterName, type, autoDelete) : (messageRouterName.equals(AMQPUtils.DIRECT_EXCHANGE_NAME) ? new QueueMessageRouter(messageRouterName, type, autoDelete) : (messageRouterName.equals(AMQPUtils.TOPIC_EXCHANGE_NAME) ? new TopicMessageRouter(messageRouterName, type, autoDelete) : (messageRouterName.equals("mqtt.topic") ? new MQTTMessageRouter(messageRouterName, type, autoDelete) : (messageRouterName.equals(AMQPUtils.DLC_EXCHANGE_NAME) ? new DiscardMessageRouter(messageRouterName, type, autoDelete) : new QueueMessageRouter(messageRouterName, type, autoDelete)))));
        return messageRouter;
    }

    public AndesMessageRouter createMessageRouter(String messageRouterInfo) throws AndesException {
        QueueMessageRouter mockRouter = new QueueMessageRouter(messageRouterInfo);
        String messageRouterName = mockRouter.getName();
        AndesMessageRouter messageRouter = null;
        messageRouter = messageRouterName.equals(AMQPUtils.DEFAULT_EXCHANGE_NAME) ? new QueueMessageRouter(messageRouterInfo) : (messageRouterName.equals(AMQPUtils.DIRECT_EXCHANGE_NAME) ? new QueueMessageRouter(messageRouterInfo) : (messageRouterName.equals(AMQPUtils.TOPIC_EXCHANGE_NAME) ? new TopicMessageRouter(messageRouterInfo) : (messageRouterName.equals("mqtt.topic") ? new MQTTMessageRouter(messageRouterInfo) : (messageRouterName.equals(AMQPUtils.DLC_EXCHANGE_NAME) ? new DiscardMessageRouter(messageRouterInfo) : new QueueMessageRouter(messageRouterInfo)))));
        return messageRouter;
    }
}

