/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.router;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.router.TopicRoutingMatcher;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class MQTTMessageRouter
extends AndesMessageRouter {
    private TopicRoutingMatcher topicMatcher = new TopicRoutingMatcher(ProtocolType.MQTT);

    public MQTTMessageRouter(String name, String type, boolean autoDelete) {
        super(name, type, autoDelete);
    }

    public MQTTMessageRouter(String encodedRouterInfo) {
        super(encodedRouterInfo);
    }

    @Override
    public void removeMapping(String bindingKey, StorageQueue queue) throws AndesException {
        if (queue.getBoundSubscriptions().isEmpty()) {
            List boundQueues = (List)this.routingMap.get(bindingKey);
            if (boundQueues != null && !boundQueues.isEmpty()) {
                boundQueues.remove(queue);
            }
            this.onUnbindingQueue(queue);
            if (this.autoDelete) {
                AndesContext.getInstance().getMessageRouterRegistry().removeMessageRouter(this.name);
            }
        }
    }

    @Override
    public Set<StorageQueue> getMatchingStorageQueues(AndesMessage incomingMessage) {
        String messageRoutingKey = incomingMessage.getMetadata().getDestination();
        int qosLevel = incomingMessage.getMetadata().getQosLevel();
        Set<StorageQueue> matchingQueues = this.topicMatcher.getMatchingStorageQueues(messageRoutingKey);
        if (0 == qosLevel) {
            Iterator<StorageQueue> queueIterator = matchingQueues.iterator();
            while (queueIterator.hasNext()) {
                StorageQueue matchingQueue = queueIterator.next();
                if (!matchingQueue.isDurable() || !matchingQueue.getBoundSubscriptions().isEmpty()) continue;
                queueIterator.remove();
            }
        }
        return matchingQueues;
    }

    @Override
    public void onBindingQueue(StorageQueue queue) throws AndesException {
        this.topicMatcher.addStorageQueue(queue);
    }

    @Override
    public void onUnbindingQueue(StorageQueue queue) {
        this.topicMatcher.removeStorageQueue(queue);
    }
}

