/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.subscription.StorageQueue;

public abstract class AndesMessageRouter {
    protected Map<String, List<StorageQueue>> routingMap;
    protected String name;
    protected String type;
    protected boolean autoDelete;

    public AndesMessageRouter(String name, String type, boolean autoDelete) {
        this.name = name;
        this.type = type;
        this.autoDelete = autoDelete;
        this.routingMap = new HashMap<String, List<StorageQueue>>();
    }

    public AndesMessageRouter(String messageRouterAsStr) {
        String[] propertyToken;
        block10: for (String pt : propertyToken = messageRouterAsStr.split(",")) {
            String[] tokens = pt.split("=");
            switch (tokens[0]) {
                case "messageRouterName": {
                    this.name = tokens[1];
                    continue block10;
                }
                case "type": {
                    this.type = tokens[1];
                    continue block10;
                }
                case "autoDelete": {
                    this.autoDelete = Boolean.parseBoolean(tokens[1]);
                }
            }
        }
        this.routingMap = new HashMap<String, List<StorageQueue>>();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void addMapping(String bindingKey, StorageQueue queue) throws AndesException {
        List<StorageQueue> boundQueues = this.routingMap.get(bindingKey);
        if (null == boundQueues) {
            ArrayList<StorageQueue> boundedQueues = new ArrayList<StorageQueue>(1);
            boundedQueues.add(queue);
            this.routingMap.put(bindingKey, boundedQueues);
        } else {
            boundQueues.add(queue);
        }
        this.onBindingQueue(queue);
    }

    public void removeMapping(String bindingKey, StorageQueue queue) throws AndesException {
        if (queue.getBoundSubscriptions().isEmpty()) {
            List<StorageQueue> boundQueues = this.routingMap.get(bindingKey);
            if (boundQueues != null && !boundQueues.isEmpty()) {
                boundQueues.remove(queue);
            }
            this.onUnbindingQueue(queue);
            if (this.autoDelete) {
                AndesContext.getInstance().getMessageRouterRegistry().removeMessageRouter(this.name);
            }
        } else {
            throw new AndesException("Cannot unbind a queue from message router which has active subscriptions");
        }
    }

    public List<String> getAllBindingKeys() {
        return new ArrayList<String>(this.routingMap.keySet());
    }

    public List<StorageQueue> getAllBoundQueues() {
        ArrayList<StorageQueue> queues = new ArrayList<StorageQueue>();
        for (List<StorageQueue> storageQueues : this.routingMap.values()) {
            for (StorageQueue storageQueue : storageQueues) {
                queues.add(storageQueue);
            }
        }
        return queues;
    }

    public List<String> getNamesOfAllQueuesBound() {
        ArrayList<String> queueNames = new ArrayList<String>();
        List<StorageQueue> queuesList = this.getAllBoundQueues();
        for (StorageQueue queue : queuesList) {
            queueNames.add(queue.getName());
        }
        return queueNames;
    }

    public abstract Set<StorageQueue> getMatchingStorageQueues(AndesMessage var1);

    public abstract void onBindingQueue(StorageQueue var1) throws AndesException;

    public abstract void onUnbindingQueue(StorageQueue var1);

    public String encodeAsString() {
        return "messageRouterName=" + this.name + ",type=" + this.type + ",autoDelete=" + this.autoDelete;
    }

    public String toString() {
        return this.encodeAsString();
    }

    public boolean equals(Object o) {
        if (o instanceof AndesMessageRouter) {
            AndesMessageRouter c = (AndesMessageRouter)o;
            if (this.name.equals(c.name) && this.type.equals(c.type) && this.autoDelete == c.autoDelete) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.name).append((Object)this.type).append(this.autoDelete).toHashCode();
    }
}

