/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.registry;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.server.information.management.DurableTopicSubscriptionInformationMBean;

public class StorageQueueRegistry {
    private Map<String, StorageQueue> storageQueueMap = new HashMap<String, StorageQueue>();
    private static final String ANDES_DOMAIN = "org.wso2.andes";
    private static final String TOPIC_INFO_MBEAN_TYPE = "DurableTopicSubscriptionInformation";
    private static Log log = LogFactory.getLog(StorageQueueRegistry.class);

    public StorageQueue registerStorageQueue(String queueName, boolean isDurable, boolean isShared, String queueOwner, boolean isExclusive) {
        StorageQueue storageQueue = this.storageQueueMap.get(queueName);
        if (null == storageQueue) {
            storageQueue = new StorageQueue(queueName, isDurable, isShared, queueOwner, isExclusive);
            this.storageQueueMap.put(queueName, storageQueue);
        }
        if (storageQueue.getName().startsWith("carbon:")) {
            try {
                DurableTopicSubscriptionInformationMBean mBean = new DurableTopicSubscriptionInformationMBean(storageQueue.getName());
                mBean.register();
            }
            catch (Exception e) {
                log.error((Object)"Unable to register subscription mbean!", (Throwable)e);
            }
        }
        return storageQueue;
    }

    public StorageQueue removeStorageQueue(String queueName) throws AndesException {
        StorageQueue storageQueue = this.storageQueueMap.remove(queueName);
        storageQueue.unbindQueueFromMessageRouter();
        if (queueName.startsWith("carbon:") && this.isMbeanRegistered(queueName)) {
            Hashtable<String, String> tab = this.getMbeanObjectnameProp(queueName);
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(ANDES_DOMAIN, tab));
            }
            catch (Exception e) {
                log.error((Object)"Unable to unregister subscription mbean!", (Throwable)e);
            }
        }
        return storageQueue;
    }

    public StorageQueue getStorageQueue(String queueName) {
        return this.storageQueueMap.get(queueName);
    }

    public List<StorageQueue> getAllStorageQueues() {
        return new ArrayList<StorageQueue>(this.storageQueueMap.values());
    }

    public List<String> getAllStorageQueueNames() {
        return new ArrayList<String>(this.storageQueueMap.keySet());
    }

    public void dumpAllSlotInformationToFile(File fileToWrite) throws AndesException {
        for (StorageQueue storageQueue : this.storageQueueMap.values()) {
            storageQueue.dumpAllSlotInformationToFile(fileToWrite);
        }
    }

    private boolean isMbeanRegistered(String storageQueue) {
        Hashtable<String, String> tab = this.getMbeanObjectnameProp(storageQueue);
        boolean isRegistered = false;
        try {
            isRegistered = ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(ANDES_DOMAIN, tab));
        }
        catch (Exception e) {
            log.error((Object)"Unable to check if an mbean is registered!", (Throwable)e);
        }
        return isRegistered;
    }

    private Hashtable<String, String> getMbeanObjectnameProp(String storageQueue) {
        int index = storageQueue.indexOf(58);
        Hashtable<String, String> tab = new Hashtable<String, String>();
        tab.put("type", TOPIC_INFO_MBEAN_TYPE);
        tab.put("name", ObjectName.quote(storageQueue.substring(index + 1)));
        return tab;
    }
}

