/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.dtx;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.wso2.andes.dtx.XidImpl;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.DtxStore;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.dtx.AndesPreparedMessageMetadata;
import org.wso2.andes.kernel.dtx.DtxBranch;
import org.wso2.andes.kernel.dtx.UnknownDtxBranchException;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.txn.IncorrectDtxStateException;
import org.wso2.andes.server.txn.RollbackOnlyDtxException;
import org.wso2.andes.server.txn.TimeoutDtxException;
import org.wso2.andes.tools.utils.MessageTracer;

public class DtxRegistry {
    private final Map<Xid, DtxBranch> branches;
    private final DtxStore dtxStore;
    private ScheduledExecutorService timeoutTaskExecutor;
    private MessagingEngine messagingEngine;
    private String nodeId;
    private InboundEventManager eventManager;
    private Set<XidImpl> storeOnlyXidSet;

    public DtxRegistry(DtxStore dtxStore, MessagingEngine messagingEngine, InboundEventManager eventManager) throws AndesException {
        this.dtxStore = dtxStore;
        this.branches = new HashMap<Xid, DtxBranch>();
        this.messagingEngine = messagingEngine;
        this.eventManager = eventManager;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("DtxTimeoutExecutor-%d").build();
        this.nodeId = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
        this.storeOnlyXidSet = dtxStore.getStoredXidSet(this.nodeId);
        this.timeoutTaskExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
    }

    synchronized DtxBranch getBranch(Xid xid) throws AndesException {
        DtxBranch dtxBranch = this.branches.get(xid);
        if (dtxBranch == null && this.storeOnlyXidSet.contains(new XidImpl(xid)) && !(dtxBranch = new DtxBranch(DtxBranch.RECOVERY_SESSION_ID, xid, this, this.eventManager)).recoverFromStore(this.nodeId)) {
            dtxBranch = null;
        }
        return dtxBranch;
    }

    synchronized boolean registerBranch(DtxBranch branch) {
        if (!this.branches.containsKey(branch.getXid())) {
            this.branches.put(branch.getXid(), branch);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void prepare(Xid xid, DisruptorEventCallback callback) throws UnknownDtxBranchException, IncorrectDtxStateException, TimeoutDtxException, AndesException, RollbackOnlyDtxException {
        DtxBranch branch;
        DtxRegistry dtxRegistry = this;
        synchronized (dtxRegistry) {
            branch = this.getBranch(xid);
            if (branch == null) throw new UnknownDtxBranchException(xid);
            if (branch.hasAssociatedActiveSessions()) throw new IncorrectDtxStateException("Branch still has associated sessions", xid);
            branch.clearAssociations();
            if (branch.expired()) {
                this.unregisterBranch(branch);
                throw new TimeoutDtxException(xid);
            }
            if (branch.getState() == DtxBranch.State.ROLLBACK_ONLY) {
                throw new RollbackOnlyDtxException(xid);
            }
            if (branch.getState() != DtxBranch.State.ACTIVE) {
                throw new IncorrectDtxStateException("Cannot prepare a transaction in state " + (Object)((Object)branch.getState()), xid);
            }
            branch.setState(DtxBranch.State.PRE_PREPARE);
        }
        PrepareCallback prepareCallback = new PrepareCallback(callback, branch);
        branch.prepare(prepareCallback);
    }

    private synchronized boolean unregisterBranch(DtxBranch branch) {
        return this.branches.remove(branch.getXid()) != null;
    }

    long storeRecords(DtxBranch branch) throws AndesException {
        List<AndesPreparedMessageMetadata> dequeueRecords = this.acknowledgeAndRetrieveDequeueRecords(branch);
        branch.setMessagesToRestore(dequeueRecords);
        long internalXid = this.dtxStore.storeDtxRecords(branch.getXid(), branch.getEnqueueList(), dequeueRecords);
        if (MessageTracer.isEnabled()) {
            for (AndesMessage message : branch.getEnqueueList()) {
                MessageTracer.trace(message.getMetadata(), branch.getXid(), branch.getState(), "stored prepared incoming messages to dtx store");
            }
            for (AndesPreparedMessageMetadata preparedMessageMetadata : dequeueRecords) {
                MessageTracer.trace(preparedMessageMetadata, branch.getXid(), branch.getState(), "moved acknowledged messages to dtx store from message store");
            }
        }
        return internalXid;
    }

    List<AndesPreparedMessageMetadata> acknowledgeAndRetrieveDequeueRecords(DtxBranch branch) throws AndesException {
        return this.messagingEngine.acknowledgeAndRetrieveDequeueRecords(branch.getDequeueList());
    }

    public synchronized void rollback(Xid xid, DisruptorEventCallback callback) throws TimeoutDtxException, IncorrectDtxStateException, UnknownDtxBranchException, AndesException {
        DtxBranch branch = this.getBranch(xid);
        if (branch != null) {
            if (branch.expired()) {
                this.unregisterBranch(branch);
                throw new TimeoutDtxException(xid);
            }
            if (branch.hasAssociatedActiveSessions()) {
                throw new IncorrectDtxStateException("Branch is still associates with a session", xid);
            }
        } else {
            throw new UnknownDtxBranchException(xid);
        }
        branch.clearAssociations();
        branch.rollback(new RollbackCallback(callback, branch));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void commit(Xid xid, boolean onePhase, DisruptorEventCallback callback, AndesChannel channel) throws UnknownDtxBranchException, IncorrectDtxStateException, AndesException, TimeoutDtxException, RollbackOnlyDtxException {
        DtxBranch dtxBranch = this.getBranch(xid);
        if (null == dtxBranch) throw new UnknownDtxBranchException(xid);
        if (dtxBranch.hasAssociatedActiveSessions()) throw new IncorrectDtxStateException("Branch still has associated sessions", xid);
        dtxBranch.clearAssociations();
        if (dtxBranch.expired()) {
            this.unregisterBranch(dtxBranch);
            throw new TimeoutDtxException(xid);
        }
        if (dtxBranch.getState() == DtxBranch.State.ROLLBACK_ONLY) {
            throw new RollbackOnlyDtxException(xid);
        }
        if (onePhase && dtxBranch.getState() == DtxBranch.State.PREPARED) {
            throw new IncorrectDtxStateException("Cannot call one-phase commit on a prepared branch", xid);
        }
        if (!onePhase && dtxBranch.getState() != DtxBranch.State.PREPARED) {
            throw new IncorrectDtxStateException("Cannot call two-phase commit on a non-prepared branch", xid);
        }
        dtxBranch.setState(DtxBranch.State.FORGOTTEN);
        CommitCallback wrappedCallback = new CommitCallback(callback, dtxBranch);
        dtxBranch.commit(wrappedCallback, channel, onePhase);
    }

    public DtxStore getStore() {
        return this.dtxStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws UnknownDtxBranchException, IncorrectDtxStateException, AndesException {
        DtxBranch branch = this.getBranch(xid);
        if (branch != null) {
            DtxBranch dtxBranch = branch;
            synchronized (dtxBranch) {
                if (!branch.hasAssociatedActiveSessions()) {
                    if (branch.getState() != DtxBranch.State.HEUR_COM && branch.getState() != DtxBranch.State.HEUR_RB) {
                        throw new IncorrectDtxStateException("Branch should not be forgotten - it is not heuristically complete", xid);
                    }
                } else {
                    throw new IncorrectDtxStateException("Branch was still associated with a session", xid);
                }
                branch.setState(DtxBranch.State.FORGOTTEN);
                this.unregisterBranch(branch);
            }
        } else {
            throw new UnknownDtxBranchException(xid);
        }
    }

    public synchronized void close(UUID sessionId) {
        Iterator<Map.Entry<Xid, DtxBranch>> iterator = this.branches.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Xid, DtxBranch> entry = iterator.next();
            DtxBranch branch = entry.getValue();
            if (branch.getCreatedSessionId() != sessionId || branch.getState() != DtxBranch.State.ACTIVE && branch.getState() != DtxBranch.State.SUSPENDED) continue;
            if (branch.isAssociated(sessionId)) {
                branch.disassociateSession(sessionId);
            }
            if (branch.hasAssociatedSessions()) continue;
            branch.setState(DtxBranch.State.FORGOTTEN);
            iterator.remove();
        }
    }

    public void setTimeout(Xid xid, long timeout) throws UnknownDtxBranchException, AndesException {
        DtxBranch branch = this.getBranch(xid);
        if (branch == null) {
            throw new UnknownDtxBranchException(xid);
        }
        branch.setTimeout(timeout);
    }

    ScheduledFuture<?> scheduleTask(long delay, Runnable runnable) {
        return this.timeoutTaskExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.timeoutTaskExecutor.shutdown();
    }

    public ArrayList<Xid> getPreparedTransactions() {
        ArrayList<Xid> preparedBranches = new ArrayList<Xid>();
        for (DtxBranch dtxBranch : this.branches.values()) {
            if (dtxBranch.getState() != DtxBranch.State.PREPARED) continue;
            preparedBranches.add(dtxBranch.getXid());
        }
        return preparedBranches;
    }

    private class PrepareCallback
    implements DisruptorEventCallback {
        private final DisruptorEventCallback callback;
        private final DtxBranch branch;

        private PrepareCallback(DisruptorEventCallback callback, DtxBranch branch) {
            this.callback = callback;
            this.branch = branch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            DtxRegistry dtxRegistry = DtxRegistry.this;
            synchronized (dtxRegistry) {
                this.branch.setState(DtxBranch.State.PREPARED);
            }
            this.callback.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onException(Exception exception) {
            DtxRegistry dtxRegistry = DtxRegistry.this;
            synchronized (dtxRegistry) {
                this.branch.setState(DtxBranch.State.ROLLBACK_ONLY);
            }
            this.callback.onException(exception);
        }
    }

    private class RollbackCallback
    implements DisruptorEventCallback {
        private final DisruptorEventCallback callback;
        private final DtxBranch dtxBranch;

        public RollbackCallback(DisruptorEventCallback callback, DtxBranch dtxBranch) {
            this.callback = callback;
            this.dtxBranch = dtxBranch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            DtxRegistry dtxRegistry = DtxRegistry.this;
            synchronized (dtxRegistry) {
                this.dtxBranch.setState(DtxBranch.State.FORGOTTEN);
                DtxRegistry.this.unregisterBranch(this.dtxBranch);
                DtxRegistry.this.storeOnlyXidSet.remove(new XidImpl(this.dtxBranch.getXid()));
            }
            this.callback.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onException(Exception exception) {
            DtxRegistry dtxRegistry = DtxRegistry.this;
            synchronized (dtxRegistry) {
                this.dtxBranch.setState(DtxBranch.State.PREPARED);
            }
            this.callback.onException(exception);
        }
    }

    private class CommitCallback
    implements DisruptorEventCallback {
        private final DisruptorEventCallback callback;
        private final DtxBranch dtxBranch;

        private CommitCallback(DisruptorEventCallback callback, DtxBranch dtxBranch) {
            this.callback = callback;
            this.dtxBranch = dtxBranch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            DtxRegistry dtxRegistry = DtxRegistry.this;
            synchronized (dtxRegistry) {
                DtxRegistry.this.unregisterBranch(this.dtxBranch);
                DtxRegistry.this.storeOnlyXidSet.remove(new XidImpl(this.dtxBranch.getXid()));
            }
            this.callback.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onException(Exception exception) {
            DtxRegistry dtxRegistry = DtxRegistry.this;
            synchronized (dtxRegistry) {
                this.dtxBranch.setState(DtxBranch.State.PREPARED);
            }
            this.callback.onException(exception);
        }
    }
}

