/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.dtx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventContainer;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.dtx.AndesPreparedMessageMetadata;
import org.wso2.andes.kernel.dtx.DtxRegistry;
import org.wso2.andes.kernel.slot.SlotMessageCounter;
import org.wso2.andes.tools.utils.MessageTracer;

public class DtxBranch {
    private static final Logger LOGGER = Logger.getLogger(DtxBranch.class);
    public static final int NULL_XID = -1;
    public static final UUID RECOVERY_SESSION_ID = UUID.randomUUID();
    private final Xid xid;
    private final DtxRegistry dtxRegistry;
    private Map<UUID, State> associatedSessions = new HashMap<UUID, State>();
    private InboundEventManager eventManager;
    private DisruptorEventCallback callback;
    private long timeout;
    private ScheduledFuture<?> timeoutFuture;
    private long _expiration;
    private ArrayList<AndesMessage> enqueueList = new ArrayList();
    private List<AndesAckData> dequeueList = new ArrayList<AndesAckData>();
    private List<AndesPreparedMessageMetadata> preparedDequeueMessages;
    private State state = State.ACTIVE;
    private long internalXid = -1L;
    private UUID createdSessionId;
    private Runnable updateSlotCommand;

    DtxBranch(UUID sessionId, Xid xid, DtxRegistry dtxRegistry, InboundEventManager eventManager) {
        this.xid = xid;
        this.dtxRegistry = dtxRegistry;
        this.eventManager = eventManager;
        this.createdSessionId = sessionId;
    }

    public ArrayList<AndesMessage> getEnqueueList() {
        return this.enqueueList;
    }

    public void setMessagesToRestore(List<AndesPreparedMessageMetadata> messagesToRestore) {
        this.dequeueList.clear();
        this.preparedDequeueMessages = messagesToRestore;
    }

    public void setMessagesToStore(Collection<AndesMessage> messagesToStore) {
        this.enqueueList.clear();
        this.enqueueList.addAll(messagesToStore);
    }

    void clearEnqueueList() {
        this.enqueueList.clear();
    }

    public List<AndesAckData> getDequeueList() {
        return this.dequeueList;
    }

    public Xid getXid() {
        return this.xid;
    }

    boolean associateSession(UUID sessionID) {
        return this.associatedSessions.put(sessionID, State.ACTIVE) != null;
    }

    boolean disassociateSession(UUID sessionID) {
        return this.associatedSessions.remove(sessionID) != null;
    }

    boolean resumeSession(UUID sessionId) {
        if (this.associatedSessions.containsKey(sessionId) && this.associatedSessions.get(sessionId) == State.SUSPENDED) {
            this.associatedSessions.put(sessionId, State.ACTIVE);
            return true;
        }
        return false;
    }

    boolean isAssociated(UUID sessionId) {
        return this.associatedSessions.containsKey(sessionId);
    }

    UUID getCreatedSessionId() {
        return this.createdSessionId;
    }

    boolean suspendSession(UUID sessionId) {
        State state = this.associatedSessions.get(sessionId);
        if (null != state && state == State.ACTIVE) {
            this.associatedSessions.put(sessionId, State.SUSPENDED);
            return true;
        }
        return false;
    }

    public synchronized void enqueueMessage(AndesMessage andesMessage) {
        this.enqueueList.add(andesMessage);
    }

    boolean hasAssociatedActiveSessions() {
        if (this.hasAssociatedSessions()) {
            for (State state : this.associatedSessions.values()) {
                if (state == State.SUSPENDED) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasAssociatedSessions() {
        return !this.associatedSessions.isEmpty();
    }

    void clearAssociations() {
        this.associatedSessions.clear();
    }

    public boolean expired() {
        return this.timeout != 0L && this._expiration < System.currentTimeMillis() || this.state == State.TIMED_OUT;
    }

    public State getState() {
        return this.state;
    }

    public void persistRecords() throws AndesException {
        LOGGER.debug((Object)("Performing prepare for DtxBranch : " + this.xid));
        this.internalXid = this.dtxRegistry.storeRecords(this);
    }

    public List<AndesPreparedMessageMetadata> getMessagesToRestore() {
        return Collections.unmodifiableList(this.preparedDequeueMessages);
    }

    public void setState(State state) {
        this.state = state;
    }

    void dequeueMessages(List<AndesAckData> ackList) {
        this.dequeueList.addAll(ackList);
    }

    public synchronized void rollback(DisruptorEventCallback callback) throws AndesException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Performing rollback for DtxBranch {}" + this.xid));
        }
        this.callback = callback;
        this.cancelTimeoutTaskIfExists();
        if (this.internalXid != -1L) {
            this.updateSlotCommand = new DtxRollbackCommand();
            this.eventManager.requestDtxEvent(this, null, InboundEventContainer.Type.DTX_ROLLBACK_EVENT);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Cannot rollback since could not find a internal XID {}" + this.xid));
            }
            callback.execute();
        }
    }

    private void cancelTimeoutTaskIfExists() {
        if (this.timeoutFuture != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Attempting to cancel previous timeout task future for DtxBranch " + this.xid));
            }
            boolean succeeded = this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Cancelling previous timeout task {} for DtxBranch " + (succeeded ? "succeeded" : "failed") + this.xid));
            }
        }
    }

    public void commit(DisruptorEventCallback callback, AndesChannel channel, boolean isOnePhaseCommit) throws AndesException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Performing commit for DtxBranch " + this.xid));
        }
        this.cancelTimeoutTaskIfExists();
        this.callback = callback;
        this.updateSlotCommand = new DtxCommitCommand();
        if (isOnePhaseCommit) {
            this.eventManager.requestDtxEvent(this, channel, InboundEventContainer.Type.DTX_ONE_PHASE_COMMIT_EVENT);
        } else {
            this.eventManager.requestDtxEvent(this, channel, InboundEventContainer.Type.DTX_COMMIT_EVENT);
        }
    }

    public void prepare(DisruptorEventCallback callback) {
        this.updateSlotCommand = new DtxPrepareCommand(callback);
        this.traceMessageList(this.enqueueList, "submitting dtx prepare enqueue records to inbound disruptor");
        this.traceAckData(this.dequeueList, "submitting dtx prepare dequeue records to inbound disruptor");
        this.eventManager.requestDtxEvent(this, null, InboundEventContainer.Type.DTX_PREPARE_EVENT);
    }

    private void traceAckData(List<AndesAckData> dequeueList, String description) {
        if (MessageTracer.isEnabled()) {
            for (AndesAckData ackData : dequeueList) {
                MessageTracer.trace(ackData, this.xid, this.state, description);
            }
        }
    }

    public void writeToDbOnCommit() throws AndesException {
        this.dtxRegistry.getStore().updateOnCommit(this.internalXid, this.enqueueList);
        this.traceMessageList(this.enqueueList, "message written to database on dtx.commit");
    }

    public void writeToDbOnOnePhaseCommit() throws AndesException {
        this.dtxRegistry.getStore().updateOnOnePhaseCommit(this.enqueueList, this.dtxRegistry.acknowledgeAndRetrieveDequeueRecords(this));
    }

    public void updateState(InboundEventContainer event) throws AndesException {
        if (event.hasErrorOccurred()) {
            this.callback.onException(new Exception(event.getError()));
        } else {
            this.updateSlotCommand.run();
        }
    }

    private void updateSlotAndClearLists(List<AndesMessage> messageList) {
        try {
            SlotMessageCounter.getInstance().recordMetadataCountInSlot(messageList);
            this.traceMessageList(messageList, "slot information updated for message on dtx.commit");
            this.enqueueList.clear();
            this.dequeueList.clear();
            this.callback.execute();
            this.internalXid = -1L;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Messages state updated. Internal Xid " + this.internalXid));
            }
        }
        catch (Exception exception) {
            this.callback.onException(exception);
        }
    }

    public void writeToDbOnRollback() throws AndesException {
        this.dtxRegistry.getStore().updateOnRollback(this.internalXid, this.preparedDequeueMessages);
        if (MessageTracer.isEnabled()) {
            for (AndesPreparedMessageMetadata preparedMessageMetadata : this.preparedDequeueMessages) {
                MessageTracer.trace(preparedMessageMetadata, this.xid, this.state, "message restored on dtx.rollback with a new message id");
            }
        }
    }

    private void traceMessageList(List<AndesMessage> messageList, String description) {
        if (MessageTracer.isEnabled()) {
            for (AndesMessage message : messageList) {
                MessageTracer.trace(message.getMetadata(), this.xid, this.state, description);
            }
        }
    }

    public void setTimeout(long timeout) {
        this.cancelTimeoutTaskIfExists();
        this.timeout = timeout;
        long l = this._expiration = timeout == 0L ? 0L : System.currentTimeMillis() + 1000L * timeout;
        if (timeout == 0L) {
            this.timeoutFuture = null;
        } else {
            long delay = 1000L * timeout;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Scheduling timeout and rollback after " + timeout + "s for DtxBranch " + this.xid));
            }
            this.timeoutFuture = this.dtxRegistry.scheduleTask(delay, new Runnable(){

                @Override
                public void run() {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Timing out DtxBranch " + DtxBranch.this.xid));
                    }
                    DtxBranch.this.setState(State.TIMED_OUT);
                    try {
                        DtxBranch.this.rollback(new DisruptorEventCallback(){

                            @Override
                            public void execute() {
                            }

                            @Override
                            public void onException(Exception exception) {
                            }
                        });
                    }
                    catch (AndesException e) {
                        LOGGER.error((Object)"Error while rolling back dtx due to store exception");
                    }
                }
            });
        }
    }

    boolean recoverFromStore(String nodeId) throws AndesException {
        this.internalXid = this.dtxRegistry.getStore().recoverBranchData(this, nodeId);
        if (this.internalXid != -1L) {
            this.setState(State.PREPARED);
            return true;
        }
        return false;
    }

    private class DtxPrepareCommand
    implements Runnable {
        private final DisruptorEventCallback callback;

        DtxPrepareCommand(DisruptorEventCallback callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            this.callback.execute();
        }
    }

    private class DtxRollbackCommand
    implements Runnable {
        private DtxRollbackCommand() {
        }

        @Override
        public void run() {
            ArrayList<AndesMessage> dequeuedMessages = new ArrayList<AndesMessage>();
            for (AndesPreparedMessageMetadata metadata : DtxBranch.this.preparedDequeueMessages) {
                dequeuedMessages.add(new AndesMessage(metadata));
            }
            DtxBranch.this.updateSlotAndClearLists(dequeuedMessages);
        }
    }

    private class DtxCommitCommand
    implements Runnable {
        private DtxCommitCommand() {
        }

        @Override
        public void run() {
            DtxBranch.this.updateSlotAndClearLists(DtxBranch.this.enqueueList);
        }
    }

    public static enum State {
        SUSPENDED,
        ACTIVE,
        ROLLBACK_ONLY,
        PREPARED,
        FORGOTTEN,
        TIMED_OUT,
        HEUR_COM,
        PRE_PREPARE,
        HEUR_RB;

    }
}

