/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.dtx;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.transaction.xa.Xid;
import org.apache.commons.lang.StringUtils;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.dtx.AlreadyKnownDtxException;
import org.wso2.andes.kernel.dtx.DtxBranch;
import org.wso2.andes.kernel.dtx.DtxRegistry;
import org.wso2.andes.kernel.dtx.JoinAndResumeDtxException;
import org.wso2.andes.kernel.dtx.NotAssociatedDtxException;
import org.wso2.andes.kernel.dtx.SuspendAndFailDtxException;
import org.wso2.andes.kernel.dtx.UnknownDtxBranchException;
import org.wso2.andes.server.txn.IncorrectDtxStateException;
import org.wso2.andes.server.txn.RollbackOnlyDtxException;
import org.wso2.andes.server.txn.TimeoutDtxException;
import org.wso2.andes.tools.utils.MessageTracer;

public class DistributedTransaction {
    private final long maxTotalMessageSizeAllowed;
    private final DtxRegistry dtxRegistry;
    private DtxBranch branch;
    private final InboundEventManager eventManager;
    private final AndesChannel channel;
    private volatile boolean transactionFailed = false;
    private final ArrayList<String> failedReasons = new ArrayList();
    private long totalMessageSize = 0L;

    public DistributedTransaction(DtxRegistry dtxRegistry, InboundEventManager eventManager, AndesChannel channel) {
        this.dtxRegistry = dtxRegistry;
        this.eventManager = eventManager;
        this.channel = channel;
        this.maxTotalMessageSizeAllowed = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.MAX_TRANSACTION_BATCH_SIZE) * 1024;
    }

    public void start(UUID sessionID, Xid xid, boolean join, boolean resume) throws JoinAndResumeDtxException, UnknownDtxBranchException, AlreadyKnownDtxException, AndesException {
        if (join && resume) {
            throw new JoinAndResumeDtxException(xid);
        }
        DtxBranch branch = this.dtxRegistry.getBranch(xid);
        if (join) {
            if (branch == null) {
                throw new UnknownDtxBranchException(xid);
            }
            this.branch = branch;
            branch.associateSession(sessionID);
        } else if (resume) {
            if (branch == null) {
                throw new UnknownDtxBranchException(xid);
            }
            this.branch = branch;
            branch.resumeSession(sessionID);
        } else {
            if (branch != null) {
                throw new AlreadyKnownDtxException(xid);
            }
            branch = new DtxBranch(sessionID, xid, this.dtxRegistry, this.eventManager);
            if (this.dtxRegistry.registerBranch(branch)) {
                this.branch = branch;
                branch.associateSession(sessionID);
            } else {
                throw new AlreadyKnownDtxException(xid);
            }
        }
    }

    public void end(UUID sessionId, Xid xid, boolean fail, boolean suspend) throws SuspendAndFailDtxException, UnknownDtxBranchException, NotAssociatedDtxException, TimeoutDtxException, AndesException {
        DtxBranch branch = this.dtxRegistry.getBranch(xid);
        if (suspend && fail) {
            branch.disassociateSession(sessionId);
            this.branch = null;
            throw new SuspendAndFailDtxException(xid);
        }
        if (null == branch) {
            throw new UnknownDtxBranchException(xid);
        }
        if (!branch.isAssociated(sessionId)) {
            throw new NotAssociatedDtxException(xid);
        }
        if (branch.expired()) {
            branch.disassociateSession(sessionId);
            throw new TimeoutDtxException(xid);
        }
        if (suspend) {
            branch.suspendSession(sessionId);
        } else {
            if (fail) {
                branch.setState(DtxBranch.State.ROLLBACK_ONLY);
            }
            branch.disassociateSession(sessionId);
        }
        this.branch = null;
    }

    public void dequeue(List<AndesAckData> ackList) throws AndesException {
        if (this.isInsideStartEnd()) {
            this.branch.dequeueMessages(ackList);
        } else {
            for (AndesAckData ackData : ackList) {
                Andes.getInstance().ackReceived(ackData);
            }
        }
    }

    public void commit(Xid xid, boolean onePhase, DisruptorEventCallback callback) throws UnknownDtxBranchException, IncorrectDtxStateException, AndesException, RollbackOnlyDtxException, TimeoutDtxException {
        this.totalMessageSize = 0L;
        this.dtxRegistry.commit(xid, onePhase, callback, this.channel);
    }

    public void enqueueMessage(AndesMessage andesMessage, AndesChannel andesChannel) {
        if (this.isInsideStartEnd()) {
            this.totalMessageSize += (long)andesMessage.getMetadata().getMessageContentLength();
            if (this.totalMessageSize < this.maxTotalMessageSizeAllowed) {
                this.branch.enqueueMessage(andesMessage);
                if (MessageTracer.isEnabled()) {
                    MessageTracer.trace(andesMessage.getMetadata(), this.branch.getXid(), this.branch.getState(), "dtx message enqueued");
                }
            } else if (!this.transactionFailed) {
                this.branch.clearEnqueueList();
                long totalMessageSizeInKB = this.totalMessageSize / 1024L;
                this.failTransaction("Current total message size " + totalMessageSizeInKB + " KB exceeds max total message size allowed per transaction");
            }
        } else {
            QpidAndesBridge.messageReceived(andesMessage, andesChannel);
        }
    }

    public void prepare(Xid xid, DisruptorEventCallback callback) throws TimeoutDtxException, UnknownDtxBranchException, IncorrectDtxStateException, AndesException, RollbackOnlyDtxException {
        if (this.transactionFailed) {
            DtxBranch branch = this.dtxRegistry.getBranch(xid);
            if (branch != null) {
                branch.setState(DtxBranch.State.ROLLBACK_ONLY);
                String reason = "Transaction " + xid + " may only be rolled back due to: ";
                reason = reason + StringUtils.join(this.failedReasons, (String)",");
                throw new RollbackOnlyDtxException(reason);
            }
            throw new UnknownDtxBranchException(xid);
        }
        this.dtxRegistry.prepare(xid, callback);
    }

    public void rollback(Xid xid, DisruptorEventCallback callback) throws UnknownDtxBranchException, AndesException, TimeoutDtxException, IncorrectDtxStateException {
        this.totalMessageSize = 0L;
        this.transactionFailed = false;
        this.failedReasons.clear();
        this.dtxRegistry.rollback(xid, callback);
    }

    public void close(UUID sessionId) {
        this.dtxRegistry.close(sessionId);
    }

    public void failTransaction(String reason) {
        if (this.isInsideStartEnd()) {
            this.transactionFailed = true;
            this.failedReasons.add(reason);
        }
    }

    private boolean isInsideStartEnd() {
        return this.branch != null;
    }

    public void forget(Xid xid) throws UnknownDtxBranchException, IncorrectDtxStateException, AndesException {
        this.dtxRegistry.forget(xid);
    }

    public void setTimeout(Xid xid, long timeout) throws UnknownDtxBranchException, AndesException {
        this.dtxRegistry.setTimeout(xid, timeout);
    }
}

