/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.lmax.disruptor.EventHandler;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessageStatus;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventContainer;
import org.wso2.andes.kernel.slot.SlotMessageCounter;
import org.wso2.andes.tools.utils.MessageTracer;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Meter;
import org.wso2.carbon.metrics.manager.MetricManager;

public class StateEventHandler
implements EventHandler<InboundEventContainer> {
    private static Log log = LogFactory.getLog(StateEventHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEvent(InboundEventContainer event, long sequence, boolean endOfBatch) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[ sequence " + sequence + " ] Event received from disruptor. Event type: " + event.eventInfo()));
        }
        try {
            switch (event.getEventType()) {
                case MESSAGE_EVENT: {
                    this.updateSlotsAndQueueCounts(event);
                    event.clearMessageList(event.getChannel());
                    return;
                }
                case TRANSACTION_COMMIT_EVENT: {
                    event.updateState();
                    event.clearMessageList(event.getChannel());
                    return;
                }
                case ACKNOWLEDGEMENT_EVENT: {
                    this.updateTrackerWithAck(event);
                    return;
                }
                case SAFE_ZONE_DECLARE_EVENT: {
                    this.updateSlotDeleteSafeZone(event);
                    return;
                }
                default: {
                    event.updateState();
                    return;
                }
            }
        }
        finally {
            event.clear();
        }
    }

    private void updateTrackerWithAck(InboundEventContainer event) throws AndesException {
        DeliverableAndesMetadata acknowledgedMessage = event.ackData.getMetadataReference();
        if (acknowledgedMessage.getLatestState().equals((Object)MessageStatus.DELETED) && event.ackData.isBaringMessageRemovable()) {
            acknowledgedMessage.getSlot().decrementPendingMessageCount();
        }
    }

    private void updateSlotDeleteSafeZone(InboundEventContainer event) {
        long currentSafeZoneVal = event.getSafeZoneLimit();
        SlotMessageCounter.getInstance().updateSafeZoneForNode(currentSafeZoneVal);
    }

    public void updateSlotsAndQueueCounts(InboundEventContainer eventContainer) {
        List<AndesMessage> messageList = eventContainer.getMessageList();
        SlotMessageCounter.getInstance().recordMetadataCountInSlot(messageList);
        for (AndesMessage message : messageList) {
            MessageTracer.trace(message, "slot information updated");
            Meter ackMeter = MetricManager.meter((String)"org.wso2.mb.ack.sent", (Level[])new Level[]{Level.INFO});
            ackMeter.mark();
        }
        if (messageList.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Acknowledging to the publisher " + eventContainer.getChannel()));
            }
            eventContainer.pubAckHandler.ack(messageList.get(0).getMetadata());
        }
        if (log.isTraceEnabled()) {
            StringBuilder messageIds = new StringBuilder();
            for (AndesMessage message : messageList) {
                messageIds.append(message.getMetadata().getMessageID()).append(" , ");
            }
            log.debug((Object)("Messages STATE UPDATED: " + messageIds));
        }
    }
}

